/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.Activity;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.ImportAp;
import gov.nist.secauto.oscal.lib.model.LocalObjective;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.OscalArModule;
import gov.nist.secauto.oscal.lib.model.Result;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Security Assessment Results (SAR)", description="Security assessment results, such as those provided by a FedRAMP assessor in the FedRAMP Security Assessment Report.", name="assessment-results", moduleClass=OscalArModule.class, rootName="assessment-results")
public class AssessmentResults
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Assessment Results Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this assessment results instance in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ar-identifiers). The locally defined *UUID* of the `assessment result` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import Assessment Plan", description="Used by assessment-results to import information about the original plan for assessing the system.", useName="import-ap", remarks="Used by the SAR to import information about the original plan for assessing the system.", minOccurs=1)
    private ImportAp _importAp;
    @BoundAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", useName="local-definitions")
    private LocalDefinitions _localDefinitions;
    @BoundAssembly(formalName="Assessment Result", description="Used by the assessment results and POA\\&M. In the assessment results, this identifies all of the assessment observations and findings, initial and residual risks, deviations, and disposition. In the POA\\&M, this identifies initial and residual risks, deviations, and disposition.", useName="result", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="results", inJson=JsonGroupAsBehavior.LIST))
    private List<Result> _results;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public AssessmentResults() {
        this(null);
    }

    public AssessmentResults(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public ImportAp getImportAp() {
        return this._importAp;
    }

    public void setImportAp(ImportAp value) {
        this._importAp = value;
    }

    public LocalDefinitions getLocalDefinitions() {
        return this._localDefinitions;
    }

    public void setLocalDefinitions(LocalDefinitions value) {
        this._localDefinitions = value;
    }

    public List<Result> getResults() {
        return this._results;
    }

    public void setResults(List<Result> value) {
        this._results = value;
    }

    public boolean addResult(Result item) {
        Result value = (Result)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._results == null) {
            this._results = new LinkedList<Result>();
        }
        return this._results.add(value);
    }

    public boolean removeResult(Result item) {
        Result value = (Result)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._results != null && this._results.remove(value);
    }

    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", name="local-definitions", moduleClass=OscalArModule.class)
    public static class LocalDefinitions
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Assessment-Specific Control Objective", description="A local definition of a control objective for this assessment. Uses catalog syntax for control objective and assessment actions.", useName="objectives-and-methods", maxOccurs=-1, groupAs=@GroupAs(name="objectives-and-methods", inJson=JsonGroupAsBehavior.LIST))
        private List<LocalObjective> _objectivesAndMethods;
        @BoundAssembly(formalName="Activity", description="Identifies an assessment or related process that can be performed. In the assessment plan, this is an intended activity which may be associated with an assessment task. In the assessment results, this an activity that was actually performed as part of an assessment.", useName="activity", maxOccurs=-1, groupAs=@GroupAs(name="activities", inJson=JsonGroupAsBehavior.LIST))
        private List<Activity> _activities;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public LocalDefinitions() {
            this(null);
        }

        public LocalDefinitions(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<LocalObjective> getObjectivesAndMethods() {
            return this._objectivesAndMethods;
        }

        public void setObjectivesAndMethods(List<LocalObjective> value) {
            this._objectivesAndMethods = value;
        }

        public boolean addObjectivesAndMethods(LocalObjective item) {
            LocalObjective value = (LocalObjective)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._objectivesAndMethods == null) {
                this._objectivesAndMethods = new LinkedList<LocalObjective>();
            }
            return this._objectivesAndMethods.add(value);
        }

        public boolean removeObjectivesAndMethods(LocalObjective item) {
            LocalObjective value = (LocalObjective)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._objectivesAndMethods != null && this._objectivesAndMethods.remove(value);
        }

        public List<Activity> getActivities() {
            return this._activities;
        }

        public void setActivities(List<Activity> value) {
            this._activities = value;
        }

        public boolean addActivity(Activity item) {
            Activity value = (Activity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._activities == null) {
                this._activities = new LinkedList<Activity>();
            }
            return this._activities.add(value);
        }

        public boolean removeActivity(Activity item) {
            Activity value = (Activity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._activities != null && this._activities.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

