/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.IncludeAll;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SelectSubjectById;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", name="assessment-subject", moduleClass=OscalAssessmentCommonModule.class, remarks="Processing of an include/exclude pair starts with processing the include, then removing matching entries in the exclude.")
public class AssessmentSubject
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Subject Type", description="Indicates the type of assessment subject, such as a component, inventory, item, location, or party represented by this selection statement.", name="type", required=true, typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="component", description="The referenced assessment subject is a component defined in the SSP, or in the `local-definitions` of an Assessment Plan or Assessment Results."), @AllowedValue(value="inventory-item", description="The referenced assessment subject is a inventory item defined in the SSP, or in the `local-definitions` of an Assessment Plan or Assessment Results."), @AllowedValue(value="location", description="The referenced assessment subject is a `location` defined in the `metadata` of the SSP, Assessment Plan, or Assessment Results."), @AllowedValue(value="party", description="The referenced assessment subject is a person or team to interview, who is defined as a `party` in the `metadata` of the SSP, Assessment Plan, or Assessment Results."), @AllowedValue(value="user", description="The referenced assessment subject is a `user` defined in the SSP, or in the `local-definitions` of an Assessment Plan or Assessment Results.")})}))
    private String _type;
    @BoundField(formalName="Include Subjects Description", description="A human-readable description of the collection of subjects being included in this assessment.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Include All", description="Include all controls from the imported catalog or profile resources.", useName="include-all", minOccurs=1)
    private IncludeAll _includeAll;
    @BoundAssembly(formalName="Select Assessment Subject", description="Identifies a set of assessment subjects to include/exclude by UUID.", useName="include-subject", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="include-subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<SelectSubjectById> _includeSubjects;
    @BoundAssembly(formalName="Select Assessment Subject", description="Identifies a set of assessment subjects to include/exclude by UUID.", useName="exclude-subject", maxOccurs=-1, groupAs=@GroupAs(name="exclude-subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<SelectSubjectById> _excludeSubjects;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public AssessmentSubject() {
        this(null);
    }

    public AssessmentSubject(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public IncludeAll getIncludeAll() {
        return this._includeAll;
    }

    public void setIncludeAll(IncludeAll value) {
        this._includeAll = value;
    }

    public List<SelectSubjectById> getIncludeSubjects() {
        return this._includeSubjects;
    }

    public void setIncludeSubjects(List<SelectSubjectById> value) {
        this._includeSubjects = value;
    }

    public boolean addIncludeSubject(SelectSubjectById item) {
        SelectSubjectById value = (SelectSubjectById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._includeSubjects == null) {
            this._includeSubjects = new LinkedList<SelectSubjectById>();
        }
        return this._includeSubjects.add(value);
    }

    public boolean removeIncludeSubject(SelectSubjectById item) {
        SelectSubjectById value = (SelectSubjectById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._includeSubjects != null && this._includeSubjects.remove(value);
    }

    public List<SelectSubjectById> getExcludeSubjects() {
        return this._excludeSubjects;
    }

    public void setExcludeSubjects(List<SelectSubjectById> value) {
        this._excludeSubjects = value;
    }

    public boolean addExcludeSubject(SelectSubjectById item) {
        SelectSubjectById value = (SelectSubjectById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._excludeSubjects == null) {
            this._excludeSubjects = new LinkedList<SelectSubjectById>();
        }
        return this._excludeSubjects.add(value);
    }

    public boolean removeExcludeSubject(SelectSubjectById item) {
        SelectSubjectById value = (SelectSubjectById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._excludeSubjects != null && this._excludeSubjects.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

