/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Privilege", description="Identifies a specific system privilege held by the user, along with an associated description and/or rationale for the privilege.", name="authorized-privilege", moduleClass=OscalImplementationCommonModule.class)
public class AuthorizedPrivilege
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Privilege Title", description="A human readable name for the privilege.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Privilege Description", description="A summary of the privilege's purpose within the system.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundField(formalName="Functions Performed", description="Describes a function performed for a given authorized privilege by this user class.", useName="function-performed", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="functions-performed", inJson=JsonGroupAsBehavior.LIST))
    private List<String> _functionsPerformed;

    public AuthorizedPrivilege() {
        this(null);
    }

    public AuthorizedPrivilege(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<String> getFunctionsPerformed() {
        return this._functionsPerformed;
    }

    public void setFunctionsPerformed(List<String> value) {
        this._functionsPerformed = value;
    }

    public boolean addFunctionPerformed(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._functionsPerformed == null) {
            this._functionsPerformed = new LinkedList<String>();
        }
        return this._functionsPerformed.add(value);
    }

    public boolean removeFunctionPerformed(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._functionsPerformed != null && this._functionsPerformed.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

