/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.Base64Adapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.DocumentId;
import gov.nist.secauto.oscal.lib.model.Hash;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractBackMatter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", name="back-matter", moduleClass=OscalMetadataModule.class, remarks="Provides a collection of identified `resource` objects that can be referenced by a `link` with a `rel` value of \"reference\" and an `href` value that is a fragment \"#\" followed by a reference to a reference's `uuid`. Other specialized link \"rel\" values also use this pattern when indicated in that context of use.", modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="resource", name="index-back-matter-resource", keyFields={@KeyField(target="@uuid")})}))
public class BackMatter
extends AbstractBackMatter
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Resource", description="A resource associated with content in the containing document instance. A resource may be directly included in the document using base64 encoding or may point to one or more equivalent internet resources.", useName="resource", remarks="A resource can be used in two ways. 1) it may point to an specific retrievable network resource using a `rlink`, or 2) it may be included as an attachment using a `base64`. A resource may contain multiple `rlink` and `base64` entries that represent alternative download locations (rlink) and attachments (base64) for the same resource.\n\nBoth rlink and base64 allow for a `media-type` to be specified, which is used to distinguish between different representations of the same resource (e.g., Microsoft Word, PDF). When multiple `rlink` and `base64` items are included for a given resource, all items must contain equivalent information. This allows the document consumer to choose a preferred item to process based on a the selected item's `media-type`. This is extremely important when the items represent OSCAL content that is represented in alternate formats (i.e., XML, JSON, YAML), allowing the same OSCAL data to be processed from any of the available formats indicated by the items.\n\nWhen a resource includes a citation, then the `title` and `citation` properties must both be included.", maxOccurs=-1, groupAs=@GroupAs(name="resources", inJson=JsonGroupAsBehavior.LIST))
    private List<Resource> _resources;

    public BackMatter() {
        this(null);
    }

    public BackMatter(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public List<Resource> getResources() {
        return this._resources;
    }

    public void setResources(List<Resource> value) {
        this._resources = value;
    }

    public boolean addResource(Resource item) {
        Resource value = (Resource)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._resources == null) {
            this._resources = new LinkedList<Resource>();
        }
        return this._resources.add(value);
    }

    public boolean removeResource(Resource item) {
        Resource value = (Resource)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._resources != null && this._resources.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Resource", description="A resource associated with content in the containing document instance. A resource may be directly included in the document using base64 encoding or may point to one or more equivalent internet resources.", name="resource", moduleClass=OscalMetadataModule.class, remarks="A resource can be used in two ways. 1) it may point to an specific retrievable network resource using a `rlink`, or 2) it may be included as an attachment using a `base64`. A resource may contain multiple `rlink` and `base64` entries that represent alternative download locations (rlink) and attachments (base64) for the same resource.\n\nBoth rlink and base64 allow for a `media-type` to be specified, which is used to distinguish between different representations of the same resource (e.g., Microsoft Word, PDF). When multiple `rlink` and `base64` items are included for a given resource, all items must contain equivalent information. This allows the document consumer to choose a preferred item to process based on a the selected item's `media-type`. This is extremely important when the items represent OSCAL content that is represented in alternate formats (i.e., XML, JSON, YAML), allowing the same OSCAL data to be processed from any of the available formats indicated by the items.\n\nWhen a resource includes a citation, then the `title` and `citation` properties must both be included.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="type", description="Identifies the type of resource represented. The most specific appropriate type value SHOULD be used."), @AllowedValue(value="version", description="For resources representing a published document, this represents the version number of that document."), @AllowedValue(value="published", description="For resources representing a published document, this represents the publication date of that document.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type']/@value", values={@AllowedValue(value="logo", description="Indicates the resource is an organization's logo."), @AllowedValue(value="image", description="Indicates the resource represents an image."), @AllowedValue(value="screen-shot", description="Indicates the resource represents an image of screen content."), @AllowedValue(value="law", description="Indicates the resource represents an applicable law."), @AllowedValue(value="regulation", description="Indicates the resource represents an applicable regulation."), @AllowedValue(value="standard", description="Indicates the resource represents an applicable standard."), @AllowedValue(value="external-guidance", description="Indicates the resource represents applicable guidance."), @AllowedValue(value="acronyms", description="Indicates the resource provides a list of relevant acronyms."), @AllowedValue(value="citation", description="Indicates the resource cites relevant information."), @AllowedValue(value="policy", description="Indicates the resource is a policy."), @AllowedValue(value="procedure", description="Indicates the resource is a procedure."), @AllowedValue(value="system-guide", description="Indicates the resource is guidance document related to the subject system of an SSP."), @AllowedValue(value="users-guide", description="Indicates the resource is guidance document a user's guide or administrator's guide."), @AllowedValue(value="administrators-guide", description="Indicates the resource is guidance document a administrator's guide."), @AllowedValue(value="rules-of-behavior", description="Indicates the resource represents rules of behavior content."), @AllowedValue(value="plan", description="Indicates the resource represents a plan."), @AllowedValue(value="artifact", description="Indicates the resource represents an artifact, such as may be reviewed by an assessor."), @AllowedValue(value="evidence", description="Indicates the resource represents evidence, such as to support an assessment finding."), @AllowedValue(value="tool-output", description="Indicates the resource represents output from a tool."), @AllowedValue(value="raw-data", description="Indicates the resource represents machine data, which may require a tool or analysis for interpretation or presentation."), @AllowedValue(value="interview-notes", description="Indicates the resource represents notes from an interview, such as may be collected during an assessment."), @AllowedValue(value="questionnaire", description="Indicates the resource is a set of questions, possibly with responses."), @AllowedValue(value="report", description="Indicates the resource is a report."), @AllowedValue(value="agreement", description="Indicates the resource is a formal agreement between two or more parties.")})}, matches={@Matches(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='published']/@value", typeAdapter=DateTimeWithTZAdapter.class)}, expect={@Expect(description="A `title` is required when a `citation` is provided.", level=IConstraint.Level.ERROR, target=".[citation]", test="title")}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-resource-rlink-href", description="Ensure that each rlink item references a unique resource.", level=IConstraint.Level.ERROR, target="rlink", keyFields={@KeyField(target="@href"), @KeyField(target="@media-type")}), @IsUnique(id="unique-resource-base64-filename", description="Ensure that all base64 resources have a unique `filename`.", level=IConstraint.Level.ERROR, target="base64", keyFields={@KeyField(target="@filename")})}, cardinality={@HasCardinality(description="A resource should provide at least an `rlink` or `base64` object.", level=IConstraint.Level.WARNING, target="rlink|base64", minOccurs=1)}))
    public static class Resource
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Resource Universally Unique Identifier", description="A unique identifier for a resource.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundField(formalName="Resource Title", description="An optional name given to the resource, which may be used by a tool for display and navigation.", useName="title", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundField(formalName="Resource Description", description="An optional short summary of the resource used to indicate the purpose of the resource.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundField(formalName="Document Identifier", description="A document identifier qualified by an identifier `scheme`.", useName="document-id", maxOccurs=-1, groupAs=@GroupAs(name="document-ids", inJson=JsonGroupAsBehavior.LIST))
        private List<DocumentId> _documentIds;
        @BoundAssembly(formalName="Citation", description="An optional citation consisting of end note text using structured markup.", useName="citation")
        private Citation _citation;
        @BoundAssembly(formalName="Resource link", description="A URL-based pointer to an external resource with an optional hash for verification and change detection.", useName="rlink", remarks="Multiple `rlink` objects can be included for a resource. In such a case, all provided `rlink` items are intended to be equivalent in content, but may differ in structure or format.\n\nA `media-type` is used to identify the format of a given rlink, and can be used to differentiate items in a collection of rlinks. The `media-type` provides a hint to the OSCAL document consumer about the structure of the resource referenced by the `rlink`.", maxOccurs=-1, groupAs=@GroupAs(name="rlinks", inJson=JsonGroupAsBehavior.LIST))
        private List<Rlink> _rlinks;
        @BoundField(formalName="Base64", description="A resource encoded using the Base64 alphabet defined by [RFC 2045](https://www.rfc-editor.org/rfc/rfc2045.html).", useName="base64")
        private Base64 _base64;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Resource() {
            this(null);
        }

        public Resource(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<DocumentId> getDocumentIds() {
            return this._documentIds;
        }

        public void setDocumentIds(List<DocumentId> value) {
            this._documentIds = value;
        }

        public boolean addDocumentId(DocumentId item) {
            DocumentId value = (DocumentId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._documentIds == null) {
                this._documentIds = new LinkedList<DocumentId>();
            }
            return this._documentIds.add(value);
        }

        public boolean removeDocumentId(DocumentId item) {
            DocumentId value = (DocumentId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._documentIds != null && this._documentIds.remove(value);
        }

        public Citation getCitation() {
            return this._citation;
        }

        public void setCitation(Citation value) {
            this._citation = value;
        }

        public List<Rlink> getRlinks() {
            return this._rlinks;
        }

        public void setRlinks(List<Rlink> value) {
            this._rlinks = value;
        }

        public boolean addRlink(Rlink item) {
            Rlink value = (Rlink)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._rlinks == null) {
                this._rlinks = new LinkedList<Rlink>();
            }
            return this._rlinks.add(value);
        }

        public boolean removeRlink(Rlink item) {
            Rlink value = (Rlink)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._rlinks != null && this._rlinks.remove(value);
        }

        public Base64 getBase64() {
            return this._base64;
        }

        public void setBase64(Base64 value) {
            this._base64 = value;
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Citation", description="An optional citation consisting of end note text using structured markup.", name="citation", moduleClass=OscalMetadataModule.class)
        public static class Citation
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundField(formalName="Citation Text", description="A line of citation text.", useName="text", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
            private MarkupLine _text;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;

            public Citation() {
                this(null);
            }

            public Citation(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public MarkupLine getText() {
                return this._text;
            }

            public void setText(MarkupLine value) {
                this._text = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaAssembly(formalName="Resource link", description="A URL-based pointer to an external resource with an optional hash for verification and change detection.", name="rlink", moduleClass=OscalMetadataModule.class, remarks="Multiple `rlink` objects can be included for a resource. In such a case, all provided `rlink` items are intended to be equivalent in content, but may differ in structure or format.\n\nA `media-type` is used to identify the format of a given rlink, and can be used to differentiate items in a collection of rlinks. The `media-type` provides a hint to the OSCAL document consumer about the structure of the resource referenced by the `rlink`.")
        public static class Rlink
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Hypertext Reference", description="A resolvable URL pointing to the referenced resource.", name="href", required=true, typeAdapter=UriReferenceAdapter.class, remarks="This value may be either:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or")
            private URI _href;
            @BoundFlag(formalName="Media Type", description="A label that indicates the nature of a resource, as a data serialization or format.", name="media-type", typeAdapter=StringAdapter.class)
            private String _mediaType;
            @BoundField(formalName="Hash", description="A hash of the resource identified by `href`, which can be used to verify the resource was not changed since it was hashed.", useName="hash", remarks="The `hash` value can be used to confirm that the resource referenced by the `href` is the same resources that was hashed by retrieving the resource, calculating a hash, and comparing the result to this value.", maxOccurs=-1, groupAs=@GroupAs(name="hashes", inJson=JsonGroupAsBehavior.LIST))
            private List<Hash> _hashes;

            public Rlink() {
                this(null);
            }

            public Rlink(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public URI getHref() {
                return this._href;
            }

            public void setHref(URI value) {
                this._href = value;
            }

            public String getMediaType() {
                return this._mediaType;
            }

            public void setMediaType(String value) {
                this._mediaType = value;
            }

            public List<Hash> getHashes() {
                return this._hashes;
            }

            public void setHashes(List<Hash> value) {
                this._hashes = value;
            }

            public boolean addHash(Hash item) {
                Hash value = (Hash)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._hashes == null) {
                    this._hashes = new LinkedList<Hash>();
                }
                return this._hashes.add(value);
            }

            public boolean removeHash(Hash item) {
                Hash value = (Hash)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._hashes != null && this._hashes.remove(value);
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaField(formalName="Base64", description="A resource encoded using the Base64 alphabet defined by [RFC 2045](https://www.rfc-editor.org/rfc/rfc2045.html).", name="base64", moduleClass=OscalMetadataModule.class)
        public static class Base64
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="File Name", description="Name of the file before it was encoded as Base64 to be embedded in a `resource`. This is the name that will be assigned to the file when the file is decoded.", name="filename", typeAdapter=TokenAdapter.class)
            private String _filename;
            @BoundFlag(formalName="Media Type", description="A label that indicates the nature of a resource, as a data serialization or format.", name="media-type", typeAdapter=StringAdapter.class)
            private String _mediaType;
            @BoundFieldValue(valueKeyName="value", typeAdapter=Base64Adapter.class)
            private ByteBuffer _value;

            public Base64() {
                this(null);
            }

            public Base64(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public String getFilename() {
                return this._filename;
            }

            public void setFilename(String value) {
                this._filename = value;
            }

            public String getMediaType() {
                return this._mediaType;
            }

            public void setMediaType(String value) {
                this._mediaType = value;
            }

            public ByteBuffer getValue() {
                return this._value;
            }

            public void setValue(ByteBuffer value) {
                this._value = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

