/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ImplementationStatus;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import gov.nist.secauto.oscal.lib.model.SetParameter;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Component Control Implementation", description="Defines how the referenced component implements a set of controls.", name="by-component", moduleClass=OscalSspModule.class, remarks="Use of `set-parameter` in this context, sets the parameter for the control referenced in the containing `implemented-requirement` applied to the referenced component. If the `by-component` is used as a child of a `statement`, then the parameter value also applies only in the context of the referenced statement. If the same parameter is also set in the `control-implementation` or a specific `implemented-requirement`, then this `by-component/set-parameter` value will override the other value(s) in the context of the referenced component, control, and statement (if parent).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="imported-from", description="The hyperlink identifies a URI pointing to the `component` in a `component-definition` that originally described the `component` this component was based on.")}), @AllowedValues(level=IConstraint.Level.ERROR, target=".//responsible-role/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset."), @AllowedValue(value="maintainer", description="Responsible for the creation and maintenance of a component."), @AllowedValue(value="provider", description="Organization responsible for providing the component, if this is different from the \"maintainer\" (e.g., a reseller).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="provided-by", description="A reference to the UUID of a control or statement `by-component` object that is used as evidence of implementation.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="link[@rel='provided-by']", indexName="by-component-uuid", keyFields={@KeyField(target="@href", pattern="#(.*)")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-by-component-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once.")}))
public class ByComponent
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Component Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to the `component` that is implemeting a given control.", name="component-uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _componentUuid;
    @BoundFlag(formalName="By-Component Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this by-component entry elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `by-component` entry can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Control Implementation Description", description="An implementation statement that describes how a control or a control statement is implemented within the referenced system component.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<SetParameter> _setParameters;
    @BoundAssembly(formalName="Implementation Status", description="Indicates the degree to which the a given control is implemented.", useName="implementation-status", remarks="The `implementation-status` is used to qualify the `status` value to indicate the degree to which the control is implemented.")
    private ImplementationStatus _implementationStatus;
    @BoundAssembly(formalName="Export", description="Identifies content intended for external consumption, such as with leveraged organizations.", useName="export")
    private Export _export;
    @BoundAssembly(formalName="Inherited Control Implementation", description="Describes a control implementation inherited by a leveraging system.", useName="inherited", maxOccurs=-1, groupAs=@GroupAs(name="inherited", inJson=JsonGroupAsBehavior.LIST))
    private List<Inherited> _inherited;
    @BoundAssembly(formalName="Satisfied Control Implementation Responsibility", description="Describes how this system satisfies a responsibility imposed by a leveraged system.", useName="satisfied", maxOccurs=-1, groupAs=@GroupAs(name="satisfied", inJson=JsonGroupAsBehavior.LIST))
    private List<Satisfied> _satisfied;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public ByComponent() {
        this(null);
    }

    public ByComponent(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getComponentUuid() {
        return this._componentUuid;
    }

    public void setComponentUuid(UUID value) {
        this._componentUuid = value;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<SetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<SetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<SetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public ImplementationStatus getImplementationStatus() {
        return this._implementationStatus;
    }

    public void setImplementationStatus(ImplementationStatus value) {
        this._implementationStatus = value;
    }

    public Export getExport() {
        return this._export;
    }

    public void setExport(Export value) {
        this._export = value;
    }

    public List<Inherited> getInherited() {
        return this._inherited;
    }

    public void setInherited(List<Inherited> value) {
        this._inherited = value;
    }

    public boolean addInherited(Inherited item) {
        Inherited value = (Inherited)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._inherited == null) {
            this._inherited = new LinkedList<Inherited>();
        }
        return this._inherited.add(value);
    }

    public boolean removeInherited(Inherited item) {
        Inherited value = (Inherited)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._inherited != null && this._inherited.remove(value);
    }

    public List<Satisfied> getSatisfied() {
        return this._satisfied;
    }

    public void setSatisfied(List<Satisfied> value) {
        this._satisfied = value;
    }

    public boolean addSatisfied(Satisfied item) {
        Satisfied value = (Satisfied)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._satisfied == null) {
            this._satisfied = new LinkedList<Satisfied>();
        }
        return this._satisfied.add(value);
    }

    public boolean removeSatisfied(Satisfied item) {
        Satisfied value = (Satisfied)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._satisfied != null && this._satisfied.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Export", description="Identifies content intended for external consumption, such as with leveraged organizations.", name="export", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="responsibility", indexName="by-component-export-provided-uuid", keyFields={@KeyField(target="@provided-uuid")})}), modelConstraints=@AssemblyConstraints(cardinality={@HasCardinality(level=IConstraint.Level.ERROR, target="provided|responsibility", minOccurs=1)}))
    public static class Export
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundField(formalName="Control Implementation Export Description", description="An implementation statement that describes the aspects of the control or control statement implementation that can be available to another system leveraging this system.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Provided Control Implementation", description="Describes a capability which may be inherited by a leveraging system.", useName="provided", maxOccurs=-1, groupAs=@GroupAs(name="provided", inJson=JsonGroupAsBehavior.LIST))
        private List<Provided> _provided;
        @BoundAssembly(formalName="Control Implementation Responsibility", description="Describes a control implementation responsibility imposed on a leveraging system.", useName="responsibility", maxOccurs=-1, groupAs=@GroupAs(name="responsibilities", inJson=JsonGroupAsBehavior.LIST))
        private List<Responsibility> _responsibilities;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Export() {
            this(null);
        }

        public Export(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<Provided> getProvided() {
            return this._provided;
        }

        public void setProvided(List<Provided> value) {
            this._provided = value;
        }

        public boolean addProvided(Provided item) {
            Provided value = (Provided)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._provided == null) {
                this._provided = new LinkedList<Provided>();
            }
            return this._provided.add(value);
        }

        public boolean removeProvided(Provided item) {
            Provided value = (Provided)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._provided != null && this._provided.remove(value);
        }

        public List<Responsibility> getResponsibilities() {
            return this._responsibilities;
        }

        public void setResponsibilities(List<Responsibility> value) {
            this._responsibilities = value;
        }

        public boolean addResponsibility(Responsibility item) {
            Responsibility value = (Responsibility)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibilities == null) {
                this._responsibilities = new LinkedList<Responsibility>();
            }
            return this._responsibilities.add(value);
        }

        public boolean removeResponsibility(Responsibility item) {
            Responsibility value = (Responsibility)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibilities != null && this._responsibilities.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Provided Control Implementation", description="Describes a capability which may be inherited by a leveraging system.", name="provided", moduleClass=OscalSspModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-provided-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
        public static class Provided
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Provided Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this provided entry elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `provided` entry can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
            private UUID _uuid;
            @BoundField(formalName="Provided Control Implementation Description", description="An implementation statement that describes the aspects of the control or control statement implementation that can be provided to another system leveraging this system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _description;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
            private List<ResponsibleRole> _responsibleRoles;
            @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _remarks;

            public Provided() {
                this(null);
            }

            public Provided(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public UUID getUuid() {
                return this._uuid;
            }

            public void setUuid(UUID value) {
                this._uuid = value;
            }

            public MarkupMultiline getDescription() {
                return this._description;
            }

            public void setDescription(MarkupMultiline value) {
                this._description = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<ResponsibleRole> getResponsibleRoles() {
                return this._responsibleRoles;
            }

            public void setResponsibleRoles(List<ResponsibleRole> value) {
                this._responsibleRoles = value;
            }

            public boolean addResponsibleRole(ResponsibleRole item) {
                ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._responsibleRoles == null) {
                    this._responsibleRoles = new LinkedList<ResponsibleRole>();
                }
                return this._responsibleRoles.add(value);
            }

            public boolean removeResponsibleRole(ResponsibleRole item) {
                ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._responsibleRoles != null && this._responsibleRoles.remove(value);
            }

            public MarkupMultiline getRemarks() {
                return this._remarks;
            }

            public void setRemarks(MarkupMultiline value) {
                this._remarks = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaAssembly(formalName="Control Implementation Responsibility", description="Describes a control implementation responsibility imposed on a leveraging system.", name="responsibility", moduleClass=OscalSspModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-responsibility-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
        public static class Responsibility
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Responsibility Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this responsibility elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `responsibility` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
            private UUID _uuid;
            @BoundFlag(formalName="Provided UUID", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an inherited control implementation that a leveraging system is inheriting from a leveraged system.", name="provided-uuid", typeAdapter=UuidAdapter.class)
            private UUID _providedUuid;
            @BoundField(formalName="Control Implementation Responsibility Description", description="An implementation statement that describes the aspects of the control or control statement implementation that a leveraging system must implement to satisfy the control provided by a leveraged system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _description;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", remarks="A role defined at the by-component level takes precedence over the same role defined on the parent implemented-requirement or on the referenced component.", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
            private List<ResponsibleRole> _responsibleRoles;
            @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _remarks;

            public Responsibility() {
                this(null);
            }

            public Responsibility(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public UUID getUuid() {
                return this._uuid;
            }

            public void setUuid(UUID value) {
                this._uuid = value;
            }

            public UUID getProvidedUuid() {
                return this._providedUuid;
            }

            public void setProvidedUuid(UUID value) {
                this._providedUuid = value;
            }

            public MarkupMultiline getDescription() {
                return this._description;
            }

            public void setDescription(MarkupMultiline value) {
                this._description = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<ResponsibleRole> getResponsibleRoles() {
                return this._responsibleRoles;
            }

            public void setResponsibleRoles(List<ResponsibleRole> value) {
                this._responsibleRoles = value;
            }

            public boolean addResponsibleRole(ResponsibleRole item) {
                ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._responsibleRoles == null) {
                    this._responsibleRoles = new LinkedList<ResponsibleRole>();
                }
                return this._responsibleRoles.add(value);
            }

            public boolean removeResponsibleRole(ResponsibleRole item) {
                ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._responsibleRoles != null && this._responsibleRoles.remove(value);
            }

            public MarkupMultiline getRemarks() {
                return this._remarks;
            }

            public void setRemarks(MarkupMultiline value) {
                this._remarks = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }

    @MetaschemaAssembly(formalName="Inherited Control Implementation", description="Describes a control implementation inherited by a leveraging system.", name="inherited", moduleClass=OscalSspModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-inherited-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
    public static class Inherited
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Inherited Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this inherited entry elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `inherited control implementation` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundFlag(formalName="Provided UUID", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an inherited control implementation that a leveraging system is inheriting from a leveraged system.", name="provided-uuid", typeAdapter=UuidAdapter.class)
        private UUID _providedUuid;
        @BoundField(formalName="Inherited Control Implementation Description", description="An implementation statement that describes the aspects of a control or control statement implementation that a leveraging system is inheriting from a leveraged system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
        private List<ResponsibleRole> _responsibleRoles;

        public Inherited() {
            this(null);
        }

        public Inherited(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public UUID getProvidedUuid() {
            return this._providedUuid;
        }

        public void setProvidedUuid(UUID value) {
            this._providedUuid = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<ResponsibleRole> getResponsibleRoles() {
            return this._responsibleRoles;
        }

        public void setResponsibleRoles(List<ResponsibleRole> value) {
            this._responsibleRoles = value;
        }

        public boolean addResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibleRoles == null) {
                this._responsibleRoles = new LinkedList<ResponsibleRole>();
            }
            return this._responsibleRoles.add(value);
        }

        public boolean removeResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibleRoles != null && this._responsibleRoles.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Satisfied Control Implementation Responsibility", description="Describes how this system satisfies a responsibility imposed by a leveraged system.", name="satisfied", moduleClass=OscalSspModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-satisfied-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
    public static class Satisfied
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Satisfied Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this satisfied control implementation entry elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `control implementation` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundFlag(formalName="Responsibility UUID", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a control implementation that satisfies a responsibility imposed by a leveraged system.", name="responsibility-uuid", typeAdapter=UuidAdapter.class)
        private UUID _responsibilityUuid;
        @BoundField(formalName="Satisfied Control Implementation Responsibility Description", description="An implementation statement that describes the aspects of a control or control statement implementation that a leveraging system is implementing based on a requirement from a leveraged system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
        private List<ResponsibleRole> _responsibleRoles;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Satisfied() {
            this(null);
        }

        public Satisfied(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public UUID getResponsibilityUuid() {
            return this._responsibilityUuid;
        }

        public void setResponsibilityUuid(UUID value) {
            this._responsibilityUuid = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<ResponsibleRole> getResponsibleRoles() {
            return this._responsibleRoles;
        }

        public void setResponsibleRoles(List<ResponsibleRole> value) {
            this._responsibleRoles = value;
        }

        public boolean addResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibleRoles == null) {
                this._responsibleRoles = new LinkedList<ResponsibleRole>();
            }
            return this._responsibleRoles.add(value);
        }

        public boolean removeResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibleRoles != null && this._responsibleRoles.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

