/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.ComponentControlImplementation;
import gov.nist.secauto.oscal.lib.model.IncorporatesComponent;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Capability", description="A grouping of other components and/or capabilities.", name="capability", moduleClass=OscalComponentDefinitionModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-component-definition-capability-incorporates-component", level=IConstraint.Level.ERROR, target="incorporates-component", keyFields={@KeyField(target="@component-uuid")}, remarks="A given `component` must not be referenced more than once within the same `capability`.")}))
public class Capability
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Capability Identifier", description="Provides a globally unique means to identify a given capability.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Capability Name", description="The capability's human-readable name.", name="name", required=true, typeAdapter=StringAdapter.class)
    private String _name;
    @BoundField(formalName="Capability Description", description="A summary of the capability.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Incorporates Component", description="The collection of components comprising this capability.", useName="incorporates-component", maxOccurs=-1, groupAs=@GroupAs(name="incorporates-components", inJson=JsonGroupAsBehavior.LIST))
    private List<IncorporatesComponent> _incorporatesComponents;
    @BoundAssembly(formalName="Control Implementation Set", description="Defines how the component or capability supports a set of controls.", useName="control-implementation", maxOccurs=-1, groupAs=@GroupAs(name="control-implementations", inJson=JsonGroupAsBehavior.LIST))
    private List<ComponentControlImplementation> _controlImplementations;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Capability() {
        this(null);
    }

    public Capability(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<IncorporatesComponent> getIncorporatesComponents() {
        return this._incorporatesComponents;
    }

    public void setIncorporatesComponents(List<IncorporatesComponent> value) {
        this._incorporatesComponents = value;
    }

    public boolean addIncorporatesComponent(IncorporatesComponent item) {
        IncorporatesComponent value = (IncorporatesComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._incorporatesComponents == null) {
            this._incorporatesComponents = new LinkedList<IncorporatesComponent>();
        }
        return this._incorporatesComponents.add(value);
    }

    public boolean removeIncorporatesComponent(IncorporatesComponent item) {
        IncorporatesComponent value = (IncorporatesComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._incorporatesComponents != null && this._incorporatesComponents.remove(value);
    }

    public List<ComponentControlImplementation> getControlImplementations() {
        return this._controlImplementations;
    }

    public void setControlImplementations(List<ComponentControlImplementation> value) {
        this._controlImplementations = value;
    }

    public boolean addControlImplementation(ComponentControlImplementation item) {
        ComponentControlImplementation value = (ComponentControlImplementation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controlImplementations == null) {
            this._controlImplementations = new LinkedList<ComponentControlImplementation>();
        }
        return this._controlImplementations.add(value);
    }

    public boolean removeControlImplementation(ComponentControlImplementation item) {
        ComponentControlImplementation value = (ComponentControlImplementation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controlImplementations != null && this._controlImplementations.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

