/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.OscalCatalogModule;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.control.catalog.AbstractCatalog;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Catalog", description="A structured, [organized collection](https://pages.nist.gov/OSCAL/concepts/terminology/#catalog) of control information.", name="catalog", moduleClass=OscalCatalogModule.class, rootName="catalog", remarks="Catalogs may use one or more `group` objects to subdivide the control contents of a catalog.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="metadata/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="resolution-tool", description="The tool used to produce a resolved profile."), @AllowedValue(value="source-profile-uuid", description="The document-level `uuid` of the source profile from which the catalog was produced by [profile resolution](https://pages.nist.gov/OSCAL/concepts/processing/profile-resolution/).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="metadata/link/@rel", allowOthers=true, values={@AllowedValue(value="source-profile", description="The profile from which the catalog was produced by [profile resolution](https://pages.nist.gov/OSCAL/concepts/processing/profile-resolution/)."), @AllowedValue(value="source-profile-uuid", description="The document-level `uuid` of the profile from which the catalog was produced by [profile resolution](https://pages.nist.gov/OSCAL/concepts/processing/profile-resolution/).")})}), modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="//part", name="catalog-parts", keyFields={@KeyField(target="@id")}), @Index(level=IConstraint.Level.ERROR, target="//prop", name="catalog-props", keyFields={@KeyField(target="@uuid")}), @Index(level=IConstraint.Level.ERROR, target="//(control|group|part)", name="catalog-groups-controls-parts", keyFields={@KeyField(target="@id")}), @Index(level=IConstraint.Level.ERROR, target="//control", name="catalog-controls", keyFields={@KeyField(target="@id")}), @Index(level=IConstraint.Level.ERROR, target="//param", name="catalog-params", keyFields={@KeyField(target="@id")}), @Index(level=IConstraint.Level.ERROR, target="//group", name="catalog-groups", keyFields={@KeyField(target="@id")})}))
public class Catalog
extends AbstractCatalog
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Catalog Universally Unique Identifier", description="Provides a globally unique means to identify a given catalog instance.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", useName="param", maxOccurs=-1, groupAs=@GroupAs(name="params", inJson=JsonGroupAsBehavior.LIST))
    private List<Parameter> _params;
    @BoundAssembly(formalName="Control", description="A [structured object](https://pages.nist.gov/OSCAL/concepts/terminology/#control) representing a requirement or guideline, which when implemented will reduce an aspect of risk related to an information system and its information.", useName="control", maxOccurs=-1, groupAs=@GroupAs(name="controls", inJson=JsonGroupAsBehavior.LIST))
    private List<Control> _controls;
    @BoundAssembly(formalName="Control Group", description="A group of controls, or of groups of controls.", useName="group", maxOccurs=-1, groupAs=@GroupAs(name="groups", inJson=JsonGroupAsBehavior.LIST))
    private List<CatalogGroup> _groups;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter", remarks="Back matter including references and resources.")
    private BackMatter _backMatter;

    public Catalog() {
        this(null);
    }

    public Catalog(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    @Override
    public List<Parameter> getParams() {
        return this._params;
    }

    public void setParams(List<Parameter> value) {
        this._params = value;
    }

    @Override
    public boolean addParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._params == null) {
            this._params = new LinkedList<Parameter>();
        }
        return this._params.add(value);
    }

    @Override
    public boolean removeParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._params != null && this._params.remove(value);
    }

    @Override
    public List<Control> getControls() {
        return this._controls;
    }

    public void setControls(List<Control> value) {
        this._controls = value;
    }

    @Override
    public boolean addControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controls == null) {
            this._controls = new LinkedList<Control>();
        }
        return this._controls.add(value);
    }

    @Override
    public boolean removeControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controls != null && this._controls.remove(value);
    }

    @Override
    public List<CatalogGroup> getGroups() {
        return this._groups;
    }

    public void setGroups(List<CatalogGroup> value) {
        this._groups = value;
    }

    @Override
    public boolean addGroup(CatalogGroup item) {
        CatalogGroup value = (CatalogGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._groups == null) {
            this._groups = new LinkedList<CatalogGroup>();
        }
        return this._groups.add(value);
    }

    @Override
    public boolean removeGroup(CatalogGroup item) {
        CatalogGroup value = (CatalogGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._groups != null && this._groups.remove(value);
    }

    @Override
    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

