/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalCatalogModule;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.catalog.AbstractCatalogGroup;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Group", description="A group of controls, or of groups of controls.", name="group", moduleClass=OscalCatalogModule.class, remarks="Catalogs can use the catalog `group` construct to organize related controls into a single grouping, such as a family of controls or other logical organizational structure.\n\nA `group` may have its own properties, statements, parameters, and references, which are inherited by all controls of that are a member of the group.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="label", description="A human-readable label for the parent context, which may be rendered in place of the actual identifier for some use cases."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="alt-identifier", description="An alternate or aliased identifier for the parent context.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="overview", description="An introduction to a control or a group of controls."), @AllowedValue(value="instruction", description="Information providing directions for a control or a group of controls.")})}))
public class CatalogGroup
extends AbstractCatalogGroup
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Group Identifier", description="Identifies the group for the purpose of cross-linking within the defining instance or from other instances that reference the catalog.", name="id", typeAdapter=TokenAdapter.class)
    private String _id;
    @BoundFlag(formalName="Group Class", description="A textual label that provides a sub-type or characterization of the group.", name="class", typeAdapter=TokenAdapter.class, remarks="A `class` can be used in validation rules to express extra constraints over named items of a specific `class` value.\n\nA `class` can also be used in an OSCAL profile as a means to target an alteration to control content.")
    private String _clazz;
    @BoundField(formalName="Group Title", description="A name given to the group, which may be used by a tool for display and navigation.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", useName="param", maxOccurs=-1, groupAs=@GroupAs(name="params", inJson=JsonGroupAsBehavior.LIST))
    private List<Parameter> _params;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Part", description="An annotated, markup-based textual element of a control's or catalog group's definition, or a child of another part.", useName="part", maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
    private List<ControlPart> _parts;
    @BoundAssembly(formalName="Control Group", description="A group of controls, or of groups of controls.", useName="group", maxOccurs=-1, groupAs=@GroupAs(name="groups", inJson=JsonGroupAsBehavior.LIST))
    private List<CatalogGroup> _groups;
    @BoundAssembly(formalName="Control", description="A [structured object](https://pages.nist.gov/OSCAL/concepts/terminology/#control) representing a requirement or guideline, which when implemented will reduce an aspect of risk related to an information system and its information.", useName="control", maxOccurs=-1, groupAs=@GroupAs(name="controls", inJson=JsonGroupAsBehavior.LIST))
    private List<Control> _controls;

    public CatalogGroup() {
        this(null);
    }

    public CatalogGroup(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getClazz() {
        return this._clazz;
    }

    public void setClazz(String value) {
        this._clazz = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    @Override
    public List<Parameter> getParams() {
        return this._params;
    }

    public void setParams(List<Parameter> value) {
        this._params = value;
    }

    @Override
    public boolean addParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._params == null) {
            this._params = new LinkedList<Parameter>();
        }
        return this._params.add(value);
    }

    @Override
    public boolean removeParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._params != null && this._params.remove(value);
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    @Override
    public List<ControlPart> getParts() {
        return this._parts;
    }

    public void setParts(List<ControlPart> value) {
        this._parts = value;
    }

    public boolean addPart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._parts == null) {
            this._parts = new LinkedList<ControlPart>();
        }
        return this._parts.add(value);
    }

    public boolean removePart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._parts != null && this._parts.remove(value);
    }

    @Override
    public List<CatalogGroup> getGroups() {
        return this._groups;
    }

    public void setGroups(List<CatalogGroup> value) {
        this._groups = value;
    }

    @Override
    public boolean addGroup(CatalogGroup item) {
        CatalogGroup value = (CatalogGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._groups == null) {
            this._groups = new LinkedList<CatalogGroup>();
        }
        return this._groups.add(value);
    }

    @Override
    public boolean removeGroup(CatalogGroup item) {
        CatalogGroup value = (CatalogGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._groups != null && this._groups.remove(value);
    }

    @Override
    public List<Control> getControls() {
        return this._controls;
    }

    public void setControls(List<Control> value) {
        this._controls = value;
    }

    @Override
    public boolean addControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controls == null) {
            this._controls = new LinkedList<Control>();
        }
        return this._controls.add(value);
    }

    @Override
    public boolean removeControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controls != null && this._controls.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

