/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Origin;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Characterization", description="A collection of descriptive data about the containing object from a specific origin.", name="characterization", moduleClass=OscalAssessmentCommonModule.class)
public class Characterization
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", useName="origin", remarks="metadata about the specific actor that generated this descriptive data.", minOccurs=1)
    private Origin _origin;
    @BoundAssembly(formalName="Facet", description="An individual characteristic that is part of a larger set produced by the same actor.", useName="facet", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="facets", inJson=JsonGroupAsBehavior.LIST))
    private List<Facet> _facets;

    public Characterization() {
        this(null);
    }

    public Characterization(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public Origin getOrigin() {
        return this._origin;
    }

    public void setOrigin(Origin value) {
        this._origin = value;
    }

    public List<Facet> getFacets() {
        return this._facets;
    }

    public void setFacets(List<Facet> value) {
        this._facets = value;
    }

    public boolean addFacet(Facet item) {
        Facet value = (Facet)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._facets == null) {
            this._facets = new LinkedList<Facet>();
        }
        return this._facets.add(value);
    }

    public boolean removeFacet(Facet item) {
        Facet value = (Facet)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._facets != null && this._facets.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Facet", description="An individual characteristic that is part of a larger set produced by the same actor.", name="facet", moduleClass=OscalAssessmentCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="state", description="Indicates if the facet is 'initial' as first identified, or 'adjusted' indicating that the value has be changed after some adjustments have been made (e.g., to identify residual risk).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='state']/@value", values={@AllowedValue(value="initial", description="As first identified."), @AllowedValue(value="adjusted", description="Indicates that residual risk remains after some adjustments have been made.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://csrc.nist.gov/ns/oscal']/@name", values={@AllowedValue(value="likelihood", description="General likelihood rating."), @AllowedValue(value="impact", description="General impact rating."), @AllowedValue(value="risk", description="General risk rating."), @AllowedValue(value="severity", description="General severity rating.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://fedramp.gov','http://fedramp.gov/ns/oscal')]/@name", values={@AllowedValue(value="likelihood", description="Likelihood as defined by FedRAMP. The `class` can be used to specify 'initial' and 'adjusted' risk states."), @AllowedValue(value="impact", description="Impact as defined by FedRAMP. The `class` can be used to specify 'initial' and 'adjusted' risk states."), @AllowedValue(value="risk", description="Risk as calculated according to FedRAMP. The `class` can be used to specify 'initial' and 'adjusted' risk states.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://cve.mitre.org']/@name", values={@AllowedValue(value="cve-id", description="An identifier managed by the CVE program (see https://cve.mitre.org/).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0']/@name", values={@AllowedValue(value="access-vector", description="Base: Access Vector"), @AllowedValue(value="access-complexity", description="Base: Access Complexity"), @AllowedValue(value="authentication", description="Base: Authentication"), @AllowedValue(value="confidentiality-impact", description="Base: Confidentiality Impact"), @AllowedValue(value="integrity-impact", description="Base: Integrity Impact"), @AllowedValue(value="availability-impact", description="Base: Availability Impact"), @AllowedValue(value="exploitability", description="Temporal: Exploitability"), @AllowedValue(value="remediation-level", description="Temporal: Remediation Level"), @AllowedValue(value="report-confidence", description="Temporal: Report Confidence"), @AllowedValue(value="collateral-damage-potential", description="Environmental: Collateral Damage Potential"), @AllowedValue(value="target-distribution", description="Environmental: Target Distribution"), @AllowedValue(value="confidentiality-requirement", description="Environmental: Confidentiality Requirement"), @AllowedValue(value="integrity-requirement", description="Environmental: Integrity Requirement"), @AllowedValue(value="availability-requirement", description="Environmental: Availability Requirement")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='access-vector']/@value", values={@AllowedValue(value="local", description="Local"), @AllowedValue(value="adjacent-network", description="Network Adjacent"), @AllowedValue(value="network", description="Network")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='access-complexity']/@value", values={@AllowedValue(value="high", description="High"), @AllowedValue(value="medium", description="Medium"), @AllowedValue(value="low", description="Low")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='authentication']/@value", values={@AllowedValue(value="multiple", description="Multiple"), @AllowedValue(value="single", description="Single"), @AllowedValue(value="none", description="None")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name=('confidentiality-impact', 'integrity-impact', 'availability-impact')]/@value", values={@AllowedValue(value="none", description="None"), @AllowedValue(value="partial", description="Partial"), @AllowedValue(value="complete", description="Complete")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='exploitability']/@value", values={@AllowedValue(value="unproven", description="Unproven"), @AllowedValue(value="proof-of-concept", description="Proof-of-Concept"), @AllowedValue(value="functional", description="Functional"), @AllowedValue(value="high", description="High"), @AllowedValue(value="not-defined", description="Not Defined")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='remediation-level']/@value", values={@AllowedValue(value="official-fix", description="Official Fix"), @AllowedValue(value="temporary-fix", description="Temporary Fix"), @AllowedValue(value="workaround", description="Workaround"), @AllowedValue(value="unavailable", description="Unavailable"), @AllowedValue(value="not-defined", description="Not Defined")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='report-confidence']/@value", values={@AllowedValue(value="unconfirmed", description="Unconfirmed"), @AllowedValue(value="uncorroborated", description="Uncorroborated"), @AllowedValue(value="confirmed", description="Confirmed"), @AllowedValue(value="not-defined", description="Not Defined")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name='collateral-damage-potential']/@value", values={@AllowedValue(value="none", description="None"), @AllowedValue(value="low", description="Low (light loss)"), @AllowedValue(value="low-medium", description="Low Medium"), @AllowedValue(value="medium-high", description="Medium High"), @AllowedValue(value="high", description="High (catastrophic loss)"), @AllowedValue(value="not-defined", description="Not Defined")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system='http://www.first.org/cvss/v2.0' and @name=('target-distribution', 'confidentiality-requirement', 'integrity-requirement', 'availability-requirement')]/@value", values={@AllowedValue(value="none", description=""), @AllowedValue(value="low", description=""), @AllowedValue(value="medium", description=""), @AllowedValue(value="high", description=""), @AllowedValue(value="not-defined", description="")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1')]/@name", values={@AllowedValue(value="attack-vector", description="Base: Attack Vector"), @AllowedValue(value="access-complexity", description="Base: Attack Complexity"), @AllowedValue(value="privileges-required", description="Base: Privileges Required"), @AllowedValue(value="user-interaction", description="Base: User Interaction"), @AllowedValue(value="scope", description="Base: Scope"), @AllowedValue(value="confidentiality-impact", description="Base: Confidentiality Impact"), @AllowedValue(value="integrity-impact", description="Base: Integrity Impact"), @AllowedValue(value="availability-impact", description="Base: Availability Impact"), @AllowedValue(value="exploit-code-maturity", description="Temporal: Exploit Code Maturity"), @AllowedValue(value="remediation-level", description="Temporal: Remediation Level"), @AllowedValue(value="report-confidence", description="Temporal: Report Confidence"), @AllowedValue(value="modified-attack-vector", description="Environmental: Modified Attack Vector"), @AllowedValue(value="modified-attack-complexity", description="Environmental: Modified Attack Complexity"), @AllowedValue(value="modified-privileges-required", description="Environmental: Modified Privileges Required"), @AllowedValue(value="modified-user-interaction", description="Environmental: Modified User Interaction"), @AllowedValue(value="modified-scope", description="Environmental: Modified Scope"), @AllowedValue(value="modified-confidentiality", description="Environmental: Modified Confidentiality"), @AllowedValue(value="modified-integrity", description="Environmental: Modified Integrity"), @AllowedValue(value="modified-availability", description="Environmental: Modified Availability"), @AllowedValue(value="confidentiality-requirement", description="Environmental: Confidentiality Requirement Modifier"), @AllowedValue(value="integrity-requirement", description="Environmental: Integrity Requirement Modifier"), @AllowedValue(value="availability-requirement", description="Environmental: Availability Requirement Modifier")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='access-vector']/@value", values={@AllowedValue(value="network", description="Network"), @AllowedValue(value="adjacent", description="Adjacent"), @AllowedValue(value="local", description="Local"), @AllowedValue(value="physical", description="Physical")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='access-complexity']/@value", values={@AllowedValue(value="high", description="High"), @AllowedValue(value="low", description="Low")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name=('privileges-required', 'confidentiality-impact', 'integrity-impact', 'availability-impact')]/@value", values={@AllowedValue(value="none", description="None"), @AllowedValue(value="low", description="Low"), @AllowedValue(value="high", description="High")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='user-interaction']/@value", values={@AllowedValue(value="none", description="None"), @AllowedValue(value="required", description="Required")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='scope']/@value", values={@AllowedValue(value="unchanged", description="Unchanged"), @AllowedValue(value="changed", description="Changed")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='exploit-code-maturity']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="unproven", description="Unproven"), @AllowedValue(value="proof-of-concept", description="Proof-of-Concept"), @AllowedValue(value="functional", description="Functional"), @AllowedValue(value="high", description="High")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='remediation-level']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="official-fix", description="Official Fix"), @AllowedValue(value="temporary-fix", description="Temporary Fix"), @AllowedValue(value="workaround", description="Workaround"), @AllowedValue(value="unavailable", description="Unavailable")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='report-confidence']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="unknown", description="Unknown"), @AllowedValue(value="reasonable", description="Reasonable"), @AllowedValue(value="confirmed", description="Confirmed")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name=('confidentiality-requirement', 'integrity-requirement', 'availability-requirement')]/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="low", description="Low"), @AllowedValue(value="medium", description="Medium"), @AllowedValue(value="high", description="High")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='modified-attack-vector']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="network", description="Network"), @AllowedValue(value="adjacent", description="Adjacent"), @AllowedValue(value="local", description="Local"), @AllowedValue(value="physical", description="Physical")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='modified-attack-complexity']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="high", description="High"), @AllowedValue(value="low", description="Low")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name=('modified-privileges-required', 'modified-confidentiality', 'modified-integrity', 'modified-availability')]/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="none", description="None"), @AllowedValue(value="low", description="Low"), @AllowedValue(value="high", description="High")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='modified-user-interaction']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="none", description="None"), @AllowedValue(value="required", description="Required")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@system=('http://www.first.org/cvss/v3.0', 'http://www.first.org/cvss/v3.1') and @name='modified-scope']/@value", values={@AllowedValue(value="not-defined", description="Not Defined"), @AllowedValue(value="unchanged", description="Unchanged"), @AllowedValue(value="changed", description="Changed")})}))
    public static class Facet
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Facet Name", description="The name of the risk metric within the specified system.", name="name", required=true, typeAdapter=TokenAdapter.class)
        private String _name;
        @BoundFlag(formalName="Naming System", description="Specifies the naming system under which this risk metric is organized, which allows for the same names to be used in different systems controlled by different parties. This avoids the potential of a name clash.", name="system", required=true, typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="http://fedramp.gov", description="\\*\\*deprecated\\*\\* The FedRAMP naming system. This has been deprecated; use `http://fedramp.gov/ns/oscal` instead.", deprecatedVersion="1.0.3"), @AllowedValue(value="http://fedramp.gov/ns/oscal", description="The FedRAMP naming system."), @AllowedValue(value="http://csrc.nist.gov/ns/oscal", description=""), @AllowedValue(value="http://csrc.nist.gov/ns/oscal/unknown", description="The facet is from an unknown taxonomy. The meaning of the name is tool or organization specific."), @AllowedValue(value="http://cve.mitre.org", description=""), @AllowedValue(value="http://www.first.org/cvss/v2.0", description=""), @AllowedValue(value="http://www.first.org/cvss/v3.0", description=""), @AllowedValue(value="http://www.first.org/cvss/v3.1", description="")})}))
        private URI _system;
        @BoundFlag(formalName="Facet Value", description="Indicates the value of the facet.", name="value", required=true, typeAdapter=StringAdapter.class)
        private String _value;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Facet() {
            this(null);
        }

        public Facet(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String value) {
            this._name = value;
        }

        public URI getSystem() {
            return this._system;
        }

        public void setSystem(URI value) {
            this._system = value;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

