/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.ComponentImplementedRequirement;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SetParameter;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Implementation Set", description="Defines how the component or capability supports a set of controls.", name="control-implementation", moduleClass=OscalComponentDefinitionModule.class, remarks="Use of `set-parameter` in this context, sets the parameter for all controls referenced by any `implemented-requirement` contained in this context. Any `set-parameter` defined in a child context will override this value. If not overridden by a child, this value applies in the child context.", modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-component-definition-control-implementation-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once.")}))
public class ComponentControlImplementation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Implementation Set Identifier", description="Provides a means to identify a set of control implementations that are supported by a given component or capability.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Source Resource Reference", description="A reference to an OSCAL catalog or profile providing the referenced control or subcontrol definition.", name="source", required=true, typeAdapter=UriReferenceAdapter.class, remarks="This value may be one of:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or\n3. a bare URI fragment (i.e., \\`#uuid\\`) pointing to a `back-matter` resource in this or an imported document (see [linking to another OSCAL object](https://pages.nist.gov/OSCAL/concepts/uri-use/#linking-to-another-oscal-object)).")
    private URI _source;
    @BoundField(formalName="Control Implementation Description", description="A description of how the specified set of controls are implemented for the containing component or capability.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<SetParameter> _setParameters;
    @BoundAssembly(formalName="Control Implementation", description="Describes how the containing component or capability implements an individual control.", useName="implemented-requirement", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="implemented-requirements", inJson=JsonGroupAsBehavior.LIST))
    private List<ComponentImplementedRequirement> _implementedRequirements;

    public ComponentControlImplementation() {
        this(null);
    }

    public ComponentControlImplementation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public URI getSource() {
        return this._source;
    }

    public void setSource(URI value) {
        this._source = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<SetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<SetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<SetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public List<ComponentImplementedRequirement> getImplementedRequirements() {
        return this._implementedRequirements;
    }

    public void setImplementedRequirements(List<ComponentImplementedRequirement> value) {
        this._implementedRequirements = value;
    }

    public boolean addImplementedRequirement(ComponentImplementedRequirement item) {
        ComponentImplementedRequirement value = (ComponentImplementedRequirement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._implementedRequirements == null) {
            this._implementedRequirements = new LinkedList<ComponentImplementedRequirement>();
        }
        return this._implementedRequirements.add(value);
    }

    public boolean removeImplementedRequirement(ComponentImplementedRequirement item) {
        ComponentImplementedRequirement value = (ComponentImplementedRequirement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._implementedRequirements != null && this._implementedRequirements.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

