/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Capability;
import gov.nist.secauto.oscal.lib.model.DefinedComponent;
import gov.nist.secauto.oscal.lib.model.ImportComponentDefinition;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Component Definition", description="A collection of component descriptions, which may optionally be grouped by capability.", name="component-definition", moduleClass=OscalComponentDefinitionModule.class, rootName="component-definition", modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="component", name="index-system-component-uuid", keyFields={@KeyField(target="@uuid")}, remarks="Since multiple `component` entries can be provided, each component must have a unique `uuid`.")}, unique={@IsUnique(id="unique-component-definition-capability", level=IConstraint.Level.ERROR, target="capability", keyFields={@KeyField(target="@uuid")}, remarks="A given `component` must not be referenced more than once within the same `capability`.")}))
public class ComponentDefinition
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Component Definition Universally Unique Identifier", description="Provides a globally unique means to identify a given component definition instance.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import Component Definition", description="Loads a component definition from another resource.", useName="import-component-definition", maxOccurs=-1, groupAs=@GroupAs(name="import-component-definitions", inJson=JsonGroupAsBehavior.LIST))
    private List<ImportComponentDefinition> _importComponentDefinitions;
    @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
    private List<DefinedComponent> _components;
    @BoundAssembly(formalName="Capability", description="A grouping of other components and/or capabilities.", useName="capability", maxOccurs=-1, groupAs=@GroupAs(name="capabilities", inJson=JsonGroupAsBehavior.LIST))
    private List<Capability> _capabilities;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public ComponentDefinition() {
        this(null);
    }

    public ComponentDefinition(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public List<ImportComponentDefinition> getImportComponentDefinitions() {
        return this._importComponentDefinitions;
    }

    public void setImportComponentDefinitions(List<ImportComponentDefinition> value) {
        this._importComponentDefinitions = value;
    }

    public boolean addImportComponentDefinition(ImportComponentDefinition item) {
        ImportComponentDefinition value = (ImportComponentDefinition)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._importComponentDefinitions == null) {
            this._importComponentDefinitions = new LinkedList<ImportComponentDefinition>();
        }
        return this._importComponentDefinitions.add(value);
    }

    public boolean removeImportComponentDefinition(ImportComponentDefinition item) {
        ImportComponentDefinition value = (ImportComponentDefinition)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._importComponentDefinitions != null && this._importComponentDefinitions.remove(value);
    }

    public List<DefinedComponent> getComponents() {
        return this._components;
    }

    public void setComponents(List<DefinedComponent> value) {
        this._components = value;
    }

    public boolean addComponent(DefinedComponent item) {
        DefinedComponent value = (DefinedComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._components == null) {
            this._components = new LinkedList<DefinedComponent>();
        }
        return this._components.add(value);
    }

    public boolean removeComponent(DefinedComponent item) {
        DefinedComponent value = (DefinedComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._components != null && this._components.remove(value);
    }

    public List<Capability> getCapabilities() {
        return this._capabilities;
    }

    public void setCapabilities(List<Capability> value) {
        this._capabilities = value;
    }

    public boolean addCapability(Capability item) {
        Capability value = (Capability)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._capabilities == null) {
            this._capabilities = new LinkedList<Capability>();
        }
        return this._capabilities.add(value);
    }

    public boolean removeCapability(Capability item) {
        Capability value = (Capability)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._capabilities != null && this._capabilities.remove(value);
    }

    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

