/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.ComponentStatement;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import gov.nist.secauto.oscal.lib.model.SetParameter;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Implementation", description="Describes how the containing component or capability implements an individual control.", name="implemented-requirement", moduleClass=OscalComponentDefinitionModule.class, remarks="Implemented requirements within a component or capability in a component definition provide a means for component suppliers to suggest possible control implementation details, which may be used by a different party (e.g., component consumers) when authoring a system security plan. Thus, these requirements defined in a component definition are only a suggestion of how to implement, which may be adopted wholesale, changed, or ignored by a person defining an information system implementation.\n\nUse of `set-parameter` in this context, sets the parameter for the referenced control and any associated statements.", modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-component-definition-implemented-requirement-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once."), @IsUnique(id="unique-component-definition-implemented-requirement-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once."), @IsUnique(id="unique-component-definition-implemented-requirement-statement", level=IConstraint.Level.ERROR, target="statement", keyFields={@KeyField(target="@statement-id")}, remarks="Since `statement` entries can be referenced using the statement's statement-id, each statement must be referenced only once.")}))
public class ComponentImplementedRequirement
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Implementation Identifier", description="Provides a globally unique means to identify a given control implementation by a component.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Control Identifier Reference", description="A reference to a control with a corresponding `id` value. When referencing an externally defined `control`, the `Control Identifier Reference` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference).", name="control-id", required=true, typeAdapter=TokenAdapter.class)
    private String _controlId;
    @BoundField(formalName="Control Implementation Description", description="A suggestion from the supplier (e.g., component vendor or author) for how the specified control may be implemented if the containing component or capability is instantiated in a system security plan.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<SetParameter> _setParameters;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundAssembly(formalName="Control Statement Implementation", description="Identifies which statements within a control are addressed.", useName="statement", maxOccurs=-1, groupAs=@GroupAs(name="statements", inJson=JsonGroupAsBehavior.LIST))
    private List<ComponentStatement> _statements;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public ComponentImplementedRequirement() {
        this(null);
    }

    public ComponentImplementedRequirement(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getControlId() {
        return this._controlId;
    }

    public void setControlId(String value) {
        this._controlId = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<SetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<SetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<SetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public List<ComponentStatement> getStatements() {
        return this._statements;
    }

    public void setStatements(List<ComponentStatement> value) {
        this._statements = value;
    }

    public boolean addStatement(ComponentStatement item) {
        ComponentStatement value = (ComponentStatement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._statements == null) {
            this._statements = new LinkedList<ComponentStatement>();
        }
        return this._statements.add(value);
    }

    public boolean removeStatement(ComponentStatement item) {
        ComponentStatement value = (ComponentStatement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._statements != null && this._statements.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

