/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Statement Implementation", description="Identifies which statements within a control are addressed.", name="statement", moduleClass=OscalComponentDefinitionModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-component-definition-statement-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
public class ComponentStatement
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Statement Reference", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) identifier reference to a `control statement`.", name="statement-id", required=true, typeAdapter=TokenAdapter.class, remarks="A reference to the specific implemented statement associated with a control.")
    private String _statementId;
    @BoundFlag(formalName="Control Statement Reference Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this control statement elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#component-definition-identifiers). The *UUID* of the `control statement` in the source OSCAL instance is sufficient to reference the data item locally or globally (e.g., in an imported OSCAL instance).", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Statement Implementation Description", description="A summary of how the containing control statement is implemented by the component or capability.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public ComponentStatement() {
        this(null);
    }

    public ComponentStatement(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getStatementId() {
        return this._statementId;
    }

    public void setStatementId(String value) {
        this._statementId = value;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

