/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalCatalogModule;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.catalog.AbstractControl;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control", description="A [structured object](https://pages.nist.gov/OSCAL/concepts/terminology/#control) representing a requirement or guideline, which when implemented will reduce an aspect of risk related to an information system and its information.", name="control", moduleClass=OscalCatalogModule.class, remarks="Each security or privacy control within the catalog is defined by a distinct control instance. Controls may be as complex or as simple as a catalog defines them. They may be decomposed or further specified into child `control` objects, for example to represent control enhancements or specific breakouts of control functionality, to be maintained as discrete requirements. Controls may also contain structured parts (using `part`) and they may be grouped together in families or classes with `group`.\n\nControl structures in OSCAL will also exhibit regularities and rules that are not codified in OSCAL but in its applications or domains of application. For example, for catalogs describing controls as defined by NIST SP 800-53, a control must have a part with the name \"statement\", which represents the textual narrative of the control. This \"statement\" part must occur only once, but may have nested parts to allow for multiple paragraphs or sections of text. This organization supports addressability of this data content as long as, and only insofar as, it is consistently implemented across the control set. As given with these model definitions, constraints defined and assigned here can aid in ensuring this regularity; but other such constraints and other useful patterns of use remain to be discovered and described.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="label", description="A human-readable label for the parent context, which may be rendered in place of the actual identifier for some use cases."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="alt-identifier", description="An alternate or aliased identifier for the parent context."), @AllowedValue(value="status", description="The status of a `control`. For example, a value of 'withdrawn' can indicate that the `control` has been withdrawn and should no longer be used.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='status']/@value", values={@AllowedValue(value="withdrawn", description="The control is no longer used."), @AllowedValue(value="Withdrawn", description="\\*\\*(deprecated)\\*\\*\\* Use 'withdrawn' instead.", deprecatedVersion="1.0.0")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="reference", description="The link cites an external resource related to this control."), @AllowedValue(value="related", description="The link identifies another control with bearing to this control."), @AllowedValue(value="required", description="The link identifies another control that must be present if this control is present."), @AllowedValue(value="incorporated-into", description="The link identifies other control content where this control content is now addressed."), @AllowedValue(value="moved-to", description="The containing control definition was moved to the referenced control.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="overview", description="An introduction to a control or a group of controls."), @AllowedValue(value="statement", description="A set of implementation requirements or recommendations."), @AllowedValue(value="guidance", description="Additional information to consider when selecting, implementing, assessing, and monitoring a control."), @AllowedValue(value="example", description="An example of an implemented requirement or control statement."), @AllowedValue(value="assessment", description="\\*\\*(deprecated)\\*\\* Use 'assessment-method' instead.", deprecatedVersion="1.0.1"), @AllowedValue(value="assessment-method", description="The part describes a method-based assessment over a set of assessment objects.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='statement']//part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="item", description="An individual item within a control statement.")}, remarks="Nested statement parts are \"item\" parts."), @AllowedValues(level=IConstraint.Level.ERROR, target=".//part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="objective", description="\\*\\*(deprecated)\\*\\* Use 'assessment-objective' instead.", deprecatedVersion="1.0.1"), @AllowedValue(value="assessment-objective", description="The part describes a set of assessment objectives.")}, remarks="Objectives can be nested."), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name=('assessment','assessment-method')]/part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="objects", description="\\*\\*(deprecated)\\*\\* Use 'assessment-objects' instead.", deprecatedVersion="1.0.1"), @AllowedValue(value="assessment-objects", description="Provides a listing of assessment objects.")}, remarks="Assessment objects appear on assessment methods."), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name=('assessment','assessment-method')]/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="method", description="\\*\\*(deprecated)\\*\\* Use 'method' in the 'http://csrc.nist.gov/ns/rmf' namespace. The assessment method to use. This typically appears on parts with the name \"assessment-method\".", deprecatedVersion="1.0.1")}), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name=('assessment','assessment-method')]/prop[has-oscal-namespace('http://csrc.nist.gov/ns/rmf')]/@name", values={@AllowedValue(value="method", description="The assessment method to use. This typically appears on parts with the name \"assessment-method\".")}), @AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name=('assessment','assessment-method')]/prop[has-oscal-namespace(('http://csrc.nist.gov/ns/oscal','http://csrc.nist.gov/ns/rmf')) and @name='method']/@value", values={@AllowedValue(value="INTERVIEW", description="The process of holding discussions with individuals or groups of individuals within an organization to once again, facilitate assessor understanding, achieve clarification, or obtain evidence."), @AllowedValue(value="EXAMINE", description="The process of reviewing, inspecting, observing, studying, or analyzing one or more assessment objects (i.e., specifications, mechanisms, or activities)."), @AllowedValue(value="TEST", description="The process of exercising one or more assessment objects (i.e., activities or mechanisms) under specified conditions to compare actual with expected behavior.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="link[@rel=('related','required','incorporated-into','moved-to') and starts-with(@href,'#')]", indexName="catalog-groups-controls-parts", keyFields={@KeyField(target="@href", pattern="#(.*)")})}, expect={@Expect(id="catalog-control-require-statement-when-not-withdrawn", level=IConstraint.Level.ERROR, test="prop[@name='status']/@value=('withdrawn','Withdrawn') or part[@name='statement']"), @Expect(level=IConstraint.Level.WARNING, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name=('assessment','assessment-method')]", test="prop[has-oscal-namespace(('http://csrc.nist.gov/ns/oscal','http://csrc.nist.gov/ns/rmf')) and @name='method']")}))
public class Control
extends AbstractControl
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Identifier", description="Identifies a control such that it can be referenced in the defining catalog and other OSCAL instances (e.g., profiles).", name="id", required=true, typeAdapter=TokenAdapter.class)
    private String _id;
    @BoundFlag(formalName="Control Class", description="A textual label that provides a sub-type or characterization of the control.", name="class", typeAdapter=TokenAdapter.class, remarks="A `class` can be used in validation rules to express extra constraints over named items of a specific `class` value.\n\nA `class` can also be used in an OSCAL profile as a means to target an alteration to control content.")
    private String _clazz;
    @BoundField(formalName="Control Title", description="A name given to the control, which may be used by a tool for display and navigation.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", useName="param", maxOccurs=-1, groupAs=@GroupAs(name="params", inJson=JsonGroupAsBehavior.LIST))
    private List<Parameter> _params;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Part", description="An annotated, markup-based textual element of a control's or catalog group's definition, or a child of another part.", useName="part", maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
    private List<ControlPart> _parts;
    @BoundAssembly(formalName="Control", description="A [structured object](https://pages.nist.gov/OSCAL/concepts/terminology/#control) representing a requirement or guideline, which when implemented will reduce an aspect of risk related to an information system and its information.", useName="control", maxOccurs=-1, groupAs=@GroupAs(name="controls", inJson=JsonGroupAsBehavior.LIST))
    private List<Control> _controls;

    public Control() {
        this(null);
    }

    public Control(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getClazz() {
        return this._clazz;
    }

    public void setClazz(String value) {
        this._clazz = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    @Override
    public List<Parameter> getParams() {
        return this._params;
    }

    public void setParams(List<Parameter> value) {
        this._params = value;
    }

    @Override
    public boolean addParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._params == null) {
            this._params = new LinkedList<Parameter>();
        }
        return this._params.add(value);
    }

    @Override
    public boolean removeParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._params != null && this._params.remove(value);
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    @Override
    public List<ControlPart> getParts() {
        return this._parts;
    }

    public void setParts(List<ControlPart> value) {
        this._parts = value;
    }

    public boolean addPart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._parts == null) {
            this._parts = new LinkedList<ControlPart>();
        }
        return this._parts.add(value);
    }

    public boolean removePart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._parts != null && this._parts.remove(value);
    }

    @Override
    public List<Control> getControls() {
        return this._controls;
    }

    public void setControls(List<Control> value) {
        this._controls = value;
    }

    @Override
    public boolean addControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controls == null) {
            this._controls = new LinkedList<Control>();
        }
        return this._controls.add(value);
    }

    @Override
    public boolean removeControl(Control item) {
        Control value = (Control)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controls != null && this._controls.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

