/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.ImplementedRequirement;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.SetParameter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Implementation", description="Describes how the system satisfies a set of controls.", name="control-implementation", moduleClass=OscalSspModule.class, remarks="Use of `set-parameter` in this context, sets the parameter for all controls referenced by any `implemented-requirement` contained in this context. Any `set-parameter` defined in a child context will override this value. If not overridden by a child, this value applies in the child context.", modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="implemented-requirement//by-component/export/provided", name="by-component-export-provided-uuid", keyFields={@KeyField(target="@uuid")})}, unique={@IsUnique(id="unique-ssp-control-implementation-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once.")}))
public class ControlImplementation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Control Implementation Description", description="A statement describing important things to know about how this set of control satisfaction documentation is approached.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<SetParameter> _setParameters;
    @BoundAssembly(formalName="Control-based Requirement", description="Describes how the system satisfies the requirements of an individual control.", useName="implemented-requirement", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="implemented-requirements", inJson=JsonGroupAsBehavior.LIST))
    private List<ImplementedRequirement> _implementedRequirements;

    public ControlImplementation() {
        this(null);
    }

    public ControlImplementation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<SetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<SetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<SetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public List<ImplementedRequirement> getImplementedRequirements() {
        return this._implementedRequirements;
    }

    public void setImplementedRequirements(List<ImplementedRequirement> value) {
        this._implementedRequirements = value;
    }

    public boolean addImplementedRequirement(ImplementedRequirement item) {
        ImplementedRequirement value = (ImplementedRequirement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._implementedRequirements == null) {
            this._implementedRequirements = new LinkedList<ImplementedRequirement>();
        }
        return this._implementedRequirements.add(value);
    }

    public boolean removeImplementedRequirement(ImplementedRequirement item) {
        ImplementedRequirement value = (ImplementedRequirement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._implementedRequirements != null && this._implementedRequirements.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

