/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ComponentControlImplementation;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalComponentDefinitionModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.Protocol;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", name="defined-component", moduleClass=OscalComponentDefinitionModule.class, remarks="Components may be products, services, APIs, policies, processes, plans, guidance, standards, or other tangible items that enable security and/or privacy.\n\nThe `type` indicates which of these component types is represented.\n\nA group of components may be aggregated into a `capability`. For example, an account management capability that consists of an account management process, and a Lightweight Directory Access Protocol (LDAP) software implementation.\n\nCapabilities are expressed by combining one or more components.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="version", description="The version of the component."), @AllowedValue(value="patch-level", description="The specific patch level of the component."), @AllowedValue(value="model", description="The model of the component."), @AllowedValue(value="release-date", description="The date the component was released, such as a software release date or policy publication date."), @AllowedValue(value="validation-type", description="Used with component-type='validation' to provide a well-known name for a kind of validation."), @AllowedValue(value="validation-reference", description="Used with component-type='validation' to indicate the validating body's assigned identifier for their validation of this component."), @AllowedValue(value="asset-type", description="Simple indication of the asset's function, such as Router, Storage Array, DNS Server."), @AllowedValue(value="asset-id", description="An organizationally specific identifier that is used to uniquely identify a logical or tangible item by the organization that owns the item."), @AllowedValue(value="asset-tag", description="An asset tag assigned by the organization responsible for maintaining the logical or tangible item."), @AllowedValue(value="public", description="Identifies whether the asset is publicly accessible (yes/no)"), @AllowedValue(value="virtual", description="Identifies whether the asset is virtualized (yes/no)"), @AllowedValue(value="vlan-id", description="Virtual LAN identifier of the asset."), @AllowedValue(value="network-id", description="The network identifier of the asset."), @AllowedValue(value="label", description="A human-readable label for the parent context."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="baseline-configuration-name", description="The name of the baseline configuration for the asset."), @AllowedValue(value="allows-authenticated-scan", description="Can the asset be check with an authenticated scan? (yes/no)"), @AllowedValue(value="function", description="The function provided by the asset for the system.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="depends-on", description="A reference to another component that this component has a dependency on."), @AllowedValue(value="validation", description="A reference to another component of component-type=validation, that is a validation (e.g., FIPS 140-2) for this component"), @AllowedValue(value="proof-of-compliance", description="A pointer to a validation record (e.g., FIPS 140-2) or other compliance information."), @AllowedValue(value="baseline-template", description="A reference to the baseline template used to configure the asset."), @AllowedValue(value="uses-service", description="This service is used by the referenced component identifier."), @AllowedValue(value="system-security-plan", description="A link to the system security plan of the external system."), @AllowedValue(value="uses-network", description="This component uses the network provided by the identified network component.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="responsible-role/@role-id|control-implementation/implemented-requirement/responsible-role/@role-id|control-implementation/implemented-requirement/statement/responsible-role/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset."), @AllowedValue(value="maintainer", description="Responsible for the creation and maintenance of a component."), @AllowedValue(value="provider", description="Organization responsible for providing the component, if this is different from the \"maintainer\" (e.g., a reseller).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='asset-type']/@value", allowOthers=true, values={@AllowedValue(value="operating-system", description="System software that manages computer hardware, software resources, and provides common services for computer programs."), @AllowedValue(value="database", description="An electronic collection of data, or information, that is specially organized for rapid search and retrieval."), @AllowedValue(value="web-server", description="A system that delivers content or services to end users over the Internet or an intranet."), @AllowedValue(value="dns-server", description="A system that resolves domain names to internet protocol (IP) addresses."), @AllowedValue(value="email-server", description="A computer system that sends and receives electronic mail messages."), @AllowedValue(value="directory-server", description="A system that stores, organizes and provides access to directory information in order to unify network resources."), @AllowedValue(value="pbx", description="A private branch exchange (PBX) provides a a private telephone switchboard."), @AllowedValue(value="firewall", description="A network security system that monitors and controls incoming and outgoing network traffic based on predetermined security rules."), @AllowedValue(value="router", description="A physical or virtual networking device that forwards data packets between computer networks."), @AllowedValue(value="switch", description="A physical or virtual networking device that connects devices within a computer network by using packet switching to receive and forward data to the destination device."), @AllowedValue(value="storage-array", description="A consolidated, block-level data storage capability."), @AllowedValue(value="appliance", description="A physical or virtual machine that centralizes hardware, software, or services for a specific purpose.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='allows-authenticated-scan']/@value", values={@AllowedValue(value="yes", description="The component allows an authenticated scan."), @AllowedValue(value="no", description="The component does not allow an authenticated scan.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='virtual']/@value", values={@AllowedValue(value="yes", description="The component is virtualized."), @AllowedValue(value="no", description="The component is not virtualized.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='public']/@value", values={@AllowedValue(value="yes", description="The component is publicly accessible."), @AllowedValue(value="no", description="The component is not publicly accessible.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='implementation-point']/@value", values={@AllowedValue(value="internal", description="The component is implemented within the system boundary."), @AllowedValue(value="external", description="The component is implemented outside the system boundary.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@type='software']/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="software-identifier", description="If a \"software\" component-type, the identifier, such as a SWID tag, for the software component.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@type='service']/link/@rel", allowOthers=true, values={@AllowedValue(value="provided-by", description="This service is provided by the referenced component identifier."), @AllowedValue(value="used-by", description="This service is used by the referenced component identifier.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="prop[@name='physical-location']", indexName="index-metadata-location-uuid", keyFields={@KeyField(target="@value")})}, matches={@Matches(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='inherited-uuid']/@value", typeAdapter=UuidAdapter.class), @Matches(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='release-date']/@value", typeAdapter=DateAdapter.class)}, expect={@Expect(level=IConstraint.Level.ERROR, test="not(exists((.)[not(@type='service')]/protocol))")}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-defined-component-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
public class DefinedComponent
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Component Identifier", description="Provides a globally unique means to identify a given component.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Component Type", description="A category describing the purpose of the component.", name="type", required=true, typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="interconnection", description="A connection to something outside this system."), @AllowedValue(value="software", description="Any software, operating system, or firmware."), @AllowedValue(value="hardware", description="A physical device."), @AllowedValue(value="service", description="A service that may provide APIs."), @AllowedValue(value="policy", description="An enforceable policy."), @AllowedValue(value="physical", description="A tangible asset used to provide physical protections or countermeasures."), @AllowedValue(value="process-procedure", description="A list of steps or actions to take to achieve some end result."), @AllowedValue(value="plan", description="An applicable plan."), @AllowedValue(value="guidance", description="Any guideline or recommendation."), @AllowedValue(value="standard", description="Any organizational or industry standard."), @AllowedValue(value="validation", description="An external assessment performed on some other component, that has been validated by a third-party.")})}))
    private String _type;
    @BoundField(formalName="Component Title", description="A human readable name for the component.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Component Description", description="A description of the component, including information about its function.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundField(formalName="Purpose", description="A summary of the technological or business purpose of the component.", useName="purpose", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _purpose;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundAssembly(formalName="Service Protocol Information", description="Information about the protocol used to provide a service.", useName="protocol", remarks="Used for `service` components to define the protocols supported by the service.", maxOccurs=-1, groupAs=@GroupAs(name="protocols", inJson=JsonGroupAsBehavior.LIST))
    private List<Protocol> _protocols;
    @BoundAssembly(formalName="Control Implementation Set", description="Defines how the component or capability supports a set of controls.", useName="control-implementation", maxOccurs=-1, groupAs=@GroupAs(name="control-implementations", inJson=JsonGroupAsBehavior.LIST))
    private List<ComponentControlImplementation> _controlImplementations;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public DefinedComponent() {
        this(null);
    }

    public DefinedComponent(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public MarkupLine getPurpose() {
        return this._purpose;
    }

    public void setPurpose(MarkupLine value) {
        this._purpose = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public List<Protocol> getProtocols() {
        return this._protocols;
    }

    public void setProtocols(List<Protocol> value) {
        this._protocols = value;
    }

    public boolean addProtocol(Protocol item) {
        Protocol value = (Protocol)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._protocols == null) {
            this._protocols = new LinkedList<Protocol>();
        }
        return this._protocols.add(value);
    }

    public boolean removeProtocol(Protocol item) {
        Protocol value = (Protocol)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._protocols != null && this._protocols.remove(value);
    }

    public List<ComponentControlImplementation> getControlImplementations() {
        return this._controlImplementations;
    }

    public void setControlImplementations(List<ComponentControlImplementation> value) {
        this._controlImplementations = value;
    }

    public boolean addControlImplementation(ComponentControlImplementation item) {
        ComponentControlImplementation value = (ComponentControlImplementation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controlImplementations == null) {
            this._controlImplementations = new LinkedList<ComponentControlImplementation>();
        }
        return this._controlImplementations.add(value);
    }

    public boolean removeControlImplementation(ComponentControlImplementation item) {
        ComponentControlImplementation value = (ComponentControlImplementation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controlImplementations != null && this._controlImplementations.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

