/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import java.net.URI;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaField(formalName="Document Identifier", description="A document identifier qualified by an identifier `scheme`.", name="document-id", moduleClass=OscalMetadataModule.class)
public class DocumentId
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Document Identification Scheme", description="Qualifies the kind of document identifier using a URI. If the scheme is not provided the value of the element will be interpreted as a string of characters.", name="scheme", typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="http://www.doi.org/", description="A [Digital Object Identifier](https://www.doi.org/hb.html) (DOI); use is preferred, since this allows for retrieval of a full bibliographic record.")})}))
    private URI _scheme;
    @BoundFieldValue(valueKeyName="identifier")
    private String _identifier;

    public DocumentId() {
        this(null);
    }

    public DocumentId(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public URI getScheme() {
        return this._scheme;
    }

    public void setScheme(URI value) {
        this._scheme = value;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setIdentifier(String value) {
        this._identifier = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

