/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.FindingTarget;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Origin;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Finding", description="Describes an individual finding.", name="finding", moduleClass=OscalAssessmentCommonModule.class)
public class Finding
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Finding Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this finding in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ar-identifiers). The locally defined *UUID* of the `finding` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Finding Title", description="The title for this finding.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Finding Description", description="A human-readable description of this finding.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", useName="origin", remarks="Used to identify the individual and/or tool generated this finding.", maxOccurs=-1, groupAs=@GroupAs(name="origins", inJson=JsonGroupAsBehavior.LIST))
    private List<Origin> _origins;
    @BoundAssembly(formalName="Objective Status", description="Captures an assessor's conclusions regarding the degree to which an objective is satisfied.", useName="target", minOccurs=1)
    private FindingTarget _target;
    @BoundField(formalName="Implementation Statement UUID", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to the implementation statement in the SSP to which this finding is related.", useName="implementation-statement-uuid", typeAdapter=UuidAdapter.class)
    private UUID _implementationStatementUuid;
    @BoundAssembly(formalName="Related Observation", description="Relates the finding to a set of referenced observations that were used to determine the finding.", useName="related-observation", maxOccurs=-1, groupAs=@GroupAs(name="related-observations", inJson=JsonGroupAsBehavior.LIST))
    private List<RelatedObservation> _relatedObservations;
    @BoundAssembly(formalName="Associated Risk", description="Relates the finding to a set of referenced risks that were used to determine the finding.", useName="associated-risk", maxOccurs=-1, groupAs=@GroupAs(name="related-risks", inJson=JsonGroupAsBehavior.LIST))
    private List<AssociatedRisk> _relatedRisks;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Finding() {
        this(null);
    }

    public Finding(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<Origin> getOrigins() {
        return this._origins;
    }

    public void setOrigins(List<Origin> value) {
        this._origins = value;
    }

    public boolean addOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._origins == null) {
            this._origins = new LinkedList<Origin>();
        }
        return this._origins.add(value);
    }

    public boolean removeOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._origins != null && this._origins.remove(value);
    }

    public FindingTarget getTarget() {
        return this._target;
    }

    public void setTarget(FindingTarget value) {
        this._target = value;
    }

    public UUID getImplementationStatementUuid() {
        return this._implementationStatementUuid;
    }

    public void setImplementationStatementUuid(UUID value) {
        this._implementationStatementUuid = value;
    }

    public List<RelatedObservation> getRelatedObservations() {
        return this._relatedObservations;
    }

    public void setRelatedObservations(List<RelatedObservation> value) {
        this._relatedObservations = value;
    }

    public boolean addRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedObservations == null) {
            this._relatedObservations = new LinkedList<RelatedObservation>();
        }
        return this._relatedObservations.add(value);
    }

    public boolean removeRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedObservations != null && this._relatedObservations.remove(value);
    }

    public List<AssociatedRisk> getRelatedRisks() {
        return this._relatedRisks;
    }

    public void setRelatedRisks(List<AssociatedRisk> value) {
        this._relatedRisks = value;
    }

    public boolean addAssociatedRisk(AssociatedRisk item) {
        AssociatedRisk value = (AssociatedRisk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedRisks == null) {
            this._relatedRisks = new LinkedList<AssociatedRisk>();
        }
        return this._relatedRisks.add(value);
    }

    public boolean removeAssociatedRisk(AssociatedRisk item) {
        AssociatedRisk value = (AssociatedRisk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedRisks != null && this._relatedRisks.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Related Observation", description="Relates the finding to a set of referenced observations that were used to determine the finding.", name="related-observation", moduleClass=OscalAssessmentCommonModule.class)
    public static class RelatedObservation
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Observation Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an observation defined in the list of observations.", name="observation-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _observationUuid;

        public RelatedObservation() {
            this(null);
        }

        public RelatedObservation(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getObservationUuid() {
            return this._observationUuid;
        }

        public void setObservationUuid(UUID value) {
            this._observationUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Associated Risk", description="Relates the finding to a set of referenced risks that were used to determine the finding.", name="associated-risk", moduleClass=OscalAssessmentCommonModule.class)
    public static class AssociatedRisk
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Risk Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a risk defined in the list of risks.", name="risk-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _riskUuid;

        public AssociatedRisk() {
            this(null);
        }

        public AssociatedRisk(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getRiskUuid() {
            return this._riskUuid;
        }

        public void setRiskUuid(UUID value) {
            this._riskUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

