/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaField(formalName="Hash", description="A representation of a cryptographic digest generated over a resource using a specified hash algorithm.", name="hash", moduleClass=OscalMetadataModule.class, valueConstraints=@ValueConstraints(matches={@Matches(level=IConstraint.Level.ERROR, target=".[@algorithm=('SHA-224','SHA3-224')]", pattern="^[0-9a-fA-F]{28}$"), @Matches(level=IConstraint.Level.ERROR, target=".[@algorithm=('SHA-256','SHA3-256')]", pattern="^[0-9a-fA-F]{32}$"), @Matches(level=IConstraint.Level.ERROR, target=".[@algorithm=('SHA-384','SHA3-384')]", pattern="^[0-9a-fA-F]{48}$"), @Matches(level=IConstraint.Level.ERROR, target=".[@algorithm=('SHA-512','SHA3-512')]", pattern="^[0-9a-fA-F]{64}$")}))
public class Hash
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Hash algorithm", description="The digest method by which a hash is derived.", name="algorithm", required=true, typeAdapter=StringAdapter.class, remarks="Any other value used MUST be a value defined in the W3C [XML Security Algorithm Cross-Reference](https://www.w3.org/TR/xmlsec-algorithms/#digest-method-uris) Digest Methods (W3C, April 2013) or [RFC 6931 Section 2.1.5](https://tools.ietf.org/html/rfc6931#section-2.1.5) New SHA Functions.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="SHA-224", description="The SHA-224 algorithm as defined by [NIST FIPS 180-4](https://doi.org/10.6028/NIST.FIPS.180-4)."), @AllowedValue(value="SHA-256", description="The SHA-256 algorithm as defined by [NIST FIPS 180-4](https://doi.org/10.6028/NIST.FIPS.180-4)."), @AllowedValue(value="SHA-384", description="The SHA-384 algorithm as defined by [NIST FIPS 180-4](https://doi.org/10.6028/NIST.FIPS.180-4)."), @AllowedValue(value="SHA-512", description="The SHA-512 algorithm as defined by [NIST FIPS 180-4](https://doi.org/10.6028/NIST.FIPS.180-4)."), @AllowedValue(value="SHA3-224", description="The SHA3-224 algorithm as defined by [NIST FIPS 202](https://doi.org/10.6028/NIST.FIPS.202)."), @AllowedValue(value="SHA3-256", description="The SHA3-256 algorithm as defined by [NIST FIPS 202](https://doi.org/10.6028/NIST.FIPS.202)."), @AllowedValue(value="SHA3-384", description="The SHA3-384 algorithm as defined by [NIST FIPS 202](https://doi.org/10.6028/NIST.FIPS.202)."), @AllowedValue(value="SHA3-512", description="The SHA3-512 algorithm as defined by [NIST FIPS 202](https://doi.org/10.6028/NIST.FIPS.202).")})}))
    private String _algorithm;
    @BoundFieldValue(valueKeyName="value")
    private String _value;

    public Hash() {
        this(null);
    }

    public Hash(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String value) {
        this._algorithm = value;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

