/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ByComponent;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import gov.nist.secauto.oscal.lib.model.SetParameter;
import gov.nist.secauto.oscal.lib.model.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control-based Requirement", description="Describes how the system satisfies the requirements of an individual control.", name="implemented-requirement", moduleClass=OscalSspModule.class, remarks="Use of `set-parameter` in this context, sets the parameter for the referenced control. Any `set-parameter` defined in a child context will override this value. If not overridden by a child, this value applies in the child context.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="(.|statement|.//by-component)/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="control-origination", description="Identifies the source of the implemented control. Any `control-origination` prop defined in a child context will override the parent value.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.|statement|.//by-component)/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='control-origination']/@value", values={@AllowedValue(value="organization", description="The control is implemented by the organization owning the system, but is not specific to the system itself."), @AllowedValue(value="system-specific", description="The control is implemented specifically to this system."), @AllowedValue(value="customer-configured", description="The control is provided by the system, but must be configured by the customer."), @AllowedValue(value="customer-provided", description="The control must be implemented by the customer."), @AllowedValue(value="inherited", description="This control is inherited from an underlying system.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="responsible-role/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-role|statement/responsible-role|.//by-component//responsible-role", indexName="index-metadata-role-id", keyFields={@KeyField(target="@role-id")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-role|statement/responsible-role|.//by-component//responsible-role", indexName="index-metadata-party-uuid", keyFields={@KeyField(target="party-uuid")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-implemented-requirement-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once."), @IsUnique(id="unique-ssp-implemented-requirement-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once."), @IsUnique(id="unique-ssp-implemented-requirement-statement", level=IConstraint.Level.ERROR, target="statement", keyFields={@KeyField(target="@statement-id")}, remarks="Since `statement` entries can be referenced using the statement's statement-id, each statement must be referenced only once."), @IsUnique(id="unique-ssp-implemented-requirement-by-component", level=IConstraint.Level.ERROR, target="by-component", keyFields={@KeyField(target="@component-uuid")}, remarks="Since `by-component` can reference `component` entries using the component's uuid, each component must be referenced only once. This ensures that all implementation statements are contained in the same `by-component` entry.")}, cardinality={@HasCardinality(level=IConstraint.Level.ERROR, target=".//by-component", minOccurs=1)}))
public class ImplementedRequirement
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Requirement Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this control requirement elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `control requirement` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Control Identifier Reference", description="A reference to a control with a corresponding `id` value. When referencing an externally defined `control`, the `Control Identifier Reference` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference).", name="control-id", required=true, typeAdapter=TokenAdapter.class)
    private String _controlId;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<SetParameter> _setParameters;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundAssembly(formalName="Specific Control Statement", description="Identifies which statements within a control are addressed.", useName="statement", maxOccurs=-1, groupAs=@GroupAs(name="statements", inJson=JsonGroupAsBehavior.LIST))
    private List<Statement> _statements;
    @BoundAssembly(formalName="Component Control Implementation", description="Defines how the referenced component implements a set of controls.", useName="by-component", maxOccurs=-1, groupAs=@GroupAs(name="by-components", inJson=JsonGroupAsBehavior.LIST))
    private List<ByComponent> _byComponents;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public ImplementedRequirement() {
        this(null);
    }

    public ImplementedRequirement(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getControlId() {
        return this._controlId;
    }

    public void setControlId(String value) {
        this._controlId = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<SetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<SetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<SetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(SetParameter item) {
        SetParameter value = (SetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public List<Statement> getStatements() {
        return this._statements;
    }

    public void setStatements(List<Statement> value) {
        this._statements = value;
    }

    public boolean addStatement(Statement item) {
        Statement value = (Statement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._statements == null) {
            this._statements = new LinkedList<Statement>();
        }
        return this._statements.add(value);
    }

    public boolean removeStatement(Statement item) {
        Statement value = (Statement)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._statements != null && this._statements.remove(value);
    }

    public List<ByComponent> getByComponents() {
        return this._byComponents;
    }

    public void setByComponents(List<ByComponent> value) {
        this._byComponents = value;
    }

    public boolean addByComponent(ByComponent item) {
        ByComponent value = (ByComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._byComponents == null) {
            this._byComponents = new LinkedList<ByComponent>();
        }
        return this._byComponents.add(value);
    }

    public boolean removeByComponent(ByComponent item) {
        ByComponent value = (ByComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._byComponents != null && this._byComponents.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

