/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.IncludeAll;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.ProfileSelectControlById;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Insert Controls", description="Specifies which controls to use in the containing context.", name="insert-controls", moduleClass=OscalProfileModule.class, remarks="To be schema-valid, this element must contain either (but not both) a single `include-all` directive, or a sequence of `include-controls` directives.\n\nIf this directive is not provided, then no controls are to be inserted; i.e., all controls are included explicitly.")
public class InsertControls
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Order", description="A designation of how a selection of controls in a profile is to be ordered.", name="order", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="keep", description=""), @AllowedValue(value="ascending", description=""), @AllowedValue(value="descending", description="")})}))
    private String _order;
    @BoundAssembly(formalName="Include All", description="Include all controls from the imported catalog or profile resources.", useName="include-all", minOccurs=1)
    private IncludeAll _includeAll;
    @BoundAssembly(formalName="Select Control", description="Select a control or controls from an imported control set.", useName="include-controls", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="include-controls", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileSelectControlById> _includeControls;
    @BoundAssembly(formalName="Select Control", description="Select a control or controls from an imported control set.", useName="exclude-controls", remarks="Identifies which controls to exclude, or eliminate, from the set of matching includes.", maxOccurs=-1, groupAs=@GroupAs(name="exclude-controls", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileSelectControlById> _excludeControls;

    public InsertControls() {
        this(null);
    }

    public InsertControls(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getOrder() {
        return this._order;
    }

    public void setOrder(String value) {
        this._order = value;
    }

    public IncludeAll getIncludeAll() {
        return this._includeAll;
    }

    public void setIncludeAll(IncludeAll value) {
        this._includeAll = value;
    }

    public List<ProfileSelectControlById> getIncludeControls() {
        return this._includeControls;
    }

    public void setIncludeControls(List<ProfileSelectControlById> value) {
        this._includeControls = value;
    }

    public boolean addIncludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._includeControls == null) {
            this._includeControls = new LinkedList<ProfileSelectControlById>();
        }
        return this._includeControls.add(value);
    }

    public boolean removeIncludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._includeControls != null && this._includeControls.remove(value);
    }

    public List<ProfileSelectControlById> getExcludeControls() {
        return this._excludeControls;
    }

    public void setExcludeControls(List<ProfileSelectControlById> value) {
        this._excludeControls = value;
    }

    public boolean addExcludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._excludeControls == null) {
            this._excludeControls = new LinkedList<ProfileSelectControlById>();
        }
        return this._excludeControls.add(value);
    }

    public boolean removeExcludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._excludeControls != null && this._excludeControls.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

