/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Inventory Item", description="A single managed inventory item within the system.", name="inventory-item", moduleClass=OscalImplementationCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="ipv4-address", description="The Internet Protocol v4 Address of the asset."), @AllowedValue(value="ipv6-address", description="The Internet Protocol v6 Address of the asset."), @AllowedValue(value="fqdn", description="The full-qualified domain name (FQDN) of the asset."), @AllowedValue(value="uri", description="A Uniform Resource Identifier (URI) for the asset."), @AllowedValue(value="serial-number", description="A serial number for the asset."), @AllowedValue(value="netbios-name", description="The NetBIOS name for the asset."), @AllowedValue(value="mac-address", description="The media access control (MAC) address for the asset."), @AllowedValue(value="physical-location", description="The physical location of the asset's hardware (e.g., Data Center ID, Cage#, Rack#, or other meaningful location identifiers)."), @AllowedValue(value="is-scanned", description="is the asset subjected to network scans? (yes/no)"), @AllowedValue(value="hardware-model", description="The model number of the hardware used by the asset."), @AllowedValue(value="os-name", description="The name of the operating system used by the asset."), @AllowedValue(value="os-version", description="The version of the operating system used by the asset."), @AllowedValue(value="software-name", description="The software product name used by the asset."), @AllowedValue(value="software-version", description="The software product version used by the asset."), @AllowedValue(value="software-patch-level", description="The software product patch level used by the asset."), @AllowedValue(value="asset-type", description="Simple indication of the asset's function, such as Router, Storage Array, DNS Server."), @AllowedValue(value="asset-id", description="An organizationally specific identifier that is used to uniquely identify a logical or tangible item by the organization that owns the item."), @AllowedValue(value="asset-tag", description="An asset tag assigned by the organization responsible for maintaining the logical or tangible item."), @AllowedValue(value="public", description="Identifies whether the asset is publicly accessible (yes/no)"), @AllowedValue(value="virtual", description="Identifies whether the asset is virtualized (yes/no)"), @AllowedValue(value="vlan-id", description="Virtual LAN identifier of the asset."), @AllowedValue(value="network-id", description="The network identifier of the asset."), @AllowedValue(value="label", description="A human-readable label for the parent context."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="baseline-configuration-name", description="The name of the baseline configuration for the asset."), @AllowedValue(value="allows-authenticated-scan", description="Can the asset be check with an authenticated scan? (yes/no)"), @AllowedValue(value="function", description="The function provided by the asset for the system.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='asset-type']/@value", allowOthers=true, values={@AllowedValue(value="operating-system", description="System software that manages computer hardware, software resources, and provides common services for computer programs."), @AllowedValue(value="database", description="An electronic collection of data, or information, that is specially organized for rapid search and retrieval."), @AllowedValue(value="web-server", description="A system that delivers content or services to end users over the Internet or an intranet."), @AllowedValue(value="dns-server", description="A system that resolves domain names to internet protocol (IP) addresses."), @AllowedValue(value="email-server", description="A computer system that sends and receives electronic mail messages."), @AllowedValue(value="directory-server", description="A system that stores, organizes and provides access to directory information in order to unify network resources."), @AllowedValue(value="pbx", description="A private branch exchange (PBX) provides a a private telephone switchboard."), @AllowedValue(value="firewall", description="A network security system that monitors and controls incoming and outgoing network traffic based on predetermined security rules."), @AllowedValue(value="router", description="A physical or virtual networking device that forwards data packets between computer networks."), @AllowedValue(value="switch", description="A physical or virtual networking device that connects devices within a computer network by using packet switching to receive and forward data to the destination device."), @AllowedValue(value="storage-array", description="A consolidated, block-level data storage capability."), @AllowedValue(value="appliance", description="A physical or virtual machine that centralizes hardware, software, or services for a specific purpose.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="(.)[@type=('software', 'hardware', 'service')]/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="vendor-name", description="The name of the company or organization")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='is-scanned']/@value", values={@AllowedValue(value="yes", description="The asset is included in periodic vulnerability scanning."), @AllowedValue(value="no", description="The asset is not included in periodic vulnerability scanning.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="baseline-template", description="A reference to the baseline template used to configure the asset.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="responsible-party/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset."), @AllowedValue(value="maintainer", description="Responsible for the creation and maintenance of a component."), @AllowedValue(value="provider", description="Organization responsible for providing the component, if this is different from the \"maintainer\" (e.g., a reseller).")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-party", indexName="index-metadata-role-id", keyFields={@KeyField(target="@role-id")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-party", indexName="index-metadata-party-uuid", keyFields={@KeyField(target="party-uuid")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-inventory-item-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
public class InventoryItem
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Inventory Item Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this inventory item elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `inventory item` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Inventory Item Description", description="A summary of the inventory item stating its purpose within the system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleParty> _responsibleParties;
    @BoundAssembly(formalName="Implemented Component", description="The set of components that are implemented in a given system inventory item.", useName="implemented-component", maxOccurs=-1, groupAs=@GroupAs(name="implemented-components", inJson=JsonGroupAsBehavior.LIST))
    private List<ImplementedComponent> _implementedComponents;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public InventoryItem() {
        this(null);
    }

    public InventoryItem(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleParty> getResponsibleParties() {
        return this._responsibleParties;
    }

    public void setResponsibleParties(List<ResponsibleParty> value) {
        this._responsibleParties = value;
    }

    public boolean addResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleParties == null) {
            this._responsibleParties = new LinkedList<ResponsibleParty>();
        }
        return this._responsibleParties.add(value);
    }

    public boolean removeResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleParties != null && this._responsibleParties.remove(value);
    }

    public List<ImplementedComponent> getImplementedComponents() {
        return this._implementedComponents;
    }

    public void setImplementedComponents(List<ImplementedComponent> value) {
        this._implementedComponents = value;
    }

    public boolean addImplementedComponent(ImplementedComponent item) {
        ImplementedComponent value = (ImplementedComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._implementedComponents == null) {
            this._implementedComponents = new LinkedList<ImplementedComponent>();
        }
        return this._implementedComponents.add(value);
    }

    public boolean removeImplementedComponent(ImplementedComponent item) {
        ImplementedComponent value = (ImplementedComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._implementedComponents != null && this._implementedComponents.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Implemented Component", description="The set of components that are implemented in a given system inventory item.", name="implemented-component", moduleClass=OscalImplementationCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="version", description="The version of the component."), @AllowedValue(value="patch-level", description="The specific patch level of the component."), @AllowedValue(value="model", description="The model of the component."), @AllowedValue(value="release-date", description="The date the component was released, such as a software release date or policy publication date."), @AllowedValue(value="validation-type", description="Used with component-type='validation' to provide a well-known name for a kind of validation."), @AllowedValue(value="validation-reference", description="Used with component-type='validation' to indicate the validating body's assigned identifier for their validation of this component."), @AllowedValue(value="asset-type", description="Simple indication of the asset's function, such as Router, Storage Array, DNS Server."), @AllowedValue(value="asset-id", description="An organizationally specific identifier that is used to uniquely identify a logical or tangible item by the organization that owns the item."), @AllowedValue(value="asset-tag", description="An asset tag assigned by the organization responsible for maintaining the logical or tangible item."), @AllowedValue(value="public", description="Identifies whether the asset is publicly accessible (yes/no)"), @AllowedValue(value="virtual", description="Identifies whether the asset is virtualized (yes/no)"), @AllowedValue(value="vlan-id", description="Virtual LAN identifier of the asset."), @AllowedValue(value="network-id", description="The network identifier of the asset."), @AllowedValue(value="label", description="A human-readable label for the parent context."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="baseline-configuration-name", description="The name of the baseline configuration for the asset."), @AllowedValue(value="allows-authenticated-scan", description="Can the asset be check with an authenticated scan? (yes/no)"), @AllowedValue(value="function", description="The function provided by the asset for the system.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="responsible-party/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset.")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-implemented-component-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}, cardinality={@HasCardinality(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='asset-id']", minOccurs=1)}))
    public static class ImplementedComponent
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Component Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a `component` that is implemented as part of an inventory item.", name="component-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _componentUuid;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", remarks="This construct is used to either: 1) associate a party or parties to a role defined on the component using the `responsible-role` construct, or 2) to define a party or parties that are responsible for a role defined within the context of the containing `inventory-item`.", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
        private List<ResponsibleParty> _responsibleParties;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public ImplementedComponent() {
            this(null);
        }

        public ImplementedComponent(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getComponentUuid() {
            return this._componentUuid;
        }

        public void setComponentUuid(UUID value) {
            this._componentUuid = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<ResponsibleParty> getResponsibleParties() {
            return this._responsibleParties;
        }

        public void setResponsibleParties(List<ResponsibleParty> value) {
            this._responsibleParties = value;
        }

        public boolean addResponsibleParty(ResponsibleParty item) {
            ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibleParties == null) {
                this._responsibleParties = new LinkedList<ResponsibleParty>();
            }
            return this._responsibleParties.add(value);
        }

        public boolean removeResponsibleParty(ResponsibleParty item) {
            ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibleParties != null && this._responsibleParties.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

