/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractLink;
import java.net.URI;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", name="link", moduleClass=OscalMetadataModule.class, remarks="To provide a cryptographic hash for a remote target resource, a local reference to a back matter `resource` is needed. The resource allows one or more hash values to be provided using the `rlink/hash` object.\n\nThe OSCAL `link` is a roughly based on the HTML [link element](https://www.w3.org/TR/html401/struct/links.html#edef-LINK).", valueConstraints=@ValueConstraints(indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target=".[@rel=('reference') and starts-with(@href,'#')]", indexName="index-back-matter-resource", keyFields={@KeyField(target="@href", pattern="#(.*)")})}, matches={@Matches(level=IConstraint.Level.ERROR, target=".[@rel=('reference') and starts-with(@href,'#')]/@href", typeAdapter=UriReferenceAdapter.class), @Matches(level=IConstraint.Level.ERROR, target=".[@rel=('reference') and not(starts-with(@href,'#'))]/@href", typeAdapter=UriAdapter.class), @Matches(level=IConstraint.Level.ERROR, target="@resource-fragment", pattern="(?:[0-9a-zA-Z-._~/?!$&'()*+,;=:@]|%[0-9A-F][0-9A-F])+", remarks="This pattern is based on the fragment Augmented Backus-Naur form (ABNF) syntax provided in \\[RFC3986 section 3.5\\](https://www.rfc-editor.org/rfc/rfc3986#section-3.5). Uppercase alpha hex digits are required, which is the preferred normalized form defined in RFC3986.")}, expect={@Expect(description="A local reference SHOULD NOT have a media-type.", level=IConstraint.Level.ERROR, target=".[starts-with(@href,'#')]", test="not(exists(@media-type))", remarks="Since both `link` and `back-matter/resource` both allow specification of a `media-type`, the `media-type` on `link` may conflict with the any `media-type` entries on a resource's `rlink` or `base64` objects. This constraint prevents this from occurring.")}))
public class Link
extends AbstractLink
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Hypertext Reference", description="A resolvable URL reference to a resource.", name="href", required=true, typeAdapter=UriReferenceAdapter.class, remarks="This value may be one of:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or\n3. a bare URI fragment (i.e., \\`#uuid\\`) pointing to an OSCAL object by the objects identifier (e.g., id, uuid) in this or an imported document (see [linking to another OSCAL object](https://pages.nist.gov/OSCAL/concepts/uri-use/#linking-to-another-oscal-object)). The specific object type will differ based on the link relationship type.")
    private URI _href;
    @BoundFlag(formalName="Link Relation Type", description="Describes the type of relationship provided by the link's hypertext reference. This can be an indicator of the link's purpose.", name="rel", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="reference", description="A generalized reference to a network resource (relative or absolute) or to a `back-matter` resource by UUID expressed as a bare URI fragment.")})}))
    private String _rel;
    @BoundFlag(formalName="Link Media Type", description="A label that indicates the nature of a resource, as a data serialization or format.", name="media-type", typeAdapter=StringAdapter.class, remarks="The `media-type` provides a hint about the content model of the referenced resource. A valid entry from the [IANA Media Types registry](https://www.iana.org/assignments/media-types/media-types.xhtml) SHOULD be used.")
    private String _mediaType;
    @BoundFlag(formalName="Resource Fragment", description="In case where the `href` points to a `back-matter/resource`, this value will indicate the URI [fragment](https://www.rfc-editor.org/rfc/rfc3986#section-3.5) to append to any `rlink` associated with the resource. This value MUST be [URI encoded](https://www.rfc-editor.org/rfc/rfc3986#section-2.1).", name="resource-fragment", typeAdapter=StringAdapter.class)
    private String _resourceFragment;
    @BoundField(formalName="Link Text", description="A textual label to associate with the link, which may be used for presentation in a tool.", useName="text", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _text;

    public Link() {
        this(null);
    }

    public Link(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public URI getHref() {
        return this._href;
    }

    public void setHref(URI value) {
        this._href = value;
    }

    public String getRel() {
        return this._rel;
    }

    public void setRel(String value) {
        this._rel = value;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public void setMediaType(String value) {
        this._mediaType = value;
    }

    public String getResourceFragment() {
        return this._resourceFragment;
    }

    public void setResourceFragment(String value) {
        this._resourceFragment = value;
    }

    public MarkupLine getText() {
        return this._text;
    }

    public void setText(MarkupLine value) {
        this._text = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

