/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AssessmentAssets;
import gov.nist.secauto.oscal.lib.model.InventoryItem;
import gov.nist.secauto.oscal.lib.model.OscalPoamModule;
import gov.nist.secauto.oscal.lib.model.SystemComponent;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Local Definitions", description="Allows components, and inventory-items to be defined within the POA\\&M for circumstances where no OSCAL-based SSP exists, or is not delivered with the POA\\&M.", name="local-definitions", moduleClass=OscalPoamModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-poam-local-definitions-component", level=IConstraint.Level.ERROR, target="component", keyFields={@KeyField(target="@uuid")}, remarks="Since multiple `component` entries can be provided, each component must have a unique `uuid`.")}))
public class LocalDefinitions
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", remarks="Used to add any components, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
    private List<SystemComponent> _components;
    @BoundAssembly(formalName="Inventory Item", description="A single managed inventory item within the system.", useName="inventory-item", remarks="Used to add any inventory-items, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="inventory-items", inJson=JsonGroupAsBehavior.LIST))
    private List<InventoryItem> _inventoryItems;
    @BoundAssembly(formalName="Assessment Assets", description="Identifies the assets used to perform this assessment, such as the assessment team, scanning tools, and assumptions.", useName="assessment-assets", remarks="Specifies components or assessment-platforms used in the assessment.")
    private AssessmentAssets _assessmentAssets;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public LocalDefinitions() {
        this(null);
    }

    public LocalDefinitions(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<SystemComponent> getComponents() {
        return this._components;
    }

    public void setComponents(List<SystemComponent> value) {
        this._components = value;
    }

    public boolean addComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._components == null) {
            this._components = new LinkedList<SystemComponent>();
        }
        return this._components.add(value);
    }

    public boolean removeComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._components != null && this._components.remove(value);
    }

    public List<InventoryItem> getInventoryItems() {
        return this._inventoryItems;
    }

    public void setInventoryItems(List<InventoryItem> value) {
        this._inventoryItems = value;
    }

    public boolean addInventoryItem(InventoryItem item) {
        InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._inventoryItems == null) {
            this._inventoryItems = new LinkedList<InventoryItem>();
        }
        return this._inventoryItems.add(value);
    }

    public boolean removeInventoryItem(InventoryItem item) {
        InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._inventoryItems != null && this._inventoryItems.remove(value);
    }

    public AssessmentAssets getAssessmentAssets() {
        return this._assessmentAssets;
    }

    public void setAssessmentAssets(AssessmentAssets value) {
        this._assessmentAssets = value;
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

