/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Logged By", description="Used to indicate who created a log entry in what role.", name="logged-by", moduleClass=OscalAssessmentCommonModule.class)
public class LoggedBy
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Party UUID Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to the party who is making the log entry.", name="party-uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _partyUuid;
    @BoundFlag(formalName="Actor Role", description="A point to the role-id of the role in which the party is making the log entry.", name="role-id", typeAdapter=TokenAdapter.class)
    private String _roleId;

    public LoggedBy() {
        this(null);
    }

    public LoggedBy(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getPartyUuid() {
        return this._partyUuid;
    }

    public void setPartyUuid(UUID value) {
        this._partyUuid = value;
    }

    public String getRoleId() {
        return this._roleId;
    }

    public void setRoleId(String value) {
        this._roleId = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

