/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.BooleanAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.InsertControls;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.ProfileGroup;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Merge Controls", description="Provides structuring directives that instruct how controls are organized after profile resolution.", name="merge", moduleClass=OscalProfileModule.class)
public class Merge
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Combination Rule", description="A Combine element defines how to resolve duplicate instances of the same control (e.g., controls with the same ID).", useName="combine")
    private Combine _combine;
    @BoundAssembly(formalName="Flat Without Grouping", description="Directs that controls appear without any grouping structure.", useName="flat", minOccurs=1)
    private Flat _flat;
    @BoundField(formalName="Group As-Is", description="Indicates that the controls selected should retain their original grouping as defined in the import source.", useName="as-is", minOccurs=1, typeAdapter=BooleanAdapter.class)
    private Boolean _asIs;
    @BoundAssembly(formalName="Custom Grouping", description="Provides an alternate grouping structure that selected controls will be placed in.", useName="custom", remarks="The `custom` element represents a custom arrangement or organization of controls in the resolution of a catalog. This structuring directive gives the profile author the ability to define an entirely different organization of controls as compared to their source catalog(s).", minOccurs=1)
    private Custom _custom;

    public Merge() {
        this(null);
    }

    public Merge(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public Combine getCombine() {
        return this._combine;
    }

    public void setCombine(Combine value) {
        this._combine = value;
    }

    public Flat getFlat() {
        return this._flat;
    }

    public void setFlat(Flat value) {
        this._flat = value;
    }

    public Boolean getAsIs() {
        return this._asIs;
    }

    public void setAsIs(Boolean value) {
        this._asIs = value;
    }

    public Custom getCustom() {
        return this._custom;
    }

    public void setCustom(Custom value) {
        this._custom = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Combination Rule", description="A Combine element defines how to resolve duplicate instances of the same control (e.g., controls with the same ID).", name="combine", moduleClass=OscalProfileModule.class, valueConstraints=@ValueConstraints(expect={@Expect(id="req-merge-combine", level=IConstraint.Level.ERROR, test="not(@method='merge')")}))
    public static class Combine
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Combination Method", description="Declare how clashing controls should be handled.", name="method", typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="use-first", description="Use the first definition - the first control with a given ID is used; subsequent ones are discarded"), @AllowedValue(value="merge", description="\\*\\*(*deprecated* )\\*\\* \\*\\*(*unspecified*)\\*\\* Merge - controls with the same ID are combined", deprecatedVersion="1.0.1"), @AllowedValue(value="keep", description="Keep - controls with the same ID are kept, retaining the clash")})}))
        private String _method;

        public Combine() {
            this(null);
        }

        public Combine(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getMethod() {
            return this._method;
        }

        public void setMethod(String value) {
            this._method = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Flat Without Grouping", description="Directs that controls appear without any grouping structure.", name="flat", moduleClass=OscalProfileModule.class)
    public static class Flat
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;

        public Flat() {
            this(null);
        }

        public Flat(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Custom Grouping", description="Provides an alternate grouping structure that selected controls will be placed in.", name="custom", moduleClass=OscalProfileModule.class, remarks="The `custom` element represents a custom arrangement or organization of controls in the resolution of a catalog. This structuring directive gives the profile author the ability to define an entirely different organization of controls as compared to their source catalog(s).")
    public static class Custom
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Control Group", description="A group of (selected) controls or of groups of controls.", useName="group", maxOccurs=-1, groupAs=@GroupAs(name="groups", inJson=JsonGroupAsBehavior.LIST))
        private List<ProfileGroup> _groups;
        @BoundAssembly(formalName="Insert Controls", description="Specifies which controls to use in the containing context.", useName="insert-controls", maxOccurs=-1, groupAs=@GroupAs(name="insert-controls", inJson=JsonGroupAsBehavior.LIST))
        private List<InsertControls> _insertControls;

        public Custom() {
            this(null);
        }

        public Custom(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<ProfileGroup> getGroups() {
            return this._groups;
        }

        public void setGroups(List<ProfileGroup> value) {
            this._groups = value;
        }

        public boolean addGroup(ProfileGroup item) {
            ProfileGroup value = (ProfileGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._groups == null) {
                this._groups = new LinkedList<ProfileGroup>();
            }
            return this._groups.add(value);
        }

        public boolean removeGroup(ProfileGroup item) {
            ProfileGroup value = (ProfileGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._groups != null && this._groups.remove(value);
        }

        public List<InsertControls> getInsertControls() {
            return this._insertControls;
        }

        public void setInsertControls(List<InsertControls> value) {
            this._insertControls = value;
        }

        public boolean addInsertControls(InsertControls item) {
            InsertControls value = (InsertControls)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._insertControls == null) {
                this._insertControls = new LinkedList<InsertControls>();
            }
            return this._insertControls.add(value);
        }

        public boolean removeInsertControls(InsertControls item) {
            InsertControls value = (InsertControls)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._insertControls != null && this._insertControls.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

