/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.EmailAddressAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Action;
import gov.nist.secauto.oscal.lib.model.Address;
import gov.nist.secauto.oscal.lib.model.DocumentId;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import gov.nist.secauto.oscal.lib.model.TelephoneNumber;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractMetadata;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", name="metadata", moduleClass=OscalMetadataModule.class, remarks="All OSCAL documents use the same metadata structure, that provides a consistent way of expressing OSCAL document metadata across all OSCAL models. The metadata section also includes declarations of individual objects (i.e., roles, location, parties) that may be referenced within and across linked OSCAL documents.\n\nThe metadata in an OSCAL document has few required fields, representing only the bare minimum data needed to differentiate one instance from another. Tools and users creating OSCAL documents may choose to use any of the optional fields, as well as extension mechanisms (e.g., properties, links) to go beyond this minimum to suit their use cases.\n\nA publisher of OSCAL content can use the `published`, `last-modified`, and `version` fields to establish information about an individual in a sequence of successive revisions of a given OSCAL-based publication. The metadata for a previous revision can be represented as a `revision` within this object. Links may also be provided using the `predecessor-version` and `successor-version` link relations to provide for direct access to the related resource. These relations can be provided as a link child of this object or as `link` within a given `revision`.\n\nA `responsible-party` entry in this context refers to roles and parties that have responsibility relative to the production, review, publication, and use of the containing document.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(id="allowed-metadata-responsibe-party-role-ids", level=IConstraint.Level.ERROR, target="responsible-party/@role-id", allowOthers=true, values={@AllowedValue(value="creator", description="Indicates the person or organization that created this content."), @AllowedValue(value="prepared-by", description="Indicates the person or organization that prepared this content."), @AllowedValue(value="prepared-for", description="Indicates the person or organization for which this content was created."), @AllowedValue(value="content-approver", description="Indicates the person or organization responsible for all content represented in the \"document\"."), @AllowedValue(value="contact", description="Indicates the person or organization to contact for questions or support related to this content.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="keywords", description="The value identifies a comma-seperated listing of keywords associated with this content. These keywords may be used as search terms for indexing and other applications.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="canonical", description="The link identifies the authoritative location for this resource. Defined by [RFC 6596](https://tools.ietf.org/html/rfc6596)."), @AllowedValue(value="alternate", description="The link identifies an alternative location or format for this resource. Defined by [the HTML Living Standard](https://html.spec.whatwg.org/multipage/links.html#linkTypes)"), @AllowedValue(value="latest-version", description="This link identifies a resource containing the latest version in the version history. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829)."), @AllowedValue(value="predecessor-version", description="This link identifies a resource containing the predecessor version in the version history. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829)."), @AllowedValue(value="successor-version", description="This link identifies a resource containing the predecessor version in the version history. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829).")})}), modelConstraints=@AssemblyConstraints(index={@Index(id="index-metadata-roles", level=IConstraint.Level.ERROR, target="role", name="index-metadata-role-ids", keyFields={@KeyField(target="@id")}), @Index(id="index-metadata-property-uuid", level=IConstraint.Level.ERROR, target=".//prop", name="index-metadata-property-uuid", keyFields={@KeyField(target="@uuid")}), @Index(id="index-metadata-role-id", level=IConstraint.Level.ERROR, target="role", name="index-metadata-role-id", keyFields={@KeyField(target="@id")}), @Index(id="index-metadata-location-uuid", level=IConstraint.Level.ERROR, target="location", name="index-metadata-location-uuid", keyFields={@KeyField(target="@uuid")}), @Index(id="index-metadata-party-uuid", level=IConstraint.Level.ERROR, target="party", name="index-metadata-party-uuid", keyFields={@KeyField(target="@uuid")}), @Index(id="index-metadata-party-organizations-uuid", level=IConstraint.Level.ERROR, target="party[@type='organization']", name="index-metadata-party-organizations-uuid", keyFields={@KeyField(target="@uuid")})}, unique={@IsUnique(id="unique-metadata-doc-id", level=IConstraint.Level.ERROR, target="document-id", keyFields={@KeyField(target="@scheme"), @KeyField}), @IsUnique(id="unique-metadata-property", level=IConstraint.Level.ERROR, target="prop", keyFields={@KeyField(target="@name"), @KeyField(target="@ns"), @KeyField(target="@class"), @KeyField(target="@group"), @KeyField(target="@value")}), @IsUnique(id="unique-metadata-link", level=IConstraint.Level.ERROR, target="link", keyFields={@KeyField(target="@href"), @KeyField(target="@rel"), @KeyField(target="@media-type")}), @IsUnique(id="unique-metadata-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once."), @IsUnique(level=IConstraint.Level.ERROR, target="document-id", keyFields={@KeyField(target="@scheme"), @KeyField}, remarks="The combination of `scheme` and the field value must be unique.")}))
public class Metadata
extends AbstractMetadata
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Document Title", description="A name given to the document, which may be used by a tool for display and navigation.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Publication Timestamp", description="The date and time the document was last made available.", useName="published", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _published;
    @BoundField(formalName="Last Modified Timestamp", description="The date and time the document was last stored for later retrieval.", useName="last-modified", minOccurs=1, typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _lastModified;
    @BoundField(formalName="Document Version", description="Used to distinguish a specific revision of an OSCAL document from other previous and future versions.", useName="version", minOccurs=1)
    private String _version;
    @BoundField(formalName="OSCAL Version", description="The OSCAL model version the document was authored against and will conform to as valid.", useName="oscal-version", minOccurs=1)
    private String _oscalVersion;
    @BoundAssembly(formalName="Revision History Entry", description="An entry in a sequential list of revisions to the containing document, expected to be in reverse chronological order (i.e. latest first).", useName="revision", remarks="While `published`, `last-modified`, and `oscal-version` are not required, values for these entries should be provided if the information is known. A `link` with a `rel` of \"source\" should be provided if the information is known.", maxOccurs=-1, groupAs=@GroupAs(name="revisions", inJson=JsonGroupAsBehavior.LIST, inXml=XmlGroupAsBehavior.GROUPED))
    private List<Revision> _revisions;
    @BoundField(formalName="Document Identifier", description="A document identifier qualified by an identifier `scheme`.", useName="document-id", maxOccurs=-1, groupAs=@GroupAs(name="document-ids", inJson=JsonGroupAsBehavior.LIST))
    private List<DocumentId> _documentIds;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Role", description="Defines a function, which might be assigned to a party in a specific situation.", useName="role", remarks="Permissible values to be determined closer to the application (e.g. by a receiving authority).\n\nOSCAL has defined a set of standardized roles for consistent use in OSCAL documents. This allows tools consuming OSCAL content to infer specific semantics when these roles are used. These roles are documented in the specific contexts of their use (e.g., responsible-party, responsible-role). When using such a role, it is necessary to define these roles in this list, which will then allow such a role to be referenced.", maxOccurs=-1, groupAs=@GroupAs(name="roles", inJson=JsonGroupAsBehavior.LIST))
    private List<Role> _roles;
    @BoundAssembly(formalName="Location", description="A physical point of presence, which may be associated with people, organizations, or other concepts within the current or linked OSCAL document.", useName="location", remarks="An address might be sensitive in nature. In such cases a title, mailing address, email-address, and/or phone number may be used instead.", maxOccurs=-1, groupAs=@GroupAs(name="locations", inJson=JsonGroupAsBehavior.LIST))
    private List<Location> _locations;
    @BoundAssembly(formalName="Party", description="An organization or person, which may be associated with roles or other concepts within the current or linked OSCAL document.", useName="party", remarks="A party can be optionally associated with either an address or a location. While providing a meaningful location for a party is desired, there are some cases where it might not be possible to provide an exact location or even any location.", maxOccurs=-1, groupAs=@GroupAs(name="parties", inJson=JsonGroupAsBehavior.LIST))
    private List<Party> _parties;
    @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleParty> _responsibleParties;
    @BoundAssembly(formalName="Action", description="An action applied by a role within a given party to the content.", useName="action", maxOccurs=-1, groupAs=@GroupAs(name="actions", inJson=JsonGroupAsBehavior.LIST))
    private List<Action> _actions;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Metadata() {
        this(null);
    }

    public Metadata(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public ZonedDateTime getPublished() {
        return this._published;
    }

    public void setPublished(ZonedDateTime value) {
        this._published = value;
    }

    public ZonedDateTime getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(ZonedDateTime value) {
        this._lastModified = value;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public String getOscalVersion() {
        return this._oscalVersion;
    }

    public void setOscalVersion(String value) {
        this._oscalVersion = value;
    }

    public List<Revision> getRevisions() {
        return this._revisions;
    }

    public void setRevisions(List<Revision> value) {
        this._revisions = value;
    }

    public boolean addRevision(Revision item) {
        Revision value = (Revision)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._revisions == null) {
            this._revisions = new LinkedList<Revision>();
        }
        return this._revisions.add(value);
    }

    public boolean removeRevision(Revision item) {
        Revision value = (Revision)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._revisions != null && this._revisions.remove(value);
    }

    public List<DocumentId> getDocumentIds() {
        return this._documentIds;
    }

    public void setDocumentIds(List<DocumentId> value) {
        this._documentIds = value;
    }

    public boolean addDocumentId(DocumentId item) {
        DocumentId value = (DocumentId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._documentIds == null) {
            this._documentIds = new LinkedList<DocumentId>();
        }
        return this._documentIds.add(value);
    }

    public boolean removeDocumentId(DocumentId item) {
        DocumentId value = (DocumentId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._documentIds != null && this._documentIds.remove(value);
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    @Override
    public List<Role> getRoles() {
        return this._roles;
    }

    public void setRoles(List<Role> value) {
        this._roles = value;
    }

    public boolean addRole(Role item) {
        Role value = (Role)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._roles == null) {
            this._roles = new LinkedList<Role>();
        }
        return this._roles.add(value);
    }

    public boolean removeRole(Role item) {
        Role value = (Role)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._roles != null && this._roles.remove(value);
    }

    @Override
    public List<Location> getLocations() {
        return this._locations;
    }

    public void setLocations(List<Location> value) {
        this._locations = value;
    }

    public boolean addLocation(Location item) {
        Location value = (Location)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._locations == null) {
            this._locations = new LinkedList<Location>();
        }
        return this._locations.add(value);
    }

    public boolean removeLocation(Location item) {
        Location value = (Location)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._locations != null && this._locations.remove(value);
    }

    @Override
    public List<Party> getParties() {
        return this._parties;
    }

    public void setParties(List<Party> value) {
        this._parties = value;
    }

    public boolean addParty(Party item) {
        Party value = (Party)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._parties == null) {
            this._parties = new LinkedList<Party>();
        }
        return this._parties.add(value);
    }

    public boolean removeParty(Party item) {
        Party value = (Party)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._parties != null && this._parties.remove(value);
    }

    public List<ResponsibleParty> getResponsibleParties() {
        return this._responsibleParties;
    }

    public void setResponsibleParties(List<ResponsibleParty> value) {
        this._responsibleParties = value;
    }

    public boolean addResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleParties == null) {
            this._responsibleParties = new LinkedList<ResponsibleParty>();
        }
        return this._responsibleParties.add(value);
    }

    public boolean removeResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleParties != null && this._responsibleParties.remove(value);
    }

    public List<Action> getActions() {
        return this._actions;
    }

    public void setActions(List<Action> value) {
        this._actions = value;
    }

    public boolean addAction(Action item) {
        Action value = (Action)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._actions == null) {
            this._actions = new LinkedList<Action>();
        }
        return this._actions.add(value);
    }

    public boolean removeAction(Action item) {
        Action value = (Action)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._actions != null && this._actions.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Revision History Entry", description="An entry in a sequential list of revisions to the containing document, expected to be in reverse chronological order (i.e. latest first).", name="revision", moduleClass=OscalMetadataModule.class, remarks="While `published`, `last-modified`, and `oscal-version` are not required, values for these entries should be provided if the information is known. A `link` with a `rel` of \"source\" should be provided if the information is known.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="canonical", description="The link identifies the authoritative location for this resource. Defined by [RFC 6596](https://tools.ietf.org/html/rfc6596)."), @AllowedValue(value="alternate", description="The link identifies an alternative location or format for this resource. Defined by [the HTML Living Standard](https://html.spec.whatwg.org/multipage/links.html#linkTypes)"), @AllowedValue(value="predecessor-version", description="This link identifies a resource containing the predecessor version in the version history. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829)."), @AllowedValue(value="successor-version", description="This link identifies a resource containing the predecessor version in the version history. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829)."), @AllowedValue(value="version-history", description="This link identifies a resource containing the version history of this document. Defined by [RFC 5829](https://tools.ietf.org/html/rfc5829).")})}))
    public static class Revision
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundField(formalName="Document Title", description="A name given to the document revision, which may be used by a tool for display and navigation.", useName="title", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundField(formalName="Publication Timestamp", description="The date and time the document was last made available.", useName="published", typeAdapter=DateTimeWithTZAdapter.class)
        private ZonedDateTime _published;
        @BoundField(formalName="Last Modified Timestamp", description="The date and time the document was last stored for later retrieval.", useName="last-modified", typeAdapter=DateTimeWithTZAdapter.class)
        private ZonedDateTime _lastModified;
        @BoundField(formalName="Document Version", description="Used to distinguish a specific revision of an OSCAL document from other previous and future versions.", useName="version", minOccurs=1)
        private String _version;
        @BoundField(formalName="OSCAL Version", description="The OSCAL model version the document was authored against and will conform to as valid.", useName="oscal-version")
        private String _oscalVersion;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Revision() {
            this(null);
        }

        public Revision(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public ZonedDateTime getPublished() {
            return this._published;
        }

        public void setPublished(ZonedDateTime value) {
            this._published = value;
        }

        public ZonedDateTime getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(ZonedDateTime value) {
            this._lastModified = value;
        }

        public String getVersion() {
            return this._version;
        }

        public void setVersion(String value) {
            this._version = value;
        }

        public String getOscalVersion() {
            return this._oscalVersion;
        }

        public void setOscalVersion(String value) {
            this._oscalVersion = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Role", description="Defines a function, which might be assigned to a party in a specific situation.", name="role", moduleClass=OscalMetadataModule.class, remarks="Permissible values to be determined closer to the application (e.g. by a receiving authority).\n\nOSCAL has defined a set of standardized roles for consistent use in OSCAL documents. This allows tools consuming OSCAL content to infer specific semantics when these roles are used. These roles are documented in the specific contexts of their use (e.g., responsible-party, responsible-role). When using such a role, it is necessary to define these roles in this list, which will then allow such a role to be referenced.")
    public static class Role
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Role Identifier", description="A unique identifier for the role.", name="id", required=true, typeAdapter=TokenAdapter.class)
        private String _id;
        @BoundField(formalName="Role Title", description="A name given to the role, which may be used by a tool for display and navigation.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundField(formalName="Role Short Name", description="A short common name, abbreviation, or acronym for the role.", useName="short-name")
        private String _shortName;
        @BoundField(formalName="Role Description", description="A summary of the role's purpose and associated responsibilities.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Role() {
            this(null);
        }

        public Role(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getId() {
            return this._id;
        }

        public void setId(String value) {
            this._id = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public String getShortName() {
            return this._shortName;
        }

        public void setShortName(String value) {
            this._shortName = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Location", description="A physical point of presence, which may be associated with people, organizations, or other concepts within the current or linked OSCAL document.", name="location", moduleClass=OscalMetadataModule.class, remarks="An address might be sensitive in nature. In such cases a title, mailing address, email-address, and/or phone number may be used instead.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="type", description="Characterizes the kind of location.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type']/@value", values={@AllowedValue(value="data-center", description="A location that contains computing assets. A `class` can be used to indicate the sub-type of data-center as *primary* or *alternate*.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type' and @value='data-center']/@class", values={@AllowedValue(value="primary", description="The location is a data-center used for normal operations."), @AllowedValue(value="alternate", description="The location is a data-center used for fail-over or backup operations.")})}), modelConstraints=@AssemblyConstraints(cardinality={@HasCardinality(description="In most cases, it is useful to define a location. In some cases, defining an explicit location may represent a security risk.", level=IConstraint.Level.WARNING, target="address", minOccurs=1), @HasCardinality(description="A location must have at least a title, address, email-address, or telephone number.", level=IConstraint.Level.ERROR, target="title|address|email-address|telephone-number", minOccurs=1)}))
    public static class Location
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Location Universally Unique Identifier", description="A unique ID for the location, for reference.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundField(formalName="Location Title", description="A name given to the location, which may be used by a tool for display and navigation.", useName="title", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundAssembly(formalName="Address", description="A postal address for the location.", useName="address", remarks="The physical address of the location, which will provided for physical locations. Virtual locations can omit this data item.")
        private Address _address;
        @BoundField(formalName="Email Address", description="An email address as defined by [RFC 5322 Section 3.4.1](https://tools.ietf.org/html/rfc5322#section-3.4.1).", useName="email-address", remarks="A contact email associated with the location.", maxOccurs=-1, groupAs=@GroupAs(name="email-addresses", inJson=JsonGroupAsBehavior.LIST), typeAdapter=EmailAddressAdapter.class)
        private List<String> _emailAddresses;
        @BoundField(formalName="Telephone Number", description="A telephone service number as defined by [ITU-T E.164](https://www.itu.int/rec/T-REC-E.164-201011-I/en).", useName="telephone-number", remarks="A phone number used to contact the location.", maxOccurs=-1, groupAs=@GroupAs(name="telephone-numbers", inJson=JsonGroupAsBehavior.LIST))
        private List<TelephoneNumber> _telephoneNumbers;
        @BoundField(formalName="Location URL", description="The uniform resource locator (URL) for a web site or other resource associated with the location.", useName="url", remarks="This data field is deprecated in favor of using a link with an appropriate relationship.", maxOccurs=-1, groupAs=@GroupAs(name="urls", inJson=JsonGroupAsBehavior.LIST), typeAdapter=UriAdapter.class)
        private List<URI> _urls;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Location() {
            this(null);
        }

        public Location(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public Address getAddress() {
            return this._address;
        }

        public void setAddress(Address value) {
            this._address = value;
        }

        public List<String> getEmailAddresses() {
            return this._emailAddresses;
        }

        public void setEmailAddresses(List<String> value) {
            this._emailAddresses = value;
        }

        public boolean addEmailAddress(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._emailAddresses == null) {
                this._emailAddresses = new LinkedList<String>();
            }
            return this._emailAddresses.add(value);
        }

        public boolean removeEmailAddress(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._emailAddresses != null && this._emailAddresses.remove(value);
        }

        public List<TelephoneNumber> getTelephoneNumbers() {
            return this._telephoneNumbers;
        }

        public void setTelephoneNumbers(List<TelephoneNumber> value) {
            this._telephoneNumbers = value;
        }

        public boolean addTelephoneNumber(TelephoneNumber item) {
            TelephoneNumber value = (TelephoneNumber)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._telephoneNumbers == null) {
                this._telephoneNumbers = new LinkedList<TelephoneNumber>();
            }
            return this._telephoneNumbers.add(value);
        }

        public boolean removeTelephoneNumber(TelephoneNumber item) {
            TelephoneNumber value = (TelephoneNumber)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._telephoneNumbers != null && this._telephoneNumbers.remove(value);
        }

        public List<URI> getUrls() {
            return this._urls;
        }

        public void setUrls(List<URI> value) {
            this._urls = value;
        }

        public boolean addUrl(URI item) {
            URI value = (URI)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._urls == null) {
                this._urls = new LinkedList<URI>();
            }
            return this._urls.add(value);
        }

        public boolean removeUrl(URI item) {
            URI value = (URI)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._urls != null && this._urls.remove(value);
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Party", description="An organization or person, which may be associated with roles or other concepts within the current or linked OSCAL document.", name="party", moduleClass=OscalMetadataModule.class, remarks="A party can be optionally associated with either an address or a location. While providing a meaningful location for a party is desired, there are some cases where it might not be possible to provide an exact location or even any location.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="mail-stop", description="A mail stop associated with the party."), @AllowedValue(value="office", description="The name or number of the party's office."), @AllowedValue(value="job-title", description="The formal job title of a person.")})}))
    public static class Party
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Party Universally Unique Identifier", description="A unique identifier for the party.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundFlag(formalName="Party Type", description="A category describing the kind of party the object describes.", name="type", required=true, typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="person", description="A human being regarded as an individual."), @AllowedValue(value="organization", description="An organized group of one or more `person` individuals with a specific purpose.")})}))
        private String _type;
        @BoundField(formalName="Party Name", description="The full name of the party. This is typically the legal name associated with the party.", useName="name")
        private String _name;
        @BoundField(formalName="Party Short Name", description="A short common name, abbreviation, or acronym for the party.", useName="short-name")
        private String _shortName;
        @BoundField(formalName="Party External Identifier", description="An identifier for a person or organization using a designated scheme. e.g. an Open Researcher and Contributor ID (ORCID).", useName="external-id", maxOccurs=-1, groupAs=@GroupAs(name="external-ids", inJson=JsonGroupAsBehavior.LIST))
        private List<ExternalId> _externalIds;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Email Address", description="An email address as defined by [RFC 5322 Section 3.4.1](https://tools.ietf.org/html/rfc5322#section-3.4.1).", useName="email-address", remarks="This is a contact email associated with the party.", maxOccurs=-1, groupAs=@GroupAs(name="email-addresses", inJson=JsonGroupAsBehavior.LIST), typeAdapter=EmailAddressAdapter.class)
        private List<String> _emailAddresses;
        @BoundField(formalName="Telephone Number", description="A telephone service number as defined by [ITU-T E.164](https://www.itu.int/rec/T-REC-E.164-201011-I/en).", useName="telephone-number", remarks="A phone number used to contact the party.", maxOccurs=-1, groupAs=@GroupAs(name="telephone-numbers", inJson=JsonGroupAsBehavior.LIST))
        private List<TelephoneNumber> _telephoneNumbers;
        @BoundAssembly(formalName="Address", description="A postal address for the location.", useName="address", maxOccurs=-1, groupAs=@GroupAs(name="addresses", inJson=JsonGroupAsBehavior.LIST))
        private List<Address> _addresses;
        @BoundField(formalName="Location Universally Unique Identifier Reference", description="Reference to a location by UUID.", useName="location-uuid", maxOccurs=-1, groupAs=@GroupAs(name="location-uuids", inJson=JsonGroupAsBehavior.LIST), typeAdapter=UuidAdapter.class, valueConstraints=@ValueConstraints(indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, indexName="index-metadata-location-uuid", keyFields={@KeyField})}))
        private List<UUID> _locationUuids;
        @BoundField(formalName="Organizational Affiliation", description="A reference to another `party` by UUID, typically an organization, that this subject is associated with.", useName="member-of-organization", remarks="Since the reference target of an organizational affiliation must be another `party` (whether further qualified as person or organization) as inidcated by its `uuid`. As a [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier with uniqueness across document and trans-document scope, this `uuid` value is sufficient to reference the data item locally or globally across related documents, e.g., in an imported OSCAL instance.\n\nParties of both the `person` or `organization` type can be associated with an organization using the `member-of-organization`.", maxOccurs=-1, groupAs=@GroupAs(name="member-of-organizations", inJson=JsonGroupAsBehavior.LIST), typeAdapter=UuidAdapter.class, valueConstraints=@ValueConstraints(indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, indexName="index-metadata-party-organizations-uuid", keyFields={@KeyField})}))
        private List<UUID> _memberOfOrganizations;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Party() {
            this(null);
        }

        public Party(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String value) {
            this._type = value;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String value) {
            this._name = value;
        }

        public String getShortName() {
            return this._shortName;
        }

        public void setShortName(String value) {
            this._shortName = value;
        }

        public List<ExternalId> getExternalIds() {
            return this._externalIds;
        }

        public void setExternalIds(List<ExternalId> value) {
            this._externalIds = value;
        }

        public boolean addExternalId(ExternalId item) {
            ExternalId value = (ExternalId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._externalIds == null) {
                this._externalIds = new LinkedList<ExternalId>();
            }
            return this._externalIds.add(value);
        }

        public boolean removeExternalId(ExternalId item) {
            ExternalId value = (ExternalId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._externalIds != null && this._externalIds.remove(value);
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<String> getEmailAddresses() {
            return this._emailAddresses;
        }

        public void setEmailAddresses(List<String> value) {
            this._emailAddresses = value;
        }

        public boolean addEmailAddress(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._emailAddresses == null) {
                this._emailAddresses = new LinkedList<String>();
            }
            return this._emailAddresses.add(value);
        }

        public boolean removeEmailAddress(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._emailAddresses != null && this._emailAddresses.remove(value);
        }

        public List<TelephoneNumber> getTelephoneNumbers() {
            return this._telephoneNumbers;
        }

        public void setTelephoneNumbers(List<TelephoneNumber> value) {
            this._telephoneNumbers = value;
        }

        public boolean addTelephoneNumber(TelephoneNumber item) {
            TelephoneNumber value = (TelephoneNumber)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._telephoneNumbers == null) {
                this._telephoneNumbers = new LinkedList<TelephoneNumber>();
            }
            return this._telephoneNumbers.add(value);
        }

        public boolean removeTelephoneNumber(TelephoneNumber item) {
            TelephoneNumber value = (TelephoneNumber)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._telephoneNumbers != null && this._telephoneNumbers.remove(value);
        }

        public List<Address> getAddresses() {
            return this._addresses;
        }

        public void setAddresses(List<Address> value) {
            this._addresses = value;
        }

        public boolean addAddress(Address item) {
            Address value = (Address)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._addresses == null) {
                this._addresses = new LinkedList<Address>();
            }
            return this._addresses.add(value);
        }

        public boolean removeAddress(Address item) {
            Address value = (Address)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._addresses != null && this._addresses.remove(value);
        }

        public List<UUID> getLocationUuids() {
            return this._locationUuids;
        }

        public void setLocationUuids(List<UUID> value) {
            this._locationUuids = value;
        }

        public boolean addLocationUuid(UUID item) {
            UUID value = (UUID)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._locationUuids == null) {
                this._locationUuids = new LinkedList<UUID>();
            }
            return this._locationUuids.add(value);
        }

        public boolean removeLocationUuid(UUID item) {
            UUID value = (UUID)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._locationUuids != null && this._locationUuids.remove(value);
        }

        public List<UUID> getMemberOfOrganizations() {
            return this._memberOfOrganizations;
        }

        public void setMemberOfOrganizations(List<UUID> value) {
            this._memberOfOrganizations = value;
        }

        public boolean addMemberOfOrganization(UUID item) {
            UUID value = (UUID)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._memberOfOrganizations == null) {
                this._memberOfOrganizations = new LinkedList<UUID>();
            }
            return this._memberOfOrganizations.add(value);
        }

        public boolean removeMemberOfOrganization(UUID item) {
            UUID value = (UUID)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._memberOfOrganizations != null && this._memberOfOrganizations.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaField(formalName="Party External Identifier", description="An identifier for a person or organization using a designated scheme. e.g. an Open Researcher and Contributor ID (ORCID).", name="external-id", moduleClass=OscalMetadataModule.class)
        public static class ExternalId
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="External Identifier Schema", description="Indicates the type of external identifier.", name="scheme", required=true, typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="http://orcid.org/", description="The identifier is Open Researcher and Contributor ID (ORCID).")})}))
            private URI _scheme;
            @BoundFieldValue(valueKeyName="id")
            private String _id;

            public ExternalId() {
                this(null);
            }

            public ExternalId(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public URI getScheme() {
                return this._scheme;
            }

            public void setScheme(URI value) {
                this._scheme = value;
            }

            public String getId() {
                return this._id;
            }

            public void setId(String value) {
                this._id = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

