/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.ParameterConstraint;
import gov.nist.secauto.oscal.lib.model.ParameterGuideline;
import gov.nist.secauto.oscal.lib.model.ParameterSelection;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Modify Controls", description="Set parameters or amend controls in resolution.", name="modify", moduleClass=OscalProfileModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-profile-modify-set-parameter", level=IConstraint.Level.ERROR, target="set-parameter", keyFields={@KeyField(target="@param-id")}, remarks="Since multiple `set-parameter` entries can be provided, each parameter must be set only once.")}))
public class Modify
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Parameter Setting", description="A parameter setting, to be propagated to points of insertion.", useName="set-parameter", maxOccurs=-1, groupAs=@GroupAs(name="set-parameters", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileSetParameter> _setParameters;
    @BoundAssembly(formalName="Alteration", description="Specifies changes to be made to an included control when a profile is resolved.", useName="alter", remarks="Use `@control-id` to indicate the scope of alteration.\n\nIt is an error for two `alter` elements to apply to the same control. In practice, multiple alterations can be applied (together), but it creates confusion.\n\nAt present, no provision is made for altering many controls at once (for example, to systematically remove properties or add global properties); extending this element to match multiple control IDs could provide for this.", maxOccurs=-1, groupAs=@GroupAs(name="alters", inJson=JsonGroupAsBehavior.LIST))
    private List<Alter> _alters;

    public Modify() {
        this(null);
    }

    public Modify(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<ProfileSetParameter> getSetParameters() {
        return this._setParameters;
    }

    public void setSetParameters(List<ProfileSetParameter> value) {
        this._setParameters = value;
    }

    public boolean addSetParameter(ProfileSetParameter item) {
        ProfileSetParameter value = (ProfileSetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._setParameters == null) {
            this._setParameters = new LinkedList<ProfileSetParameter>();
        }
        return this._setParameters.add(value);
    }

    public boolean removeSetParameter(ProfileSetParameter item) {
        ProfileSetParameter value = (ProfileSetParameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._setParameters != null && this._setParameters.remove(value);
    }

    public List<Alter> getAlters() {
        return this._alters;
    }

    public void setAlters(List<Alter> value) {
        this._alters = value;
    }

    public boolean addAlter(Alter item) {
        Alter value = (Alter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._alters == null) {
            this._alters = new LinkedList<Alter>();
        }
        return this._alters.add(value);
    }

    public boolean removeAlter(Alter item) {
        Alter value = (Alter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._alters != null && this._alters.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Parameter Setting", description="A parameter setting, to be propagated to points of insertion.", name="set-parameter", moduleClass=OscalProfileModule.class)
    public static class ProfileSetParameter
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Parameter ID", description="An identifier for the parameter.", name="param-id", required=true, typeAdapter=TokenAdapter.class)
        private String _paramId;
        @BoundFlag(formalName="Parameter Class", description="A textual label that provides a characterization of the parameter.", name="class", typeAdapter=TokenAdapter.class, remarks="A `class` can be used in validation rules to express extra constraints over named items of a specific `class` value.")
        private String _clazz;
        @BoundFlag(formalName="Depends On", description="\\*\\*(deprecated)\\*\\* Another parameter invoking this one. This construct has been deprecated and should not be used.", name="depends-on", typeAdapter=TokenAdapter.class)
        private String _dependsOn;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Parameter Label", description="A short, placeholder name for the parameter, which can be used as a substitute for a `value` if no value is assigned.", useName="label", remarks="The label value should be suitable for inline display in a rendered catalog.", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _label;
        @BoundField(formalName="Parameter Usage Description", description="Describes the purpose and use of a parameter.", useName="usage", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _usage;
        @BoundAssembly(formalName="Constraint", description="A formal or informal expression of a constraint or test.", useName="constraint", maxOccurs=-1, groupAs=@GroupAs(name="constraints", inJson=JsonGroupAsBehavior.LIST))
        private List<ParameterConstraint> _constraints;
        @BoundAssembly(formalName="Guideline", description="A prose statement that provides a recommendation for the use of a parameter.", useName="guideline", maxOccurs=-1, groupAs=@GroupAs(name="guidelines", inJson=JsonGroupAsBehavior.LIST))
        private List<ParameterGuideline> _guidelines;
        @BoundField(formalName="Parameter Value", description="A parameter value or set of values.", useName="value", remarks="Used to (re)define a parameter value.", maxOccurs=-1, groupAs=@GroupAs(name="values", inJson=JsonGroupAsBehavior.LIST))
        private List<String> _values;
        @BoundAssembly(formalName="Selection", description="Presenting a choice among alternatives.", useName="select")
        private ParameterSelection _select;

        public ProfileSetParameter() {
            this(null);
        }

        public ProfileSetParameter(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getParamId() {
            return this._paramId;
        }

        public void setParamId(String value) {
            this._paramId = value;
        }

        public String getClazz() {
            return this._clazz;
        }

        public void setClazz(String value) {
            this._clazz = value;
        }

        public String getDependsOn() {
            return this._dependsOn;
        }

        public void setDependsOn(String value) {
            this._dependsOn = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupLine getLabel() {
            return this._label;
        }

        public void setLabel(MarkupLine value) {
            this._label = value;
        }

        public MarkupMultiline getUsage() {
            return this._usage;
        }

        public void setUsage(MarkupMultiline value) {
            this._usage = value;
        }

        public List<ParameterConstraint> getConstraints() {
            return this._constraints;
        }

        public void setConstraints(List<ParameterConstraint> value) {
            this._constraints = value;
        }

        public boolean addConstraint(ParameterConstraint item) {
            ParameterConstraint value = (ParameterConstraint)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._constraints == null) {
                this._constraints = new LinkedList<ParameterConstraint>();
            }
            return this._constraints.add(value);
        }

        public boolean removeConstraint(ParameterConstraint item) {
            ParameterConstraint value = (ParameterConstraint)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._constraints != null && this._constraints.remove(value);
        }

        public List<ParameterGuideline> getGuidelines() {
            return this._guidelines;
        }

        public void setGuidelines(List<ParameterGuideline> value) {
            this._guidelines = value;
        }

        public boolean addGuideline(ParameterGuideline item) {
            ParameterGuideline value = (ParameterGuideline)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._guidelines == null) {
                this._guidelines = new LinkedList<ParameterGuideline>();
            }
            return this._guidelines.add(value);
        }

        public boolean removeGuideline(ParameterGuideline item) {
            ParameterGuideline value = (ParameterGuideline)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._guidelines != null && this._guidelines.remove(value);
        }

        public List<String> getValues() {
            return this._values;
        }

        public void setValues(List<String> value) {
            this._values = value;
        }

        public boolean addValue(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._values == null) {
                this._values = new LinkedList<String>();
            }
            return this._values.add(value);
        }

        public boolean removeValue(String item) {
            String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._values != null && this._values.remove(value);
        }

        public ParameterSelection getSelect() {
            return this._select;
        }

        public void setSelect(ParameterSelection value) {
            this._select = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Alteration", description="Specifies changes to be made to an included control when a profile is resolved.", name="alter", moduleClass=OscalProfileModule.class, remarks="Use `@control-id` to indicate the scope of alteration.\n\nIt is an error for two `alter` elements to apply to the same control. In practice, multiple alterations can be applied (together), but it creates confusion.\n\nAt present, no provision is made for altering many controls at once (for example, to systematically remove properties or add global properties); extending this element to match multiple control IDs could provide for this.")
    public static class Alter
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Control Identifier Reference", description="A reference to a control with a corresponding `id` value. When referencing an externally defined `control`, the `Control Identifier Reference` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference).", name="control-id", required=true, typeAdapter=TokenAdapter.class)
        private String _controlId;
        @BoundAssembly(formalName="Removal", description="Specifies objects to be removed from a control based on specific aspects of the object that must all match.", useName="remove", remarks="Use `by-name`, `by-class`, `by-id` or `by-item-name` to indicate class tokens or ID reference, or the formal name, of the component to be removed or erased from a control, when a catalog is resolved. The control affected is indicated by the pointer on the removal's parent (containing) `alter` element.\n\nTo change an element, use `remove` to remove the element, then `add` to add it back again with changes.", maxOccurs=-1, groupAs=@GroupAs(name="removes", inJson=JsonGroupAsBehavior.LIST))
        private List<Remove> _removes;
        @BoundAssembly(formalName="Addition", description="Specifies contents to be added into controls, in resolution.", useName="add", remarks="When no `by-id` is given, the addition is inserted into the control targeted by the alteration at the start or end as indicated by `position`. Only `position` values of \"starting\" or \"ending\" are permitted when there is no `by-id`.\n\n`by-id`, when given, should indicate, by its ID, an element inside the control to serve as the anchor point for the addition. In this case, `position` value may be any of the permitted values.", maxOccurs=-1, groupAs=@GroupAs(name="adds", inJson=JsonGroupAsBehavior.LIST))
        private List<Add> _adds;

        public Alter() {
            this(null);
        }

        public Alter(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getControlId() {
            return this._controlId;
        }

        public void setControlId(String value) {
            this._controlId = value;
        }

        public List<Remove> getRemoves() {
            return this._removes;
        }

        public void setRemoves(List<Remove> value) {
            this._removes = value;
        }

        public boolean addRemove(Remove item) {
            Remove value = (Remove)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._removes == null) {
                this._removes = new LinkedList<Remove>();
            }
            return this._removes.add(value);
        }

        public boolean removeRemove(Remove item) {
            Remove value = (Remove)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._removes != null && this._removes.remove(value);
        }

        public List<Add> getAdds() {
            return this._adds;
        }

        public void setAdds(List<Add> value) {
            this._adds = value;
        }

        public boolean addAdd(Add item) {
            Add value = (Add)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._adds == null) {
                this._adds = new LinkedList<Add>();
            }
            return this._adds.add(value);
        }

        public boolean removeAdd(Add item) {
            Add value = (Add)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._adds != null && this._adds.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Removal", description="Specifies objects to be removed from a control based on specific aspects of the object that must all match.", name="remove", moduleClass=OscalProfileModule.class, remarks="Use `by-name`, `by-class`, `by-id` or `by-item-name` to indicate class tokens or ID reference, or the formal name, of the component to be removed or erased from a control, when a catalog is resolved. The control affected is indicated by the pointer on the removal's parent (containing) `alter` element.\n\nTo change an element, use `remove` to remove the element, then `add` to add it back again with changes.")
        public static class Remove
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Reference by (assigned) name", description="Identify items remove by matching their assigned name.", name="by-name", typeAdapter=TokenAdapter.class)
            private String _byName;
            @BoundFlag(formalName="Reference by class", description="Identify items to remove by matching their `class`.", name="by-class", typeAdapter=TokenAdapter.class)
            private String _byClass;
            @BoundFlag(formalName="Reference by ID", description="Identify items to remove indicated by their `id`.", name="by-id", typeAdapter=TokenAdapter.class)
            private String _byId;
            @BoundFlag(formalName="Item Name Reference", description="Identify items to remove by the name of the item's information object name, e.g. `title` or `prop`.", name="by-item-name", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="param", description="A descendant parameter and all of its descendants."), @AllowedValue(value="prop", description="A descendant property and all of its descendants."), @AllowedValue(value="link", description="A descendant link and all of its descendants."), @AllowedValue(value="part", description="A descendant parameter and all of its descendants."), @AllowedValue(value="mapping", description="A descendant mapping and all of its descendants."), @AllowedValue(value="map", description="A descendant mapping entry (map) and all of its descendants.")})}))
            private String _byItemName;
            @BoundFlag(formalName="Item Namespace Reference", description="Identify items to remove by the item's `ns`, which is the namespace associated with a `part`, or `prop`.", name="by-ns", typeAdapter=TokenAdapter.class)
            private String _byNs;

            public Remove() {
                this(null);
            }

            public Remove(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public String getByName() {
                return this._byName;
            }

            public void setByName(String value) {
                this._byName = value;
            }

            public String getByClass() {
                return this._byClass;
            }

            public void setByClass(String value) {
                this._byClass = value;
            }

            public String getById() {
                return this._byId;
            }

            public void setById(String value) {
                this._byId = value;
            }

            public String getByItemName() {
                return this._byItemName;
            }

            public void setByItemName(String value) {
                this._byItemName = value;
            }

            public String getByNs() {
                return this._byNs;
            }

            public void setByNs(String value) {
                this._byNs = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaAssembly(formalName="Addition", description="Specifies contents to be added into controls, in resolution.", name="add", moduleClass=OscalProfileModule.class, remarks="When no `by-id` is given, the addition is inserted into the control targeted by the alteration at the start or end as indicated by `position`. Only `position` values of \"starting\" or \"ending\" are permitted when there is no `by-id`.\n\n`by-id`, when given, should indicate, by its ID, an element inside the control to serve as the anchor point for the addition. In this case, `position` value may be any of the permitted values.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="label", description="A human-readable label for the parent context, which may be rendered in place of the actual identifier for some use cases."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="alt-identifier", description="An alternate or aliased identifier for the parent context.")})}))
        public static class Add
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Position", description="Where to add the new content with respect to the targeted element (beside it or inside it).", name="position", defaultValue="ending", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="before", description="Preceding the by-id target"), @AllowedValue(value="after", description="Following the by-id target"), @AllowedValue(value="starting", description="Inside the control or by-id target, at the start"), @AllowedValue(value="ending", description="Inside the control or by-id target, at the end")})}))
            private String _position;
            @BoundFlag(formalName="Reference by ID", description="Target location of the addition.", name="by-id", typeAdapter=TokenAdapter.class)
            private String _byId;
            @BoundField(formalName="Title Change", description="A name given to the control, which may be used by a tool for display and navigation.", useName="title", typeAdapter=MarkupLineAdapter.class)
            private MarkupLine _title;
            @BoundAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", useName="param", maxOccurs=-1, groupAs=@GroupAs(name="params", inJson=JsonGroupAsBehavior.LIST))
            private List<Parameter> _params;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Part", description="An annotated, markup-based textual element of a control's or catalog group's definition, or a child of another part.", useName="part", maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
            private List<ControlPart> _parts;

            public Add() {
                this(null);
            }

            public Add(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public String getPosition() {
                return this._position;
            }

            public void setPosition(String value) {
                this._position = value;
            }

            public String getById() {
                return this._byId;
            }

            public void setById(String value) {
                this._byId = value;
            }

            public MarkupLine getTitle() {
                return this._title;
            }

            public void setTitle(MarkupLine value) {
                this._title = value;
            }

            public List<Parameter> getParams() {
                return this._params;
            }

            public void setParams(List<Parameter> value) {
                this._params = value;
            }

            public boolean addParam(Parameter item) {
                Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._params == null) {
                    this._params = new LinkedList<Parameter>();
                }
                return this._params.add(value);
            }

            public boolean removeParam(Parameter item) {
                Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._params != null && this._params.remove(value);
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<ControlPart> getParts() {
                return this._parts;
            }

            public void setParts(List<ControlPart> value) {
                this._parts = value;
            }

            public boolean addPart(ControlPart item) {
                ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._parts == null) {
                    this._parts = new LinkedList<ControlPart>();
                }
                return this._parts.add(value);
            }

            public boolean removePart(ControlPart item) {
                ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._parts != null && this._parts.remove(value);
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

