/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Origin;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SubjectReference;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Observation", description="Describes an individual observation.", name="observation", moduleClass=OscalAssessmentCommonModule.class)
public class Observation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Observation Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with *cross-instance* scope that can be used to reference this observation elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `observation` can be used to reference the data item locally or globally (e.g., in an imorted OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Observation Title", description="The title for this observation.", useName="title", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Observation Description", description="A human-readable description of this assessment observation.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundField(formalName="Observation Method", description="Identifies how the observation was made.", useName="method", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="methods", inJson=JsonGroupAsBehavior.LIST), valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="EXAMINE", description="An inspection was performed."), @AllowedValue(value="INTERVIEW", description="An interview was performed."), @AllowedValue(value="TEST", description="A manual or automated test was performed."), @AllowedValue(value="UNKNOWN", description="This is only for use when converting historic content to OSCAL, where the conversion process cannot initially identify the appropriate method(s).")})}))
    private List<String> _methods;
    @BoundField(formalName="Observation Type", description="Identifies the nature of the observation. More than one may be used to further qualify and enable filtering.", useName="type", maxOccurs=-1, groupAs=@GroupAs(name="types", inJson=JsonGroupAsBehavior.LIST), typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="ssp-statement-issue", description="A difference between the SSP implementation statement, and actual implementation."), @AllowedValue(value="control-objective", description="An observation about the status of a the associated control objective."), @AllowedValue(value="mitigation", description="A mitigating factor was identified."), @AllowedValue(value="finding", description="An assessment finding. Used for observations made by tools, penetration testing, and other means."), @AllowedValue(value="historic", description="An observation from a past assessment, which was converted to OSCAL at a later date.")})}))
    private List<String> _types;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", useName="origin", remarks="Used to identify the individual and/or tool that gathered the evidence resulting in the observation identification.", maxOccurs=-1, groupAs=@GroupAs(name="origins", inJson=JsonGroupAsBehavior.LIST))
    private List<Origin> _origins;
    @BoundAssembly(formalName="Identifies the Subject", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) identifier reference to a resource. Use type to indicate whether the identified resource is a component, inventory item, location, user, or something else.", useName="subject", remarks="Identifies who was interviewed, or what was tested or inspected.", maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<SubjectReference> _subjects;
    @BoundAssembly(formalName="Relevant Evidence", description="Links this observation to relevant evidence.", useName="relevant-evidence", maxOccurs=-1, groupAs=@GroupAs(name="relevant-evidence", inJson=JsonGroupAsBehavior.LIST))
    private List<RelevantEvidence> _relevantEvidence;
    @BoundField(formalName="Collected Field", description="Date/time stamp identifying when the finding information was collected.", useName="collected", minOccurs=1, typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _collected;
    @BoundField(formalName="Expires Field", description="Date/time identifying when the finding information is out-of-date and no longer valid. Typically used with continuous assessment scenarios.", useName="expires", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _expires;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Observation() {
        this(null);
    }

    public Observation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<String> getMethods() {
        return this._methods;
    }

    public void setMethods(List<String> value) {
        this._methods = value;
    }

    public boolean addMethod(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._methods == null) {
            this._methods = new LinkedList<String>();
        }
        return this._methods.add(value);
    }

    public boolean removeMethod(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._methods != null && this._methods.remove(value);
    }

    public List<String> getTypes() {
        return this._types;
    }

    public void setTypes(List<String> value) {
        this._types = value;
    }

    public boolean addType(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._types == null) {
            this._types = new LinkedList<String>();
        }
        return this._types.add(value);
    }

    public boolean removeType(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._types != null && this._types.remove(value);
    }

    public List<Origin> getOrigins() {
        return this._origins;
    }

    public void setOrigins(List<Origin> value) {
        this._origins = value;
    }

    public boolean addOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._origins == null) {
            this._origins = new LinkedList<Origin>();
        }
        return this._origins.add(value);
    }

    public boolean removeOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._origins != null && this._origins.remove(value);
    }

    public List<SubjectReference> getSubjects() {
        return this._subjects;
    }

    public void setSubjects(List<SubjectReference> value) {
        this._subjects = value;
    }

    public boolean addSubject(SubjectReference item) {
        SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._subjects == null) {
            this._subjects = new LinkedList<SubjectReference>();
        }
        return this._subjects.add(value);
    }

    public boolean removeSubject(SubjectReference item) {
        SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._subjects != null && this._subjects.remove(value);
    }

    public List<RelevantEvidence> getRelevantEvidence() {
        return this._relevantEvidence;
    }

    public void setRelevantEvidence(List<RelevantEvidence> value) {
        this._relevantEvidence = value;
    }

    public boolean addRelevantEvidence(RelevantEvidence item) {
        RelevantEvidence value = (RelevantEvidence)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relevantEvidence == null) {
            this._relevantEvidence = new LinkedList<RelevantEvidence>();
        }
        return this._relevantEvidence.add(value);
    }

    public boolean removeRelevantEvidence(RelevantEvidence item) {
        RelevantEvidence value = (RelevantEvidence)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relevantEvidence != null && this._relevantEvidence.remove(value);
    }

    public ZonedDateTime getCollected() {
        return this._collected;
    }

    public void setCollected(ZonedDateTime value) {
        this._collected = value;
    }

    public ZonedDateTime getExpires() {
        return this._expires;
    }

    public void setExpires(ZonedDateTime value) {
        this._expires = value;
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Relevant Evidence", description="Links this observation to relevant evidence.", name="relevant-evidence", moduleClass=OscalAssessmentCommonModule.class)
    public static class RelevantEvidence
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Relevant Evidence Reference", description="A resolvable URL reference to relevant evidence.", name="href", typeAdapter=UriReferenceAdapter.class, remarks="This value may be one of:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or\n3. a bare URI fragment (i.e., \\`#uuid\\`) pointing to a `back-matter` resource in this or an imported document (see [linking to another OSCAL object](https://pages.nist.gov/OSCAL/concepts/uri-use/#linking-to-another-oscal-object)).")
        private URI _href;
        @BoundField(formalName="Relevant Evidence Description", description="A human-readable description of this evidence.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public RelevantEvidence() {
            this(null);
        }

        public RelevantEvidence(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public URI getHref() {
            return this._href;
        }

        public void setHref(URI value) {
            this._href = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

