/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OriginActor;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.RelatedTask;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", name="origin", moduleClass=OscalAssessmentCommonModule.class)
public class Origin
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Originating Actor", description="The actor that produces an observation, a finding, or a risk. One or more actor type can be used to specify a person that is using a tool.", useName="actor", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="actors", inJson=JsonGroupAsBehavior.LIST))
    private List<OriginActor> _actors;
    @BoundAssembly(formalName="Task Reference", description="Identifies an individual task for which the containing object is a consequence of.", useName="related-task", maxOccurs=-1, groupAs=@GroupAs(name="related-tasks", inJson=JsonGroupAsBehavior.LIST))
    private List<RelatedTask> _relatedTasks;

    public Origin() {
        this(null);
    }

    public Origin(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<OriginActor> getActors() {
        return this._actors;
    }

    public void setActors(List<OriginActor> value) {
        this._actors = value;
    }

    public boolean addActor(OriginActor item) {
        OriginActor value = (OriginActor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._actors == null) {
            this._actors = new LinkedList<OriginActor>();
        }
        return this._actors.add(value);
    }

    public boolean removeActor(OriginActor item) {
        OriginActor value = (OriginActor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._actors != null && this._actors.remove(value);
    }

    public List<RelatedTask> getRelatedTasks() {
        return this._relatedTasks;
    }

    public void setRelatedTasks(List<RelatedTask> value) {
        this._relatedTasks = value;
    }

    public boolean addRelatedTask(RelatedTask item) {
        RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedTasks == null) {
            this._relatedTasks = new LinkedList<RelatedTask>();
        }
        return this._relatedTasks.add(value);
    }

    public boolean removeRelatedTask(RelatedTask item) {
        RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedTasks != null && this._relatedTasks.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

