/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Originating Actor", description="The actor that produces an observation, a finding, or a risk. One or more actor type can be used to specify a person that is using a tool.", name="origin-actor", moduleClass=OscalAssessmentCommonModule.class)
public class OriginActor
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Actor Type", description="The kind of actor.", name="type", required=true, typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="tool", description="A reference to a tool component defined with the assessment assets."), @AllowedValue(value="assessment-platform", description="A reference to an assessment-platform defined with the assessment assets."), @AllowedValue(value="party", description="A reference to a party defined within the document metadata.")})}))
    private String _type;
    @BoundFlag(formalName="Actor Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to the tool or person based on the associated type.", name="actor-uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _actorUuid;
    @BoundFlag(formalName="Actor Role", description="For a party, this can optionally be used to specify the role the actor was performing.", name="role-id", typeAdapter=TokenAdapter.class)
    private String _roleId;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;

    public OriginActor() {
        this(null);
    }

    public OriginActor(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public UUID getActorUuid() {
        return this._actorUuid;
    }

    public void setActorUuid(UUID value) {
        this._actorUuid = value;
    }

    public String getRoleId() {
        return this._roleId;
    }

    public void setRoleId(String value) {
        this._roleId = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

