/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalControlCommonModule;
import gov.nist.secauto.oscal.lib.model.ParameterConstraint;
import gov.nist.secauto.oscal.lib.model.ParameterGuideline;
import gov.nist.secauto.oscal.lib.model.ParameterSelection;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.AbstractParameter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", name="parameter", moduleClass=OscalControlCommonModule.class, remarks="In a catalog, a parameter is typically used as a placeholder for the future assignment of a parameter value, although the OSCAL model allows for the direct assignment of a value if desired by the control author. The `value` may be optionally used to specify one or more values. If no value is provided, then it is expected that the value will be provided at the Profile or Implementation layer.\n\nA parameter can include a variety of metadata options that support the future solicitation of one or more values. A `label` provides a textual placeholder that can be used in a tool to solicit parameter value input, or to display in catalog documentation. The `desc` provides a short description of what the parameter is used for, which can be used in tooling to help a user understand how to use the parameter. A `constraint` can be used to provide criteria for the allowed values. A `guideline` provides a recommendation for the use of a parameter.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="label", description="A human-readable label for the parent context, which may be rendered in place of the actual identifier for some use cases."), @AllowedValue(value="sort-id", description="An alternative identifier, whose value is easily sortable among other such values in the document."), @AllowedValue(value="alt-identifier", description="An alternate or aliased identifier for the parent context."), @AllowedValue(value="alt-label", description="An alternate to the value provided by the parameter's label. This will typically be qualified by a class.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/rmf')]/@name", values={@AllowedValue(value="aggregates", description="The parent parameter provides an aggregation of two or more other parameters, each described by this property.")})}, expect={@Expect(level=IConstraint.Level.ERROR, test="not(exists(@depends-on))", message="depends-on is deprecated")}))
public class Parameter
extends AbstractParameter
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Parameter Identifier", description="A unique identifier for the parameter.", name="id", required=true, typeAdapter=TokenAdapter.class)
    private String _id;
    @BoundFlag(formalName="Parameter Class", description="A textual label that provides a characterization of the type, purpose, use or scope of the parameter.", name="class", typeAdapter=TokenAdapter.class, remarks="A `class` can be used in validation rules to express extra constraints over named items of a specific `class` value.")
    private String _clazz;
    @BoundFlag(formalName="Depends on", description="**(deprecated)** Another parameter invoking this one. This construct has been deprecated and should not be used.", name="depends-on", typeAdapter=TokenAdapter.class)
    private String _dependsOn;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundField(formalName="Parameter Label", description="A short, placeholder name for the parameter, which can be used as a substitute for a `value` if no value is assigned.", useName="label", remarks="The label value is intended use when rendering a parameter in generated documentation or a user interface when a parameter is referenced. Note that labels are not required to be distinctive, which means that parameters within the same control may have the same label.", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _label;
    @BoundField(formalName="Parameter Usage Description", description="Describes the purpose and use of a parameter.", useName="usage", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _usage;
    @BoundAssembly(formalName="Constraint", description="A formal or informal expression of a constraint or test.", useName="constraint", maxOccurs=-1, groupAs=@GroupAs(name="constraints", inJson=JsonGroupAsBehavior.LIST))
    private List<ParameterConstraint> _constraints;
    @BoundAssembly(formalName="Guideline", description="A prose statement that provides a recommendation for the use of a parameter.", useName="guideline", maxOccurs=-1, groupAs=@GroupAs(name="guidelines", inJson=JsonGroupAsBehavior.LIST))
    private List<ParameterGuideline> _guidelines;
    @BoundField(formalName="Parameter Value", description="A parameter value or set of values.", useName="value", remarks="A set of values provided in a catalog can be redefined in OSCAL's `profile` or `system-security-plan` models.", maxOccurs=-1, groupAs=@GroupAs(name="values", inJson=JsonGroupAsBehavior.LIST))
    private List<String> _values;
    @BoundAssembly(formalName="Selection", description="Presenting a choice among alternatives.", useName="select", remarks="The OSCAL parameter `value` construct can be used to prescribe a specific parameter value in a catalog or profile. In cases where a prescriptive value is not possible in a catalog or profile, it may be possible to constrain the set of possible values to a few options. Use of `select` in a parameter instead of `value` is a way of defining value options that **may** be set.\n\nA set of allowed parameter values expressed as a set of options which may be selected. These options constrain the permissible values that may be selected for the containing parameter. When the value assignment is made, such as in an OSCAL profile or system security plan, the actual selected value can be examined to determine if it matches one of the permissible choices for the parameter value.\n\nWhen the value of `how-many` is set to \"one-or-more\", multiple values may be assigned reflecting more than one choice.")
    private ParameterSelection _select;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Parameter() {
        this(null);
    }

    public Parameter(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getClazz() {
        return this._clazz;
    }

    public void setClazz(String value) {
        this._clazz = value;
    }

    public String getDependsOn() {
        return this._dependsOn;
    }

    public void setDependsOn(String value) {
        this._dependsOn = value;
    }

    @Override
    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public MarkupLine getLabel() {
        return this._label;
    }

    public void setLabel(MarkupLine value) {
        this._label = value;
    }

    public MarkupMultiline getUsage() {
        return this._usage;
    }

    public void setUsage(MarkupMultiline value) {
        this._usage = value;
    }

    public List<ParameterConstraint> getConstraints() {
        return this._constraints;
    }

    public void setConstraints(List<ParameterConstraint> value) {
        this._constraints = value;
    }

    public boolean addConstraint(ParameterConstraint item) {
        ParameterConstraint value = (ParameterConstraint)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._constraints == null) {
            this._constraints = new LinkedList<ParameterConstraint>();
        }
        return this._constraints.add(value);
    }

    public boolean removeConstraint(ParameterConstraint item) {
        ParameterConstraint value = (ParameterConstraint)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._constraints != null && this._constraints.remove(value);
    }

    public List<ParameterGuideline> getGuidelines() {
        return this._guidelines;
    }

    public void setGuidelines(List<ParameterGuideline> value) {
        this._guidelines = value;
    }

    public boolean addGuideline(ParameterGuideline item) {
        ParameterGuideline value = (ParameterGuideline)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._guidelines == null) {
            this._guidelines = new LinkedList<ParameterGuideline>();
        }
        return this._guidelines.add(value);
    }

    public boolean removeGuideline(ParameterGuideline item) {
        ParameterGuideline value = (ParameterGuideline)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._guidelines != null && this._guidelines.remove(value);
    }

    public List<String> getValues() {
        return this._values;
    }

    public void setValues(List<String> value) {
        this._values = value;
    }

    public boolean addValue(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._values == null) {
            this._values = new LinkedList<String>();
        }
        return this._values.add(value);
    }

    public boolean removeValue(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._values != null && this._values.remove(value);
    }

    @Override
    public ParameterSelection getSelect() {
        return this._select;
    }

    public void setSelect(ParameterSelection value) {
        this._select = value;
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

