/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalControlCommonModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Constraint", description="A formal or informal expression of a constraint or test.", name="parameter-constraint", moduleClass=OscalControlCommonModule.class)
public class ParameterConstraint
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Constraint Description", description="A textual summary of the constraint to be applied.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Constraint Test", description="A test expression which is expected to be evaluated by a tool.", useName="test", maxOccurs=-1, groupAs=@GroupAs(name="tests", inJson=JsonGroupAsBehavior.LIST))
    private List<Test> _tests;

    public ParameterConstraint() {
        this(null);
    }

    public ParameterConstraint(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Test> getTests() {
        return this._tests;
    }

    public void setTests(List<Test> value) {
        this._tests = value;
    }

    public boolean addTest(Test item) {
        Test value = (Test)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._tests == null) {
            this._tests = new LinkedList<Test>();
        }
        return this._tests.add(value);
    }

    public boolean removeTest(Test item) {
        Test value = (Test)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._tests != null && this._tests.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Constraint Test", description="A test expression which is expected to be evaluated by a tool.", name="test", moduleClass=OscalControlCommonModule.class)
    public static class Test
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundField(formalName="Constraint test", description="A formal (executable) expression of a constraint.", useName="expression", minOccurs=1)
        private String _expression;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Test() {
            this(null);
        }

        public Test(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getExpression() {
            return this._expression;
        }

        public void setExpression(String value) {
            this._expression = value;
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

