/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalControlCommonModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Selection", description="Presenting a choice among alternatives.", name="parameter-selection", moduleClass=OscalControlCommonModule.class, remarks="A set of parameter value choices, that may be picked from to set the parameter value.")
public class ParameterSelection
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Parameter Cardinality", description="Describes the number of selections that must occur. Without this setting, only one value should be assumed to be permitted.", name="how-many", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="one", description="Only one value is permitted."), @AllowedValue(value="one-or-more", description="One or more values are permitted.")})}))
    private String _howMany;
    @BoundField(formalName="Choice", description="A value selection among several such options.", useName="choice", maxOccurs=-1, groupAs=@GroupAs(name="choice", inJson=JsonGroupAsBehavior.LIST), typeAdapter=MarkupLineAdapter.class)
    private List<MarkupLine> _choice;

    public ParameterSelection() {
        this(null);
    }

    public ParameterSelection(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getHowMany() {
        return this._howMany;
    }

    public void setHowMany(String value) {
        this._howMany = value;
    }

    public List<MarkupLine> getChoice() {
        return this._choice;
    }

    public void setChoice(List<MarkupLine> value) {
        this._choice = value;
    }

    public boolean addChoice(MarkupLine item) {
        MarkupLine value = (MarkupLine)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._choice == null) {
            this._choice = new LinkedList<MarkupLine>();
        }
        return this._choice.add(value);
    }

    public boolean removeChoice(MarkupLine item) {
        MarkupLine value = (MarkupLine)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._choice != null && this._choice.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

