/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AbstractOscalInstance;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Finding;
import gov.nist.secauto.oscal.lib.model.ImportSsp;
import gov.nist.secauto.oscal.lib.model.LocalDefinitions;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Observation;
import gov.nist.secauto.oscal.lib.model.OscalPoamModule;
import gov.nist.secauto.oscal.lib.model.PoamItem;
import gov.nist.secauto.oscal.lib.model.Risk;
import gov.nist.secauto.oscal.lib.model.SystemId;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Plan of Action and Milestones (POA&M)", description="A plan of action and milestones which identifies initial and residual risks, deviations, and disposition, such as those required by FedRAMP.", name="plan-of-action-and-milestones", moduleClass=OscalPoamModule.class, rootName="plan-of-action-and-milestones", remarks="Either an OSCAL-based SSP must be imported, or a unique system-id must be specified. Both may be present.")
public class PlanOfActionAndMilestones
extends AbstractOscalInstance
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="POA&M Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#instance)scope that can be used to reference this POA\\&M instance in [this OSCAL instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#poam-identifiers). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import System Security Plan", description="Used by the assessment plan and POA\\&M to import information about the system.", useName="import-ssp", remarks="Used by the POA\\&M to import information about the system.")
    private ImportSsp _importSsp;
    @BoundField(formalName="System Identification", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this system identification property elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). When referencing an externally defined `system identification`, the `system identification` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference). This string should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same system across revisions of the document.", useName="system-id")
    private SystemId _systemId;
    @BoundAssembly(formalName="Local Definitions", description="Allows components, and inventory-items to be defined within the POA\\&M for circumstances where no OSCAL-based SSP exists, or is not delivered with the POA\\&M.", useName="local-definitions")
    private LocalDefinitions _localDefinitions;
    @BoundAssembly(formalName="Observation", description="Describes an individual observation.", useName="observation", maxOccurs=-1, groupAs=@GroupAs(name="observations", inJson=JsonGroupAsBehavior.LIST))
    private List<Observation> _observations;
    @BoundAssembly(formalName="Identified Risk", description="An identified risk.", useName="risk", maxOccurs=-1, groupAs=@GroupAs(name="risks", inJson=JsonGroupAsBehavior.LIST))
    private List<Risk> _risks;
    @BoundAssembly(formalName="Finding", description="Describes an individual finding.", useName="finding", maxOccurs=-1, groupAs=@GroupAs(name="findings", inJson=JsonGroupAsBehavior.LIST))
    private List<Finding> _findings;
    @BoundAssembly(formalName="POA&M Item", description="Describes an individual POA\\&M item.", useName="poam-item", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="poam-items", inJson=JsonGroupAsBehavior.LIST))
    private List<PoamItem> _poamItems;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public PlanOfActionAndMilestones() {
        this(null);
    }

    public PlanOfActionAndMilestones(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public ImportSsp getImportSsp() {
        return this._importSsp;
    }

    public void setImportSsp(ImportSsp value) {
        this._importSsp = value;
    }

    public SystemId getSystemId() {
        return this._systemId;
    }

    public void setSystemId(SystemId value) {
        this._systemId = value;
    }

    public LocalDefinitions getLocalDefinitions() {
        return this._localDefinitions;
    }

    public void setLocalDefinitions(LocalDefinitions value) {
        this._localDefinitions = value;
    }

    public List<Observation> getObservations() {
        return this._observations;
    }

    public void setObservations(List<Observation> value) {
        this._observations = value;
    }

    public boolean addObservation(Observation item) {
        Observation value = (Observation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._observations == null) {
            this._observations = new LinkedList<Observation>();
        }
        return this._observations.add(value);
    }

    public boolean removeObservation(Observation item) {
        Observation value = (Observation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._observations != null && this._observations.remove(value);
    }

    public List<Risk> getRisks() {
        return this._risks;
    }

    public void setRisks(List<Risk> value) {
        this._risks = value;
    }

    public boolean addRisk(Risk item) {
        Risk value = (Risk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._risks == null) {
            this._risks = new LinkedList<Risk>();
        }
        return this._risks.add(value);
    }

    public boolean removeRisk(Risk item) {
        Risk value = (Risk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._risks != null && this._risks.remove(value);
    }

    public List<Finding> getFindings() {
        return this._findings;
    }

    public void setFindings(List<Finding> value) {
        this._findings = value;
    }

    public boolean addFinding(Finding item) {
        Finding value = (Finding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._findings == null) {
            this._findings = new LinkedList<Finding>();
        }
        return this._findings.add(value);
    }

    public boolean removeFinding(Finding item) {
        Finding value = (Finding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._findings != null && this._findings.remove(value);
    }

    public List<PoamItem> getPoamItems() {
        return this._poamItems;
    }

    public void setPoamItems(List<PoamItem> value) {
        this._poamItems = value;
    }

    public boolean addPoamItem(PoamItem item) {
        PoamItem value = (PoamItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._poamItems == null) {
            this._poamItems = new LinkedList<PoamItem>();
        }
        return this._poamItems.add(value);
    }

    public boolean removePoamItem(PoamItem item) {
        PoamItem value = (PoamItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._poamItems != null && this._poamItems.remove(value);
    }

    @Override
    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

