/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OriginActor;
import gov.nist.secauto.oscal.lib.model.OscalPoamModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="POA&M Item", description="Describes an individual POA\\&M item.", name="poam-item", moduleClass=OscalPoamModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.WARNING, test="@uuid", message="It is a best practice to provide a UUID.")}))
public class PoamItem
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="POA&M Item Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#instance) scope that can be used to reference this POA\\&M item entry in [this OSCAL instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#poam-identifiers). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="POA&M Item Title", description="The title or name for this POA\\&M item .", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="POA&M Item Description", description="A human-readable description of POA\\&M item.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool or person.", useName="origin", remarks="Used to identify the individual and/or tool generated this poam-item.", maxOccurs=-1, groupAs=@GroupAs(name="origins", inJson=JsonGroupAsBehavior.LIST))
    private List<Origin> _origins;
    @BoundAssembly(formalName="Related Finding", description="Relates the poam-item to referenced finding(s).", useName="related-finding", maxOccurs=-1, groupAs=@GroupAs(name="related-findings", inJson=JsonGroupAsBehavior.LIST))
    private List<RelatedFinding> _relatedFindings;
    @BoundAssembly(formalName="Related Observation", description="Relates the poam-item to a set of referenced observations that were used to determine the finding.", useName="related-observation", maxOccurs=-1, groupAs=@GroupAs(name="related-observations", inJson=JsonGroupAsBehavior.LIST))
    private List<RelatedObservation> _relatedObservations;
    @BoundAssembly(formalName="Associated Risk", description="Relates the finding to a set of referenced risks that were used to determine the finding.", useName="associated-risk", maxOccurs=-1, groupAs=@GroupAs(name="related-risks", inJson=JsonGroupAsBehavior.LIST))
    private List<AssociatedRisk> _relatedRisks;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public PoamItem() {
        this(null);
    }

    public PoamItem(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<Origin> getOrigins() {
        return this._origins;
    }

    public void setOrigins(List<Origin> value) {
        this._origins = value;
    }

    public boolean addOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._origins == null) {
            this._origins = new LinkedList<Origin>();
        }
        return this._origins.add(value);
    }

    public boolean removeOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._origins != null && this._origins.remove(value);
    }

    public List<RelatedFinding> getRelatedFindings() {
        return this._relatedFindings;
    }

    public void setRelatedFindings(List<RelatedFinding> value) {
        this._relatedFindings = value;
    }

    public boolean addRelatedFinding(RelatedFinding item) {
        RelatedFinding value = (RelatedFinding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedFindings == null) {
            this._relatedFindings = new LinkedList<RelatedFinding>();
        }
        return this._relatedFindings.add(value);
    }

    public boolean removeRelatedFinding(RelatedFinding item) {
        RelatedFinding value = (RelatedFinding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedFindings != null && this._relatedFindings.remove(value);
    }

    public List<RelatedObservation> getRelatedObservations() {
        return this._relatedObservations;
    }

    public void setRelatedObservations(List<RelatedObservation> value) {
        this._relatedObservations = value;
    }

    public boolean addRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedObservations == null) {
            this._relatedObservations = new LinkedList<RelatedObservation>();
        }
        return this._relatedObservations.add(value);
    }

    public boolean removeRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedObservations != null && this._relatedObservations.remove(value);
    }

    public List<AssociatedRisk> getRelatedRisks() {
        return this._relatedRisks;
    }

    public void setRelatedRisks(List<AssociatedRisk> value) {
        this._relatedRisks = value;
    }

    public boolean addAssociatedRisk(AssociatedRisk item) {
        AssociatedRisk value = (AssociatedRisk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedRisks == null) {
            this._relatedRisks = new LinkedList<AssociatedRisk>();
        }
        return this._relatedRisks.add(value);
    }

    public boolean removeAssociatedRisk(AssociatedRisk item) {
        AssociatedRisk value = (AssociatedRisk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedRisks != null && this._relatedRisks.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool or person.", name="origin", moduleClass=OscalPoamModule.class, remarks="Used to identify the individual and/or tool generated this poam-item.")
    public static class Origin
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Originating Actor", description="The actor that produces an observation, a finding, or a risk. One or more actor type can be used to specify a person that is using a tool.", useName="actor", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="actors", inJson=JsonGroupAsBehavior.LIST))
        private List<OriginActor> _actors;

        public Origin() {
            this(null);
        }

        public Origin(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<OriginActor> getActors() {
            return this._actors;
        }

        public void setActors(List<OriginActor> value) {
            this._actors = value;
        }

        public boolean addActor(OriginActor item) {
            OriginActor value = (OriginActor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._actors == null) {
                this._actors = new LinkedList<OriginActor>();
            }
            return this._actors.add(value);
        }

        public boolean removeActor(OriginActor item) {
            OriginActor value = (OriginActor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._actors != null && this._actors.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Related Finding", description="Relates the poam-item to referenced finding(s).", name="related-finding", moduleClass=OscalPoamModule.class)
    public static class RelatedFinding
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Finding Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a finding defined in the list of findings.", name="finding-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _findingUuid;

        public RelatedFinding() {
            this(null);
        }

        public RelatedFinding(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getFindingUuid() {
            return this._findingUuid;
        }

        public void setFindingUuid(UUID value) {
            this._findingUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Related Observation", description="Relates the poam-item to a set of referenced observations that were used to determine the finding.", name="related-observation", moduleClass=OscalPoamModule.class)
    public static class RelatedObservation
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Observation Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an observation defined in the list of observations.", name="observation-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _observationUuid;

        public RelatedObservation() {
            this(null);
        }

        public RelatedObservation(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getObservationUuid() {
            return this._observationUuid;
        }

        public void setObservationUuid(UUID value) {
            this._observationUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Associated Risk", description="Relates the finding to a set of referenced risks that were used to determine the finding.", name="associated-risk", moduleClass=OscalPoamModule.class)
    public static class AssociatedRisk
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Risk Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a risk defined in the list of risks.", name="risk-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _riskUuid;

        public AssociatedRisk() {
            this(null);
        }

        public AssociatedRisk(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getRiskUuid() {
            return this._riskUuid;
        }

        public void setRiskUuid(UUID value) {
            this._riskUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

