/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.NonNegativeIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Port Range", description="Where applicable this is the IPv4 port range on which the service operates.", name="port-range", moduleClass=OscalImplementationCommonModule.class, remarks="To be validated as a natural number (integer \\>= 1). A single port uses the same value for start and end. Use multiple 'port-range' entries for non-contiguous ranges.", valueConstraints=@ValueConstraints(expect={@Expect(id="port-range-start-and-end-not-specified", level=IConstraint.Level.WARNING, test="exists(@start) and exists(@end)", message="If a protocol is defined, it should include a start and end port range. To define a single port, the start and end should be the same value."), @Expect(id="port-range-start-specified-with-no-end", level=IConstraint.Level.WARNING, test="exists(@start) and not(exists(@end))", message="A start port exists, but an end point does not. To define a single port, the start and end should be the same value."), @Expect(id="port-range-end-specified-with-no-start", level=IConstraint.Level.WARNING, test="not(exists(@start)) and exists(@end)", message="An end point exists, but a start port does not. To define a single port, the start and end should be the same value."), @Expect(id="port-range-end-date-is-before-start-date", level=IConstraint.Level.WARNING, test="@start <= @end", message="The port range specified has an end port that is less than the start port.")}))
public class PortRange
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Start", description="Indicates the starting port number in a port range", name="start", typeAdapter=NonNegativeIntegerAdapter.class, remarks="Should be a number within a permitted range")
    private BigInteger _start;
    @BoundFlag(formalName="End", description="Indicates the ending port number in a port range", name="end", typeAdapter=NonNegativeIntegerAdapter.class, remarks="Should be a number within a permitted range")
    private BigInteger _end;
    @BoundFlag(formalName="Transport", description="Indicates the transport type.", name="transport", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="TCP", description="Transmission Control Protocol"), @AllowedValue(value="UDP", description="User Datagram Protocol")})}))
    private String _transport;

    public PortRange() {
        this(null);
    }

    public PortRange(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public BigInteger getStart() {
        return this._start;
    }

    public void setStart(BigInteger value) {
        this._start = value;
    }

    public BigInteger getEnd() {
        return this._end;
    }

    public void setEnd(BigInteger value) {
        this._end = value;
    }

    public String getTransport() {
        return this._transport;
    }

    public void setTransport(String value) {
        this._transport = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

