/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AbstractOscalInstance;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Merge;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Modify;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.ProfileImport;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Profile", description="Each OSCAL profile is defined by a `profile` element.", name="profile", moduleClass=OscalProfileModule.class, rootName="profile", remarks="An OSCAL document that describes a tailoring of controls from one or more catalogs, with possible modification of multiple controls. It provides mechanisms by which controls may be selected (`import`), merged or (re)structured (`merge`), and amended (`modify`). OSCAL profiles may select subsets of controls, set parameter values for them in application, and even adjust the representation of controls as given in and by a catalog. They may also serve as sources for further modification in and by other profiles, that import them.")
public class Profile
extends AbstractOscalInstance
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Profile Universally Unique Identifier", description="Provides a globally unique means to identify a given profile instance.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import Resource", description="Designates a referenced source catalog or profile that provides a source of control information for use in creating a new overlay or baseline.", useName="import", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="imports", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileImport> _imports;
    @BoundAssembly(formalName="Merge Controls", description="Provides structuring directives that instruct how controls are organized after profile resolution.", useName="merge")
    private Merge _merge;
    @BoundAssembly(formalName="Modify Controls", description="Set parameters or amend controls in resolution.", useName="modify")
    private Modify _modify;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public Profile() {
        this(null);
    }

    public Profile(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public List<ProfileImport> getImports() {
        return this._imports;
    }

    public void setImports(List<ProfileImport> value) {
        this._imports = value;
    }

    public boolean addImport(ProfileImport item) {
        ProfileImport value = (ProfileImport)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._imports == null) {
            this._imports = new LinkedList<ProfileImport>();
        }
        return this._imports.add(value);
    }

    public boolean removeImport(ProfileImport item) {
        ProfileImport value = (ProfileImport)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._imports != null && this._imports.remove(value);
    }

    public Merge getMerge() {
        return this._merge;
    }

    public void setMerge(Merge value) {
        this._merge = value;
    }

    public Modify getModify() {
        return this._modify;
    }

    public void setModify(Modify value) {
        this._modify = value;
    }

    @Override
    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

