/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.InsertControls;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Control Group", description="A group of (selected) controls or of groups of controls.", name="group", moduleClass=OscalProfileModule.class, remarks="This construct mirrors the same construct that exists in an OSCAL catalog.")
public class ProfileGroup
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Group Identifier", description="Identifies the group.", name="id", typeAdapter=TokenAdapter.class, remarks="This optional data element is available to support hyperlinking to formal groups or families as defined in control catalogs, among other operations.")
    private String _id;
    @BoundFlag(formalName="Group Class", description="A textual label that provides a sub-type or characterization of the group.", name="class", typeAdapter=TokenAdapter.class, remarks="A `class` can be used in validation rules to express extra constraints over named items of a specific `class` value.\n\nA `class` can also be used in an OSCAL profile as a means to target an alteration to control content.")
    private String _clazz;
    @BoundField(formalName="Group Title", description="A name to be given to the group for use in display.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundAssembly(formalName="Parameter", description="Parameters provide a mechanism for the dynamic assignment of value(s) in a control.", useName="param", maxOccurs=-1, groupAs=@GroupAs(name="params", inJson=JsonGroupAsBehavior.LIST))
    private List<Parameter> _params;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Part", description="An annotated, markup-based textual element of a control's or catalog group's definition, or a child of another part.", useName="part", maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
    private List<ControlPart> _parts;
    @BoundAssembly(formalName="Control Group", description="A group of (selected) controls or of groups of controls.", useName="group", maxOccurs=-1, groupAs=@GroupAs(name="groups", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileGroup> _groups;
    @BoundAssembly(formalName="Insert Controls", description="Specifies which controls to use in the containing context.", useName="insert-controls", maxOccurs=-1, groupAs=@GroupAs(name="insert-controls", inJson=JsonGroupAsBehavior.LIST))
    private List<InsertControls> _insertControls;

    public ProfileGroup() {
        this(null);
    }

    public ProfileGroup(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getClazz() {
        return this._clazz;
    }

    public void setClazz(String value) {
        this._clazz = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public List<Parameter> getParams() {
        return this._params;
    }

    public void setParams(List<Parameter> value) {
        this._params = value;
    }

    public boolean addParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._params == null) {
            this._params = new LinkedList<Parameter>();
        }
        return this._params.add(value);
    }

    public boolean removeParam(Parameter item) {
        Parameter value = (Parameter)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._params != null && this._params.remove(value);
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ControlPart> getParts() {
        return this._parts;
    }

    public void setParts(List<ControlPart> value) {
        this._parts = value;
    }

    public boolean addPart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._parts == null) {
            this._parts = new LinkedList<ControlPart>();
        }
        return this._parts.add(value);
    }

    public boolean removePart(ControlPart item) {
        ControlPart value = (ControlPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._parts != null && this._parts.remove(value);
    }

    public List<ProfileGroup> getGroups() {
        return this._groups;
    }

    public void setGroups(List<ProfileGroup> value) {
        this._groups = value;
    }

    public boolean addGroup(ProfileGroup item) {
        ProfileGroup value = (ProfileGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._groups == null) {
            this._groups = new LinkedList<ProfileGroup>();
        }
        return this._groups.add(value);
    }

    public boolean removeGroup(ProfileGroup item) {
        ProfileGroup value = (ProfileGroup)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._groups != null && this._groups.remove(value);
    }

    public List<InsertControls> getInsertControls() {
        return this._insertControls;
    }

    public void setInsertControls(List<InsertControls> value) {
        this._insertControls = value;
    }

    public boolean addInsertControls(InsertControls item) {
        InsertControls value = (InsertControls)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._insertControls == null) {
            this._insertControls = new LinkedList<InsertControls>();
        }
        return this._insertControls.add(value);
    }

    public boolean removeInsertControls(InsertControls item) {
        InsertControls value = (InsertControls)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._insertControls != null && this._insertControls.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

