/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.IncludeAll;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.ProfileSelectControlById;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Import Resource", description="Designates a referenced source catalog or profile that provides a source of control information for use in creating a new overlay or baseline.", name="import", moduleClass=OscalProfileModule.class, remarks="The contents of the `import` element indicate which controls from the source will be included. Controls from the source catalog or profile may be either selected, using the `include-all` or `include-controls` directives, or de-selected (using an `exclude-controls` directive).")
public class ProfileImport
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Catalog or Profile Reference", description="A resolvable URL reference to the base catalog or profile that this profile is tailoring.", name="href", required=true, typeAdapter=UriReferenceAdapter.class, remarks="This value may be one of:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or\n3. a bare URI fragment (i.e., \\`#uuid\\`) pointing to a `back-matter` resource in this or an imported document (see [linking to another OSCAL object](https://pages.nist.gov/OSCAL/concepts/uri-use/#linking-to-another-oscal-object)).")
    private URI _href;
    @BoundAssembly(formalName="Include All", description="Include all controls from the imported catalog or profile resources.", useName="include-all", remarks="Identifies that all controls are to be included from the imported catalog or profile.", minOccurs=1)
    private IncludeAll _includeAll;
    @BoundAssembly(formalName="Select Control", description="Select a control or controls from an imported control set.", useName="include-controls", remarks="If `with-child-controls` is \"yes\" on the call to a control, any controls appearing within it (child controls) will be selected, with no additional `call` directives required. This flag provides a way to include controls with all their dependent controls (enhancements) without having to call them individually.", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="include-controls", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileSelectControlById> _includeControls;
    @BoundAssembly(formalName="Select Control", description="Select a control or controls from an imported control set.", useName="exclude-controls", remarks="Identifies which controls to exclude, or eliminate, from the set of included controls by control identifier or match pattern.", maxOccurs=-1, groupAs=@GroupAs(name="exclude-controls", inJson=JsonGroupAsBehavior.LIST))
    private List<ProfileSelectControlById> _excludeControls;

    public ProfileImport() {
        this(null);
    }

    public ProfileImport(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public URI getHref() {
        return this._href;
    }

    public void setHref(URI value) {
        this._href = value;
    }

    public IncludeAll getIncludeAll() {
        return this._includeAll;
    }

    public void setIncludeAll(IncludeAll value) {
        this._includeAll = value;
    }

    public List<ProfileSelectControlById> getIncludeControls() {
        return this._includeControls;
    }

    public void setIncludeControls(List<ProfileSelectControlById> value) {
        this._includeControls = value;
    }

    public boolean addIncludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._includeControls == null) {
            this._includeControls = new LinkedList<ProfileSelectControlById>();
        }
        return this._includeControls.add(value);
    }

    public boolean removeIncludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._includeControls != null && this._includeControls.remove(value);
    }

    public List<ProfileSelectControlById> getExcludeControls() {
        return this._excludeControls;
    }

    public void setExcludeControls(List<ProfileSelectControlById> value) {
        this._excludeControls = value;
    }

    public boolean addExcludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._excludeControls == null) {
            this._excludeControls = new LinkedList<ProfileSelectControlById>();
        }
        return this._excludeControls.add(value);
    }

    public boolean removeExcludeControls(ProfileSelectControlById item) {
        ProfileSelectControlById value = (ProfileSelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._excludeControls != null && this._excludeControls.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

