/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Matching;
import gov.nist.secauto.oscal.lib.model.OscalProfileModule;
import gov.nist.secauto.oscal.lib.model.control.profile.AbstractProfileSelectControlById;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Select Control", description="Select a control or controls from an imported control set.", name="select-control-by-id", moduleClass=OscalProfileModule.class, remarks="If `with-child-controls` is \"yes\" on the call to a control, no sibling `call`elements need to be used to call any controls appearing within it. Since generally, this is how control enhancements are represented (as controls within controls), this provides a way to include controls with all their dependent controls (enhancements) without having to call them individually.")
public class ProfileSelectControlById
extends AbstractProfileSelectControlById
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Include Contained Controls with Control", description="When a control is included, whether its child (dependent) controls are also included.", name="with-child-controls", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="yes", description="Include child controls with an included control."), @AllowedValue(value="no", description="When importing a control, only include child controls that are also explicitly called.")})}))
    private String _withChildControls;
    @BoundField(formalName="Match Controls by Identifier", description="Selecting a control by its ID given as a literal.", useName="with-id", maxOccurs=-1, groupAs=@GroupAs(name="with-ids", inJson=JsonGroupAsBehavior.LIST), typeAdapter=TokenAdapter.class)
    private List<String> _withIds;
    @BoundAssembly(formalName="Match Controls by Pattern", description="Selecting a set of controls by matching their IDs with a wildcard pattern.", useName="matching", maxOccurs=-1, groupAs=@GroupAs(name="matching", inJson=JsonGroupAsBehavior.LIST))
    private List<Matching> _matching;

    public ProfileSelectControlById() {
        this(null);
    }

    public ProfileSelectControlById(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public String getWithChildControls() {
        return this._withChildControls;
    }

    public void setWithChildControls(String value) {
        this._withChildControls = value;
    }

    @Override
    public List<String> getWithIds() {
        return this._withIds;
    }

    public void setWithIds(List<String> value) {
        this._withIds = value;
    }

    public boolean addWithId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._withIds == null) {
            this._withIds = new LinkedList<String>();
        }
        return this._withIds.add(value);
    }

    public boolean removeWithId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._withIds != null && this._withIds.remove(value);
    }

    @Override
    public List<Matching> getMatching() {
        return this._matching;
    }

    public void setMatching(List<Matching> value) {
        this._matching = value;
    }

    public boolean addMatching(Matching item) {
        Matching value = (Matching)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._matching == null) {
            this._matching = new LinkedList<Matching>();
        }
        return this._matching.add(value);
    }

    public boolean removeMatching(Matching item) {
        Matching value = (Matching)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._matching != null && this._matching.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

