/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractProperty;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", name="property", moduleClass=OscalMetadataModule.class, remarks="Properties permit the deployment and management of arbitrary controlled values, within OSCAL objects. A property can be included for any purpose useful to an application or implementation. Typically, properties will be used to sort, filter, select, order, and arrange OSCAL content objects, to relate OSCAL objects to one another, or to associate an OSCAL object to class hierarchies, taxonomies, or external authorities. Thus, the lexical composition of properties may be constrained by external processes to ensure consistency.\n\nProperty allows for associated remarks that describe why the specific property value was applied to the containing object, or the significance of the value in the context of the containing object.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target=".[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="marking", description="A label or descriptor that is tied to a sensitivity or classification marking system. An optional class can be used to define the specific marking system used for the associated value.")})}))
public class Property
extends AbstractProperty
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Property Name", description="A textual label, within a namespace, that uniquely identifies a specific attribute, characteristic, or quality of the property's containing object.", name="name", required=true, typeAdapter=TokenAdapter.class)
    private String _name;
    @BoundFlag(formalName="Property Universally Unique Identifier", description="A unique identifier for a property.", name="uuid", typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Property Namespace", description="A namespace qualifying the property's name. This allows different organizations to associate distinct semantics with the same name.", name="ns", defaultValue="http://csrc.nist.gov/ns/oscal", typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).\n\nWhen a `ns` is not provided, its value should be assumed to be `http://csrc.nist.gov/ns/oscal` and the name should be a name defined by the associated OSCAL model.")
    private URI _ns;
    @BoundFlag(formalName="Property Value", description="Indicates the value of the attribute, characteristic, or quality.", name="value", required=true, typeAdapter=StringAdapter.class)
    private String _value;
    @BoundFlag(formalName="Property Class", description="A textual label that provides a sub-type or characterization of the property's `name`.", name="class", typeAdapter=TokenAdapter.class, remarks="This can be used to further distinguish or discriminate between the semantics of multiple properties of the same object with the same `name` and `ns`, or to group properties into categories.\n\nA `class` can be used in validation rules to express extra constraints over named items of a specific `class` value. It is available for grouping, but unlike `group` is not expected specifically to designate any group membership as such.")
    private String _clazz;
    @BoundFlag(formalName="Property Group", description="An identifier for relating distinct sets of properties.", name="group", typeAdapter=TokenAdapter.class, remarks="Different sets of properties may relate to separate contexts. Declare a group on a property to associate it with one or more other properties in a given context.")
    private String _group;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Property() {
        this(null);
    }

    public Property(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public URI getNs() {
        return this._ns;
    }

    public void setNs(URI value) {
        this._ns = value;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getClazz() {
        return this._clazz;
    }

    public void setClazz(String value) {
        this._clazz = value;
    }

    public String getGroup() {
        return this._group;
    }

    public void setGroup(String value) {
        this._group = value;
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

