/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import gov.nist.secauto.oscal.lib.model.PortRange;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Service Protocol Information", description="Information about the protocol used to provide a service.", name="protocol", moduleClass=OscalImplementationCommonModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.WARNING, test="@uuid", message="It is a best practice to provide a UUID.")}))
public class Protocol
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Service Protocol Information Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this service protocol information elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `service protocol` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Protocol Name", description="The common name of the protocol, which should be the appropriate \"service name\" from the [IANA Service Name and Transport Protocol Port Number Registry](https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml).", name="name", required=true, typeAdapter=StringAdapter.class, remarks="The short name of the protocol (e.g., https).")
    private String _name;
    @BoundField(formalName="Protocol Title", description="A human readable name for the protocol (e.g., Transport Layer Security).", useName="title", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundAssembly(formalName="Port Range", description="Where applicable this is the IPv4 port range on which the service operates.", useName="port-range", maxOccurs=-1, groupAs=@GroupAs(name="port-ranges", inJson=JsonGroupAsBehavior.LIST))
    private List<PortRange> _portRanges;

    public Protocol() {
        this(null);
    }

    public Protocol(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public List<PortRange> getPortRanges() {
        return this._portRanges;
    }

    public void setPortRanges(List<PortRange> value) {
        this._portRanges = value;
    }

    public boolean addPortRange(PortRange item) {
        PortRange value = (PortRange)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._portRanges == null) {
            this._portRanges = new LinkedList<PortRange>();
        }
        return this._portRanges.add(value);
    }

    public boolean removePortRange(PortRange item) {
        PortRange value = (PortRange)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._portRanges != null && this._portRanges.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

