/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AssessmentSubject;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Task Reference", description="Identifies an individual task for which the containing object is a consequence of.", name="related-task", moduleClass=OscalAssessmentCommonModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-related-task-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
public class RelatedTask
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Task Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a unique task.", name="task-uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _taskUuid;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", remarks="Identifies the person or organization responsible for performing a specific role defined by the activity.", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleParty> _responsibleParties;
    @BoundAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", useName="subject", remarks="The assessment subjects that the task was performed against.", maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<AssessmentSubject> _subjects;
    @BoundAssembly(formalName="Identified Subject", description="Used to detail assessment subjects that were identfied by this task.", useName="identified-subject")
    private IdentifiedSubject _identifiedSubject;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public RelatedTask() {
        this(null);
    }

    public RelatedTask(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getTaskUuid() {
        return this._taskUuid;
    }

    public void setTaskUuid(UUID value) {
        this._taskUuid = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleParty> getResponsibleParties() {
        return this._responsibleParties;
    }

    public void setResponsibleParties(List<ResponsibleParty> value) {
        this._responsibleParties = value;
    }

    public boolean addResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleParties == null) {
            this._responsibleParties = new LinkedList<ResponsibleParty>();
        }
        return this._responsibleParties.add(value);
    }

    public boolean removeResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleParties != null && this._responsibleParties.remove(value);
    }

    public List<AssessmentSubject> getSubjects() {
        return this._subjects;
    }

    public void setSubjects(List<AssessmentSubject> value) {
        this._subjects = value;
    }

    public boolean addSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._subjects == null) {
            this._subjects = new LinkedList<AssessmentSubject>();
        }
        return this._subjects.add(value);
    }

    public boolean removeSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._subjects != null && this._subjects.remove(value);
    }

    public IdentifiedSubject getIdentifiedSubject() {
        return this._identifiedSubject;
    }

    public void setIdentifiedSubject(IdentifiedSubject value) {
        this._identifiedSubject = value;
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Identified Subject", description="Used to detail assessment subjects that were identfied by this task.", name="identified-subject", moduleClass=OscalAssessmentCommonModule.class)
    public static class IdentifiedSubject
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Assessment Subject Placeholder Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a unique assessment subject placeholder defined by this task.", name="subject-placeholder-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _subjectPlaceholderUuid;
        @BoundAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", useName="subject", remarks="The assessment subjects that the task identified, which will be used by another task through a subject-placeholder reference. Such a task will \"consume\" these subjects.", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
        private List<AssessmentSubject> _subjects;

        public IdentifiedSubject() {
            this(null);
        }

        public IdentifiedSubject(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getSubjectPlaceholderUuid() {
            return this._subjectPlaceholderUuid;
        }

        public void setSubjectPlaceholderUuid(UUID value) {
            this._subjectPlaceholderUuid = value;
        }

        public List<AssessmentSubject> getSubjects() {
            return this._subjects;
        }

        public void setSubjects(List<AssessmentSubject> value) {
            this._subjects = value;
        }

        public boolean addSubject(AssessmentSubject item) {
            AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._subjects == null) {
                this._subjects = new LinkedList<AssessmentSubject>();
            }
            return this._subjects.add(value);
        }

        public boolean removeSubject(AssessmentSubject item) {
            AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._subjects != null && this._subjects.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

