/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Origin;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SubjectReference;
import gov.nist.secauto.oscal.lib.model.Task;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Risk Response", description="Describes either recommended or an actual plan for addressing the risk.", name="response", moduleClass=OscalAssessmentCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="type", description="")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type']/@value", values={@AllowedValue(value="avoid", description="The risk will be eliminated."), @AllowedValue(value="mitigate", description="The risk will be reduced."), @AllowedValue(value="transfer", description="The risk will be transferred to another organization or entity."), @AllowedValue(value="accept", description="The risk will continue to exist without further efforts to address it. (Sometimes referred to as \"Operationally required\")"), @AllowedValue(value="share", description="The risk will be partially transferred to another organization or entity."), @AllowedValue(value="contingency", description="Plans will be made to address the risk impact if the risk occurs. (This is a form of mitigation.)"), @AllowedValue(value="none", description="No response, such as when the identified risk is found to be a false positive.")})}))
public class Response
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Remediation Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this remediation elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `risk response` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Remediation Intent", description="Identifies whether this is a recommendation, such as from an assessor or tool, or an actual plan accepted by the system owner.", name="lifecycle", required=true, typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="recommendation", description="Recommended remediation."), @AllowedValue(value="planned", description="The actions intended to resolve the risk."), @AllowedValue(value="completed", description="This remediation activities were performed to address the risk.")})}))
    private String _lifecycle;
    @BoundField(formalName="Response Title", description="The title for this response activity.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Response Description", description="A human-readable description of this response plan.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", useName="origin", remarks="Used to identify the individual and/or tool that generated this recommended or planned response.", maxOccurs=-1, groupAs=@GroupAs(name="origins", inJson=JsonGroupAsBehavior.LIST))
    private List<Origin> _origins;
    @BoundAssembly(formalName="Required Asset", description="Identifies an asset required to achieve remediation.", useName="required-asset", maxOccurs=-1, groupAs=@GroupAs(name="required-assets", inJson=JsonGroupAsBehavior.LIST))
    private List<RequiredAsset> _requiredAssets;
    @BoundAssembly(formalName="Task", description="Represents a scheduled event or milestone, which may be associated with a series of assessment actions.", useName="task", maxOccurs=-1, groupAs=@GroupAs(name="tasks", inJson=JsonGroupAsBehavior.LIST))
    private List<Task> _tasks;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Response() {
        this(null);
    }

    public Response(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public void setLifecycle(String value) {
        this._lifecycle = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<Origin> getOrigins() {
        return this._origins;
    }

    public void setOrigins(List<Origin> value) {
        this._origins = value;
    }

    public boolean addOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._origins == null) {
            this._origins = new LinkedList<Origin>();
        }
        return this._origins.add(value);
    }

    public boolean removeOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._origins != null && this._origins.remove(value);
    }

    public List<RequiredAsset> getRequiredAssets() {
        return this._requiredAssets;
    }

    public void setRequiredAssets(List<RequiredAsset> value) {
        this._requiredAssets = value;
    }

    public boolean addRequiredAsset(RequiredAsset item) {
        RequiredAsset value = (RequiredAsset)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._requiredAssets == null) {
            this._requiredAssets = new LinkedList<RequiredAsset>();
        }
        return this._requiredAssets.add(value);
    }

    public boolean removeRequiredAsset(RequiredAsset item) {
        RequiredAsset value = (RequiredAsset)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._requiredAssets != null && this._requiredAssets.remove(value);
    }

    public List<Task> getTasks() {
        return this._tasks;
    }

    public void setTasks(List<Task> value) {
        this._tasks = value;
    }

    public boolean addTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._tasks == null) {
            this._tasks = new LinkedList<Task>();
        }
        return this._tasks.add(value);
    }

    public boolean removeTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._tasks != null && this._tasks.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Required Asset", description="Identifies an asset required to achieve remediation.", name="required-asset", moduleClass=OscalAssessmentCommonModule.class)
    public static class RequiredAsset
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Required Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this required asset elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `asset` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundAssembly(formalName="Identifies the Subject", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) identifier reference to a resource. Use type to indicate whether the identified resource is a component, inventory item, location, user, or something else.", useName="subject", remarks="Identifies an asset associated with this requirement, such as a party, system component, or inventory-item.", maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
        private List<SubjectReference> _subjects;
        @BoundField(formalName="Title for Required Asset", description="The title for this required asset.", useName="title", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundField(formalName="Description of Required Asset", description="A human-readable description of this required asset.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public RequiredAsset() {
            this(null);
        }

        public RequiredAsset(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public List<SubjectReference> getSubjects() {
            return this._subjects;
        }

        public void setSubjects(List<SubjectReference> value) {
            this._subjects = value;
        }

        public boolean addSubject(SubjectReference item) {
            SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._subjects == null) {
                this._subjects = new LinkedList<SubjectReference>();
            }
            return this._subjects.add(value);
        }

        public boolean removeSubject(SubjectReference item) {
            SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._subjects != null && this._subjects.remove(value);
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

