/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AssessmentAssets;
import gov.nist.secauto.oscal.lib.model.AssessmentPart;
import gov.nist.secauto.oscal.lib.model.Finding;
import gov.nist.secauto.oscal.lib.model.InventoryItem;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.LoggedBy;
import gov.nist.secauto.oscal.lib.model.Observation;
import gov.nist.secauto.oscal.lib.model.OscalArModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.RelatedTask;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import gov.nist.secauto.oscal.lib.model.ReviewedControls;
import gov.nist.secauto.oscal.lib.model.Risk;
import gov.nist.secauto.oscal.lib.model.SystemComponent;
import gov.nist.secauto.oscal.lib.model.SystemUser;
import gov.nist.secauto.oscal.lib.model.Task;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Assessment Result", description="Used by the assessment results and POA\\&M. In the assessment results, this identifies all of the assessment observations and findings, initial and residual risks, deviations, and disposition. In the POA\\&M, this identifies initial and residual risks, deviations, and disposition.", name="result", moduleClass=OscalArModule.class)
public class Result
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Results Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this set of results in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ar-identifiers). The locally defined *UUID* of the `assessment result` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Results Title", description="The title for this set of results.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Results Description", description="A human-readable description of this set of test results.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundField(formalName="start field", description="Date/time stamp identifying the start of the evidence collection reflected in these results.", useName="start", minOccurs=1, typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _start;
    @BoundField(formalName="end field", description="Date/time stamp identifying the end of the evidence collection reflected in these results. In a continuous motoring scenario, this may contain the same value as start if appropriate.", useName="end", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _end;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", useName="local-definitions")
    private LocalDefinitions _localDefinitions;
    @BoundAssembly(formalName="Reviewed Controls and Control Objectives", description="Identifies the controls being assessed and their control objectives.", useName="reviewed-controls", remarks="The Assessment Results `control-selection` ignores any control selection in the Assessment Plan and re-selects controls from the baseline identified by the SSP.\n\nThe Assessment Results `control-objective-selection` ignores any control objective selection in the Assessment Plan and re-selects control objectives from the baseline identified by the SSP.\n\nAny additional control objectives defined in the Assessment Plan `local-definitions` do not need to be re-defined in the Assessment Results `local-definitions`; however, if they were explicitly referenced with an Assessment Plan `control-objective-selection`, they need to be selected again in the Assessment Results `control-objective-selection`.", minOccurs=1)
    private ReviewedControls _reviewedControls;
    @BoundAssembly(formalName="Attestation Statements", description="A set of textual statements, typically written by the assessor.", useName="attestation", maxOccurs=-1, groupAs=@GroupAs(name="attestations", inJson=JsonGroupAsBehavior.LIST))
    private List<Attestation> _attestations;
    @BoundAssembly(formalName="Assessment Log", description="A log of all assessment-related actions taken.", useName="assessment-log")
    private AssessmentLog _assessmentLog;
    @BoundAssembly(formalName="Observation", description="Describes an individual observation.", useName="observation", maxOccurs=-1, groupAs=@GroupAs(name="observations", inJson=JsonGroupAsBehavior.LIST))
    private List<Observation> _observations;
    @BoundAssembly(formalName="Identified Risk", description="An identified risk.", useName="risk", maxOccurs=-1, groupAs=@GroupAs(name="risks", inJson=JsonGroupAsBehavior.LIST))
    private List<Risk> _risks;
    @BoundAssembly(formalName="Finding", description="Describes an individual finding.", useName="finding", maxOccurs=-1, groupAs=@GroupAs(name="findings", inJson=JsonGroupAsBehavior.LIST))
    private List<Finding> _findings;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Result() {
        this(null);
    }

    public Result(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public ZonedDateTime getStart() {
        return this._start;
    }

    public void setStart(ZonedDateTime value) {
        this._start = value;
    }

    public ZonedDateTime getEnd() {
        return this._end;
    }

    public void setEnd(ZonedDateTime value) {
        this._end = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public LocalDefinitions getLocalDefinitions() {
        return this._localDefinitions;
    }

    public void setLocalDefinitions(LocalDefinitions value) {
        this._localDefinitions = value;
    }

    public ReviewedControls getReviewedControls() {
        return this._reviewedControls;
    }

    public void setReviewedControls(ReviewedControls value) {
        this._reviewedControls = value;
    }

    public List<Attestation> getAttestations() {
        return this._attestations;
    }

    public void setAttestations(List<Attestation> value) {
        this._attestations = value;
    }

    public boolean addAttestation(Attestation item) {
        Attestation value = (Attestation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._attestations == null) {
            this._attestations = new LinkedList<Attestation>();
        }
        return this._attestations.add(value);
    }

    public boolean removeAttestation(Attestation item) {
        Attestation value = (Attestation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._attestations != null && this._attestations.remove(value);
    }

    public AssessmentLog getAssessmentLog() {
        return this._assessmentLog;
    }

    public void setAssessmentLog(AssessmentLog value) {
        this._assessmentLog = value;
    }

    public List<Observation> getObservations() {
        return this._observations;
    }

    public void setObservations(List<Observation> value) {
        this._observations = value;
    }

    public boolean addObservation(Observation item) {
        Observation value = (Observation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._observations == null) {
            this._observations = new LinkedList<Observation>();
        }
        return this._observations.add(value);
    }

    public boolean removeObservation(Observation item) {
        Observation value = (Observation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._observations != null && this._observations.remove(value);
    }

    public List<Risk> getRisks() {
        return this._risks;
    }

    public void setRisks(List<Risk> value) {
        this._risks = value;
    }

    public boolean addRisk(Risk item) {
        Risk value = (Risk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._risks == null) {
            this._risks = new LinkedList<Risk>();
        }
        return this._risks.add(value);
    }

    public boolean removeRisk(Risk item) {
        Risk value = (Risk)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._risks != null && this._risks.remove(value);
    }

    public List<Finding> getFindings() {
        return this._findings;
    }

    public void setFindings(List<Finding> value) {
        this._findings = value;
    }

    public boolean addFinding(Finding item) {
        Finding value = (Finding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._findings == null) {
            this._findings = new LinkedList<Finding>();
        }
        return this._findings.add(value);
    }

    public boolean removeFinding(Finding item) {
        Finding value = (Finding)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._findings != null && this._findings.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", name="local-definitions", moduleClass=OscalArModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ar-local-definitions-component", level=IConstraint.Level.ERROR, target="component", keyFields={@KeyField(target="@uuid")}, remarks="Since multiple `component` entries can be provided, each component must have a unique `uuid`."), @IsUnique(id="unique-ar-local-definitions-user", level=IConstraint.Level.ERROR, target="user", keyFields={@KeyField(target="@uuid")}, remarks="A given `uuid` must be assigned only once to a user.")}))
    public static class LocalDefinitions
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", remarks="Used to add any components, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
        private List<SystemComponent> _components;
        @BoundAssembly(formalName="Inventory Item", description="A single managed inventory item within the system.", useName="inventory-item", remarks="Used to add any inventory-items, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="inventory-items", inJson=JsonGroupAsBehavior.LIST))
        private List<InventoryItem> _inventoryItems;
        @BoundAssembly(formalName="System User", description="A type of user that interacts with the system based on an associated role.", useName="user", remarks="Used to add any users, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="users", inJson=JsonGroupAsBehavior.LIST))
        private List<SystemUser> _users;
        @BoundAssembly(formalName="Assessment Assets", description="Identifies the assets used to perform this assessment, such as the assessment team, scanning tools, and assumptions.", useName="assessment-assets", remarks="This needs to be defined in the results if an assessment platform used is different from the one described in the assessment plan. Else the platform(s) defined in the plan may be referenced within the results.")
        private AssessmentAssets _assessmentAssets;
        @BoundAssembly(formalName="Task", description="Represents a scheduled event or milestone, which may be associated with a series of assessment actions.", useName="assessment-task", maxOccurs=-1, groupAs=@GroupAs(name="tasks", inJson=JsonGroupAsBehavior.LIST))
        private List<Task> _tasks;

        public LocalDefinitions() {
            this(null);
        }

        public LocalDefinitions(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<SystemComponent> getComponents() {
            return this._components;
        }

        public void setComponents(List<SystemComponent> value) {
            this._components = value;
        }

        public boolean addComponent(SystemComponent item) {
            SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._components == null) {
                this._components = new LinkedList<SystemComponent>();
            }
            return this._components.add(value);
        }

        public boolean removeComponent(SystemComponent item) {
            SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._components != null && this._components.remove(value);
        }

        public List<InventoryItem> getInventoryItems() {
            return this._inventoryItems;
        }

        public void setInventoryItems(List<InventoryItem> value) {
            this._inventoryItems = value;
        }

        public boolean addInventoryItem(InventoryItem item) {
            InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._inventoryItems == null) {
                this._inventoryItems = new LinkedList<InventoryItem>();
            }
            return this._inventoryItems.add(value);
        }

        public boolean removeInventoryItem(InventoryItem item) {
            InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._inventoryItems != null && this._inventoryItems.remove(value);
        }

        public List<SystemUser> getUsers() {
            return this._users;
        }

        public void setUsers(List<SystemUser> value) {
            this._users = value;
        }

        public boolean addUser(SystemUser item) {
            SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._users == null) {
                this._users = new LinkedList<SystemUser>();
            }
            return this._users.add(value);
        }

        public boolean removeUser(SystemUser item) {
            SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._users != null && this._users.remove(value);
        }

        public AssessmentAssets getAssessmentAssets() {
            return this._assessmentAssets;
        }

        public void setAssessmentAssets(AssessmentAssets value) {
            this._assessmentAssets = value;
        }

        public List<Task> getTasks() {
            return this._tasks;
        }

        public void setTasks(List<Task> value) {
            this._tasks = value;
        }

        public boolean addAssessmentTask(Task item) {
            Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._tasks == null) {
                this._tasks = new LinkedList<Task>();
            }
            return this._tasks.add(value);
        }

        public boolean removeAssessmentTask(Task item) {
            Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._tasks != null && this._tasks.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Attestation Statements", description="A set of textual statements, typically written by the assessor.", name="attestation", moduleClass=OscalArModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ar-attestation-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
    public static class Attestation
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
        private List<ResponsibleParty> _responsibleParties;
        @BoundAssembly(formalName="Assessment Part", description="A partition of an assessment plan or results or a child of another part.", useName="part", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
        private List<AssessmentPart> _parts;

        public Attestation() {
            this(null);
        }

        public Attestation(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<ResponsibleParty> getResponsibleParties() {
            return this._responsibleParties;
        }

        public void setResponsibleParties(List<ResponsibleParty> value) {
            this._responsibleParties = value;
        }

        public boolean addResponsibleParty(ResponsibleParty item) {
            ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibleParties == null) {
                this._responsibleParties = new LinkedList<ResponsibleParty>();
            }
            return this._responsibleParties.add(value);
        }

        public boolean removeResponsibleParty(ResponsibleParty item) {
            ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibleParties != null && this._responsibleParties.remove(value);
        }

        public List<AssessmentPart> getParts() {
            return this._parts;
        }

        public void setParts(List<AssessmentPart> value) {
            this._parts = value;
        }

        public boolean addPart(AssessmentPart item) {
            AssessmentPart value = (AssessmentPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._parts == null) {
                this._parts = new LinkedList<AssessmentPart>();
            }
            return this._parts.add(value);
        }

        public boolean removePart(AssessmentPart item) {
            AssessmentPart value = (AssessmentPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._parts != null && this._parts.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Assessment Log", description="A log of all assessment-related actions taken.", name="assessment-log", moduleClass=OscalArModule.class)
    public static class AssessmentLog
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Assessment Log Entry", description="Identifies the result of an action and/or task that occurred as part of executing an assessment plan or an assessment event that occurred in producing the assessment results.", useName="entry", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="entries", inJson=JsonGroupAsBehavior.LIST))
        private List<Entry> _entries;

        public AssessmentLog() {
            this(null);
        }

        public AssessmentLog(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<Entry> getEntries() {
            return this._entries;
        }

        public void setEntries(List<Entry> value) {
            this._entries = value;
        }

        public boolean addEntry(Entry item) {
            Entry value = (Entry)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._entries == null) {
                this._entries = new LinkedList<Entry>();
            }
            return this._entries.add(value);
        }

        public boolean removeEntry(Entry item) {
            Entry value = (Entry)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._entries != null && this._entries.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Assessment Log Entry", description="Identifies the result of an action and/or task that occurred as part of executing an assessment plan or an assessment event that occurred in producing the assessment results.", name="entry", moduleClass=OscalArModule.class)
        public static class Entry
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Assessment Log Entry Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference an assessment event in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ar-identifiers). The locally defined *UUID* of the `assessment log entry` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
            private UUID _uuid;
            @BoundField(formalName="Action Title", description="The title for this event.", useName="title", typeAdapter=MarkupLineAdapter.class)
            private MarkupLine _title;
            @BoundField(formalName="Action Description", description="A human-readable description of this event.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _description;
            @BoundField(formalName="Start", description="Identifies the start date and time of an event.", useName="start", minOccurs=1, typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _start;
            @BoundField(formalName="End", description="Identifies the end date and time of an event. If the event is a point in time, the start and end will be the same date and time.", useName="end", typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _end;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Logged By", description="Used to indicate who created a log entry in what role.", useName="logged-by", maxOccurs=-1, groupAs=@GroupAs(name="logged-by", inJson=JsonGroupAsBehavior.LIST))
            private List<LoggedBy> _loggedBy;
            @BoundAssembly(formalName="Task Reference", description="Identifies an individual task for which the containing object is a consequence of.", useName="related-task", maxOccurs=-1, groupAs=@GroupAs(name="related-tasks", inJson=JsonGroupAsBehavior.LIST))
            private List<RelatedTask> _relatedTasks;
            @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _remarks;

            public Entry() {
                this(null);
            }

            public Entry(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public UUID getUuid() {
                return this._uuid;
            }

            public void setUuid(UUID value) {
                this._uuid = value;
            }

            public MarkupLine getTitle() {
                return this._title;
            }

            public void setTitle(MarkupLine value) {
                this._title = value;
            }

            public MarkupMultiline getDescription() {
                return this._description;
            }

            public void setDescription(MarkupMultiline value) {
                this._description = value;
            }

            public ZonedDateTime getStart() {
                return this._start;
            }

            public void setStart(ZonedDateTime value) {
                this._start = value;
            }

            public ZonedDateTime getEnd() {
                return this._end;
            }

            public void setEnd(ZonedDateTime value) {
                this._end = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<LoggedBy> getLoggedBy() {
                return this._loggedBy;
            }

            public void setLoggedBy(List<LoggedBy> value) {
                this._loggedBy = value;
            }

            public boolean addLoggedBy(LoggedBy item) {
                LoggedBy value = (LoggedBy)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._loggedBy == null) {
                    this._loggedBy = new LinkedList<LoggedBy>();
                }
                return this._loggedBy.add(value);
            }

            public boolean removeLoggedBy(LoggedBy item) {
                LoggedBy value = (LoggedBy)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._loggedBy != null && this._loggedBy.remove(value);
            }

            public List<RelatedTask> getRelatedTasks() {
                return this._relatedTasks;
            }

            public void setRelatedTasks(List<RelatedTask> value) {
                this._relatedTasks = value;
            }

            public boolean addRelatedTask(RelatedTask item) {
                RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._relatedTasks == null) {
                    this._relatedTasks = new LinkedList<RelatedTask>();
                }
                return this._relatedTasks.add(value);
            }

            public boolean removeRelatedTask(RelatedTask item) {
                RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._relatedTasks != null && this._relatedTasks.remove(value);
            }

            public MarkupMultiline getRemarks() {
                return this._remarks;
            }

            public void setRemarks(MarkupMultiline value) {
                this._remarks = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

