/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.IncludeAll;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SelectControlById;
import gov.nist.secauto.oscal.lib.model.SelectObjectiveById;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Reviewed Controls and Control Objectives", description="Identifies the controls being assessed and their control objectives.", name="reviewed-controls", moduleClass=OscalAssessmentCommonModule.class, remarks="In the context of an assessment plan, this construct is used to identify the controls and control objectives that are to be assessed. In the context of an assessment result, this construct is used to identify the actual controls and objectives that were assessed, reflecting any changes from the plan.\n\nWhen resolving the selection of controls and control objectives, the following processing will occur:\n\n1. Controls will be resolved by creating a set of controls based on the control-selections by first handling the includes, and then removing any excluded controls.\n\n2. The set of control objectives will be resolved from the set of controls that was generated in the previous step. The set of control objectives is based on the control-objective-selection by first handling the includes, and then removing any excluded control objectives.")
public class ReviewedControls
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Control Objective Description", description="A human-readable description of control objectives.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Assessed Controls", description="Identifies the controls being assessed. In the assessment plan, these are the planned controls. In the assessment results, these are the actual controls, and reflects any changes from the plan.", useName="control-selection", remarks="The `include-all`, specifies all control identified in the **baseline** are included in the scope if this assessment, as specified by the `include-profile` statement within the linked SSP.\n\nAny control specified within `exclude-controls` must first be within a range of explicitly included controls, via `include-controls` or `include-all`.", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="control-selections", inJson=JsonGroupAsBehavior.LIST))
    private List<ControlSelection> _controlSelections;
    @BoundAssembly(formalName="Referenced Control Objectives", description="Identifies the control objectives of the assessment. In the assessment plan, these are the planned objectives. In the assessment results, these are the assessed objectives, and reflects any changes from the plan.", useName="control-objective-selection", remarks="The `include-all` field, specifies all control objectives for any in-scope control. In-scope controls are defined in the `control-selection`.\n\nAny control objective specified within `exclude-controls` must first be within a range of explicitly included control objectives, via `include-objectives` or `include-all`.", maxOccurs=-1, groupAs=@GroupAs(name="control-objective-selections", inJson=JsonGroupAsBehavior.LIST))
    private List<ControlObjectiveSelection> _controlObjectiveSelections;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public ReviewedControls() {
        this(null);
    }

    public ReviewedControls(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ControlSelection> getControlSelections() {
        return this._controlSelections;
    }

    public void setControlSelections(List<ControlSelection> value) {
        this._controlSelections = value;
    }

    public boolean addControlSelection(ControlSelection item) {
        ControlSelection value = (ControlSelection)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controlSelections == null) {
            this._controlSelections = new LinkedList<ControlSelection>();
        }
        return this._controlSelections.add(value);
    }

    public boolean removeControlSelection(ControlSelection item) {
        ControlSelection value = (ControlSelection)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controlSelections != null && this._controlSelections.remove(value);
    }

    public List<ControlObjectiveSelection> getControlObjectiveSelections() {
        return this._controlObjectiveSelections;
    }

    public void setControlObjectiveSelections(List<ControlObjectiveSelection> value) {
        this._controlObjectiveSelections = value;
    }

    public boolean addControlObjectiveSelection(ControlObjectiveSelection item) {
        ControlObjectiveSelection value = (ControlObjectiveSelection)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._controlObjectiveSelections == null) {
            this._controlObjectiveSelections = new LinkedList<ControlObjectiveSelection>();
        }
        return this._controlObjectiveSelections.add(value);
    }

    public boolean removeControlObjectiveSelection(ControlObjectiveSelection item) {
        ControlObjectiveSelection value = (ControlObjectiveSelection)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._controlObjectiveSelections != null && this._controlObjectiveSelections.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Assessed Controls", description="Identifies the controls being assessed. In the assessment plan, these are the planned controls. In the assessment results, these are the actual controls, and reflects any changes from the plan.", name="control-selection", moduleClass=OscalAssessmentCommonModule.class, remarks="The `include-all`, specifies all control identified in the **baseline** are included in the scope if this assessment, as specified by the `include-profile` statement within the linked SSP.\n\nAny control specified within `exclude-controls` must first be within a range of explicitly included controls, via `include-controls` or `include-all`.")
    public static class ControlSelection
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundField(formalName="Assessed Controls Description", description="A human-readable description of in-scope controls specified for assessment.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Include All", description="Include all controls from the imported catalog or profile resources.", useName="include-all", minOccurs=1)
        private IncludeAll _includeAll;
        @BoundAssembly(formalName="Select Control", description="Used to select a control for inclusion/exclusion based on one or more control identifiers. A set of statement identifiers can be used to target the inclusion/exclusion to only specific control statements providing more granularity over the specific statements that are within the asessment scope.", useName="include-control", remarks="Used to select a control for inclusion by the control's identifier. Specific control statements can be selected by their statement identifier.", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="include-controls", inJson=JsonGroupAsBehavior.LIST))
        private List<SelectControlById> _includeControls;
        @BoundAssembly(formalName="Select Control", description="Used to select a control for inclusion/exclusion based on one or more control identifiers. A set of statement identifiers can be used to target the inclusion/exclusion to only specific control statements providing more granularity over the specific statements that are within the asessment scope.", useName="exclude-control", remarks="Used to select a control for exclusion by the control's identifier. Specific control statements can be excluded by their statement identifier.", maxOccurs=-1, groupAs=@GroupAs(name="exclude-controls", inJson=JsonGroupAsBehavior.LIST))
        private List<SelectControlById> _excludeControls;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public ControlSelection() {
            this(null);
        }

        public ControlSelection(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public IncludeAll getIncludeAll() {
            return this._includeAll;
        }

        public void setIncludeAll(IncludeAll value) {
            this._includeAll = value;
        }

        public List<SelectControlById> getIncludeControls() {
            return this._includeControls;
        }

        public void setIncludeControls(List<SelectControlById> value) {
            this._includeControls = value;
        }

        public boolean addIncludeControl(SelectControlById item) {
            SelectControlById value = (SelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._includeControls == null) {
                this._includeControls = new LinkedList<SelectControlById>();
            }
            return this._includeControls.add(value);
        }

        public boolean removeIncludeControl(SelectControlById item) {
            SelectControlById value = (SelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._includeControls != null && this._includeControls.remove(value);
        }

        public List<SelectControlById> getExcludeControls() {
            return this._excludeControls;
        }

        public void setExcludeControls(List<SelectControlById> value) {
            this._excludeControls = value;
        }

        public boolean addExcludeControl(SelectControlById item) {
            SelectControlById value = (SelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._excludeControls == null) {
                this._excludeControls = new LinkedList<SelectControlById>();
            }
            return this._excludeControls.add(value);
        }

        public boolean removeExcludeControl(SelectControlById item) {
            SelectControlById value = (SelectControlById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._excludeControls != null && this._excludeControls.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Referenced Control Objectives", description="Identifies the control objectives of the assessment. In the assessment plan, these are the planned objectives. In the assessment results, these are the assessed objectives, and reflects any changes from the plan.", name="control-objective-selection", moduleClass=OscalAssessmentCommonModule.class, remarks="The `include-all` field, specifies all control objectives for any in-scope control. In-scope controls are defined in the `control-selection`.\n\nAny control objective specified within `exclude-controls` must first be within a range of explicitly included control objectives, via `include-objectives` or `include-all`.")
    public static class ControlObjectiveSelection
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundField(formalName="Control Objectives Description", description="A human-readable description of this collection of control objectives.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Include All", description="Include all controls from the imported catalog or profile resources.", useName="include-all", minOccurs=1)
        private IncludeAll _includeAll;
        @BoundAssembly(formalName="Select Objective", description="Used to select a control objective for inclusion/exclusion based on the control objective's identifier.", useName="include-objective", remarks="Used to select a control objective for inclusion by the control objective's identifier.", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="include-objectives", inJson=JsonGroupAsBehavior.LIST))
        private List<SelectObjectiveById> _includeObjectives;
        @BoundAssembly(formalName="Select Objective", description="Used to select a control objective for inclusion/exclusion based on the control objective's identifier.", useName="exclude-objective", remarks="Used to select a control objective for exclusion by the control objective's identifier.", maxOccurs=-1, groupAs=@GroupAs(name="exclude-objectives", inJson=JsonGroupAsBehavior.LIST))
        private List<SelectObjectiveById> _excludeObjectives;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public ControlObjectiveSelection() {
            this(null);
        }

        public ControlObjectiveSelection(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public IncludeAll getIncludeAll() {
            return this._includeAll;
        }

        public void setIncludeAll(IncludeAll value) {
            this._includeAll = value;
        }

        public List<SelectObjectiveById> getIncludeObjectives() {
            return this._includeObjectives;
        }

        public void setIncludeObjectives(List<SelectObjectiveById> value) {
            this._includeObjectives = value;
        }

        public boolean addIncludeObjective(SelectObjectiveById item) {
            SelectObjectiveById value = (SelectObjectiveById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._includeObjectives == null) {
                this._includeObjectives = new LinkedList<SelectObjectiveById>();
            }
            return this._includeObjectives.add(value);
        }

        public boolean removeIncludeObjective(SelectObjectiveById item) {
            SelectObjectiveById value = (SelectObjectiveById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._includeObjectives != null && this._includeObjectives.remove(value);
        }

        public List<SelectObjectiveById> getExcludeObjectives() {
            return this._excludeObjectives;
        }

        public void setExcludeObjectives(List<SelectObjectiveById> value) {
            this._excludeObjectives = value;
        }

        public boolean addExcludeObjective(SelectObjectiveById item) {
            SelectObjectiveById value = (SelectObjectiveById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._excludeObjectives == null) {
                this._excludeObjectives = new LinkedList<SelectObjectiveById>();
            }
            return this._excludeObjectives.add(value);
        }

        public boolean removeExcludeObjective(SelectObjectiveById item) {
            SelectObjectiveById value = (SelectObjectiveById)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._excludeObjectives != null && this._excludeObjectives.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

