/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Characterization;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.LoggedBy;
import gov.nist.secauto.oscal.lib.model.Origin;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.RelatedTask;
import gov.nist.secauto.oscal.lib.model.Response;
import gov.nist.secauto.oscal.lib.model.SubjectReference;
import gov.nist.secauto.oscal.lib.model.ThreatId;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Identified Risk", description="An identified risk.", name="risk", moduleClass=OscalAssessmentCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="false-positive", description="The risk has been confirmed to be a false positive."), @AllowedValue(value="accepted", description="The risk has been accepted. No further action will be taken."), @AllowedValue(value="risk-adjusted", description="The risk has been adjusted."), @AllowedValue(value="priority", description="A numeric value indicating the sequence in which risks should be addressed. (Lower numbers are higher priority)")})}, matches={@Matches(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='priority']/@value", typeAdapter=IntegerAdapter.class)}))
public class Risk
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Risk Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this risk elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `risk` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="Risk Title", description="The title for this risk.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Risk Description", description="A human-readable summary of the identified risk, to include a statement of how the risk impacts the system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundField(formalName="Risk Statement", description="An summary of impact for how the risk affects the system.", useName="statement", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _statement;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundField(formalName="Risk Status", description="Describes the status of the associated risk.", useName="status", minOccurs=1, typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="open", description="The risk has been identified."), @AllowedValue(value="investigating", description="The identified risk is being investigated. (Open risk)"), @AllowedValue(value="remediating", description="Remediation activities are underway, but are not yet complete. (Open risk)"), @AllowedValue(value="deviation-requested", description="A risk deviation, such as false positive, risk reduction, or operational requirement has been submitted for approval. (Open risk)"), @AllowedValue(value="deviation-approved", description="A risk deviation, such as false positive, risk reduction, or operational requirement has been approved. (Open risk)"), @AllowedValue(value="closed", description="The risk has been resolved.")})}))
    private String _status;
    @BoundAssembly(formalName="Origin", description="Identifies the source of the finding, such as a tool, interviewed person, or activity.", useName="origin", remarks="Used to identify the individual and/or tool that identified this risk.", maxOccurs=-1, groupAs=@GroupAs(name="origins", inJson=JsonGroupAsBehavior.LIST))
    private List<Origin> _origins;
    @BoundField(formalName="Threat ID", description="A pointer, by ID, to an externally-defined threat.", useName="threat-id", maxOccurs=-1, groupAs=@GroupAs(name="threat-ids", inJson=JsonGroupAsBehavior.LIST))
    private List<ThreatId> _threatIds;
    @BoundAssembly(formalName="Characterization", description="A collection of descriptive data about the containing object from a specific origin.", useName="characterization", maxOccurs=-1, groupAs=@GroupAs(name="characterizations", inJson=JsonGroupAsBehavior.LIST))
    private List<Characterization> _characterizations;
    @BoundAssembly(formalName="Mitigating Factor", description="Describes an existing mitigating factor that may affect the overall determination of the risk, with an optional link to an implementation statement in the SSP.", useName="mitigating-factor", maxOccurs=-1, groupAs=@GroupAs(name="mitigating-factors", inJson=JsonGroupAsBehavior.LIST))
    private List<MitigatingFactor> _mitigatingFactors;
    @BoundField(formalName="Risk Resolution Deadline", description="The date/time by which the risk must be resolved.", useName="deadline", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _deadline;
    @BoundAssembly(formalName="Risk Response", description="Describes either recommended or an actual plan for addressing the risk.", useName="response", maxOccurs=-1, groupAs=@GroupAs(name="remediations", inJson=JsonGroupAsBehavior.LIST))
    private List<Response> _remediations;
    @BoundAssembly(formalName="Risk Log", description="A log of all risk-related tasks taken.", useName="risk-log")
    private RiskLog _riskLog;
    @BoundAssembly(formalName="Related Observation", description="Relates the finding to a set of referenced observations that were used to determine the finding.", useName="related-observation", maxOccurs=-1, groupAs=@GroupAs(name="related-observations", inJson=JsonGroupAsBehavior.LIST))
    private List<RelatedObservation> _relatedObservations;

    public Risk() {
        this(null);
    }

    public Risk(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public MarkupMultiline getStatement() {
        return this._statement;
    }

    public void setStatement(MarkupMultiline value) {
        this._statement = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String value) {
        this._status = value;
    }

    public List<Origin> getOrigins() {
        return this._origins;
    }

    public void setOrigins(List<Origin> value) {
        this._origins = value;
    }

    public boolean addOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._origins == null) {
            this._origins = new LinkedList<Origin>();
        }
        return this._origins.add(value);
    }

    public boolean removeOrigin(Origin item) {
        Origin value = (Origin)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._origins != null && this._origins.remove(value);
    }

    public List<ThreatId> getThreatIds() {
        return this._threatIds;
    }

    public void setThreatIds(List<ThreatId> value) {
        this._threatIds = value;
    }

    public boolean addThreatId(ThreatId item) {
        ThreatId value = (ThreatId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._threatIds == null) {
            this._threatIds = new LinkedList<ThreatId>();
        }
        return this._threatIds.add(value);
    }

    public boolean removeThreatId(ThreatId item) {
        ThreatId value = (ThreatId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._threatIds != null && this._threatIds.remove(value);
    }

    public List<Characterization> getCharacterizations() {
        return this._characterizations;
    }

    public void setCharacterizations(List<Characterization> value) {
        this._characterizations = value;
    }

    public boolean addCharacterization(Characterization item) {
        Characterization value = (Characterization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._characterizations == null) {
            this._characterizations = new LinkedList<Characterization>();
        }
        return this._characterizations.add(value);
    }

    public boolean removeCharacterization(Characterization item) {
        Characterization value = (Characterization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._characterizations != null && this._characterizations.remove(value);
    }

    public List<MitigatingFactor> getMitigatingFactors() {
        return this._mitigatingFactors;
    }

    public void setMitigatingFactors(List<MitigatingFactor> value) {
        this._mitigatingFactors = value;
    }

    public boolean addMitigatingFactor(MitigatingFactor item) {
        MitigatingFactor value = (MitigatingFactor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._mitigatingFactors == null) {
            this._mitigatingFactors = new LinkedList<MitigatingFactor>();
        }
        return this._mitigatingFactors.add(value);
    }

    public boolean removeMitigatingFactor(MitigatingFactor item) {
        MitigatingFactor value = (MitigatingFactor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._mitigatingFactors != null && this._mitigatingFactors.remove(value);
    }

    public ZonedDateTime getDeadline() {
        return this._deadline;
    }

    public void setDeadline(ZonedDateTime value) {
        this._deadline = value;
    }

    public List<Response> getRemediations() {
        return this._remediations;
    }

    public void setRemediations(List<Response> value) {
        this._remediations = value;
    }

    public boolean addResponse(Response item) {
        Response value = (Response)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._remediations == null) {
            this._remediations = new LinkedList<Response>();
        }
        return this._remediations.add(value);
    }

    public boolean removeResponse(Response item) {
        Response value = (Response)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._remediations != null && this._remediations.remove(value);
    }

    public RiskLog getRiskLog() {
        return this._riskLog;
    }

    public void setRiskLog(RiskLog value) {
        this._riskLog = value;
    }

    public List<RelatedObservation> getRelatedObservations() {
        return this._relatedObservations;
    }

    public void setRelatedObservations(List<RelatedObservation> value) {
        this._relatedObservations = value;
    }

    public boolean addRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._relatedObservations == null) {
            this._relatedObservations = new LinkedList<RelatedObservation>();
        }
        return this._relatedObservations.add(value);
    }

    public boolean removeRelatedObservation(RelatedObservation item) {
        RelatedObservation value = (RelatedObservation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._relatedObservations != null && this._relatedObservations.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Mitigating Factor", description="Describes an existing mitigating factor that may affect the overall determination of the risk, with an optional link to an implementation statement in the SSP.", name="mitigating-factor", moduleClass=OscalAssessmentCommonModule.class)
    public static class MitigatingFactor
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Mitigating Factor Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this mitigating factor elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `mitigating factor` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundFlag(formalName="Implementation UUID", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this implementation statement elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope)s. The locally defined *UUID* of the `implementation statement` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="implementation-uuid", typeAdapter=UuidAdapter.class)
        private UUID _implementationUuid;
        @BoundField(formalName="Mitigating Factor Description", description="A human-readable description of this mitigating factor.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Identifies the Subject", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) identifier reference to a resource. Use type to indicate whether the identified resource is a component, inventory item, location, user, or something else.", useName="subject", remarks="Links identifiable elements of the system to this mitigating factor, such as an inventory-item or component.", maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
        private List<SubjectReference> _subjects;

        public MitigatingFactor() {
            this(null);
        }

        public MitigatingFactor(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public UUID getImplementationUuid() {
            return this._implementationUuid;
        }

        public void setImplementationUuid(UUID value) {
            this._implementationUuid = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<SubjectReference> getSubjects() {
            return this._subjects;
        }

        public void setSubjects(List<SubjectReference> value) {
            this._subjects = value;
        }

        public boolean addSubject(SubjectReference item) {
            SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._subjects == null) {
                this._subjects = new LinkedList<SubjectReference>();
            }
            return this._subjects.add(value);
        }

        public boolean removeSubject(SubjectReference item) {
            SubjectReference value = (SubjectReference)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._subjects != null && this._subjects.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Risk Log", description="A log of all risk-related tasks taken.", name="risk-log", moduleClass=OscalAssessmentCommonModule.class)
    public static class RiskLog
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Risk Log Entry", description="Identifies an individual risk response that occurred as part of managing an identified risk.", useName="entry", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="entries", inJson=JsonGroupAsBehavior.LIST))
        private List<Entry> _entries;

        public RiskLog() {
            this(null);
        }

        public RiskLog(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<Entry> getEntries() {
            return this._entries;
        }

        public void setEntries(List<Entry> value) {
            this._entries = value;
        }

        public boolean addEntry(Entry item) {
            Entry value = (Entry)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._entries == null) {
                this._entries = new LinkedList<Entry>();
            }
            return this._entries.add(value);
        }

        public boolean removeEntry(Entry item) {
            Entry value = (Entry)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._entries != null && this._entries.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Risk Log Entry", description="Identifies an individual risk response that occurred as part of managing an identified risk.", name="entry", moduleClass=OscalAssessmentCommonModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="type", description="The type of remediation tracking entry. Can be multi-valued.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type']/@value", allowOthers=true, values={@AllowedValue(value="vendor-check-in", description="Contacted vendor to determine the status of a pending fix to a known vulnerability."), @AllowedValue(value="status-update", description="Information related to the current state of response to this risk."), @AllowedValue(value="milestone-complete", description="A significant step in the response plan has been achieved."), @AllowedValue(value="mitigation", description="An activity was completed that reduces the likelihood or impact of this risk."), @AllowedValue(value="remediated", description="An activity was completed that eliminates the likelihood or impact of this risk."), @AllowedValue(value="closed", description="The risk is no longer applicable to the system."), @AllowedValue(value="dr-submission", description="A deviation request was made to the authorizing official."), @AllowedValue(value="dr-updated", description="A previously submitted deviation request has been modified."), @AllowedValue(value="dr-approved", description="The authorizing official approved the deviation."), @AllowedValue(value="dr-rejected", description="The authorizing official rejected the deviation.")})}))
        public static class Entry
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Risk Log Entry Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this risk log entry elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `risk log entry` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
            private UUID _uuid;
            @BoundField(formalName="Title", description="The title for this risk log entry.", useName="title", typeAdapter=MarkupLineAdapter.class)
            private MarkupLine _title;
            @BoundField(formalName="Risk Task Description", description="A human-readable description of what was done regarding the risk.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _description;
            @BoundField(formalName="Start", description="Identifies the start date and time of the event.", useName="start", minOccurs=1, typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _start;
            @BoundField(formalName="End", description="Identifies the end date and time of the event. If the event is a point in time, the start and end will be the same date and time.", useName="end", typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _end;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Logged By", description="Used to indicate who created a log entry in what role.", useName="logged-by", maxOccurs=-1, groupAs=@GroupAs(name="logged-by", inJson=JsonGroupAsBehavior.LIST))
            private List<LoggedBy> _loggedBy;
            @BoundField(formalName="Risk Status", description="Describes the status of the associated risk.", useName="status-change", remarks="Identifies a change in risk status made resulting from the task described by this risk log entry. This allows the risk's status history to be captured as a sequence of risk log entries.", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="open", description="The risk has been identified."), @AllowedValue(value="investigating", description="The identified risk is being investigated. (Open risk)"), @AllowedValue(value="remediating", description="Remediation activities are underway, but are not yet complete. (Open risk)"), @AllowedValue(value="deviation-requested", description="A risk deviation, such as false positive, risk reduction, or operational requirement has been submitted for approval. (Open risk)"), @AllowedValue(value="deviation-approved", description="A risk deviation, such as false positive, risk reduction, or operational requirement has been approved. (Open risk)"), @AllowedValue(value="closed", description="The risk has been resolved.")})}))
            private String _statusChange;
            @BoundAssembly(formalName="Risk Response Reference", description="Identifies an individual risk response that this log entry is for.", useName="related-response", maxOccurs=-1, groupAs=@GroupAs(name="related-responses", inJson=JsonGroupAsBehavior.LIST))
            private List<RelatedResponse> _relatedResponses;
            @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _remarks;

            public Entry() {
                this(null);
            }

            public Entry(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public UUID getUuid() {
                return this._uuid;
            }

            public void setUuid(UUID value) {
                this._uuid = value;
            }

            public MarkupLine getTitle() {
                return this._title;
            }

            public void setTitle(MarkupLine value) {
                this._title = value;
            }

            public MarkupMultiline getDescription() {
                return this._description;
            }

            public void setDescription(MarkupMultiline value) {
                this._description = value;
            }

            public ZonedDateTime getStart() {
                return this._start;
            }

            public void setStart(ZonedDateTime value) {
                this._start = value;
            }

            public ZonedDateTime getEnd() {
                return this._end;
            }

            public void setEnd(ZonedDateTime value) {
                this._end = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<LoggedBy> getLoggedBy() {
                return this._loggedBy;
            }

            public void setLoggedBy(List<LoggedBy> value) {
                this._loggedBy = value;
            }

            public boolean addLoggedBy(LoggedBy item) {
                LoggedBy value = (LoggedBy)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._loggedBy == null) {
                    this._loggedBy = new LinkedList<LoggedBy>();
                }
                return this._loggedBy.add(value);
            }

            public boolean removeLoggedBy(LoggedBy item) {
                LoggedBy value = (LoggedBy)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._loggedBy != null && this._loggedBy.remove(value);
            }

            public String getStatusChange() {
                return this._statusChange;
            }

            public void setStatusChange(String value) {
                this._statusChange = value;
            }

            public List<RelatedResponse> getRelatedResponses() {
                return this._relatedResponses;
            }

            public void setRelatedResponses(List<RelatedResponse> value) {
                this._relatedResponses = value;
            }

            public boolean addRelatedResponse(RelatedResponse item) {
                RelatedResponse value = (RelatedResponse)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._relatedResponses == null) {
                    this._relatedResponses = new LinkedList<RelatedResponse>();
                }
                return this._relatedResponses.add(value);
            }

            public boolean removeRelatedResponse(RelatedResponse item) {
                RelatedResponse value = (RelatedResponse)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._relatedResponses != null && this._relatedResponses.remove(value);
            }

            public MarkupMultiline getRemarks() {
                return this._remarks;
            }

            public void setRemarks(MarkupMultiline value) {
                this._remarks = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }

            @MetaschemaAssembly(formalName="Risk Response Reference", description="Identifies an individual risk response that this log entry is for.", name="related-response", moduleClass=OscalAssessmentCommonModule.class)
            public static class RelatedResponse
            implements IBoundObject {
                private final IMetaschemaData __metaschemaData;
                @BoundFlag(formalName="Response Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a unique risk response.", name="response-uuid", required=true, typeAdapter=UuidAdapter.class)
                private UUID _responseUuid;
                @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
                private List<Property> _props;
                @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
                private List<Link> _links;
                @BoundAssembly(formalName="Task Reference", description="Identifies an individual task for which the containing object is a consequence of.", useName="related-task", remarks="This is used to identify the task(s) that this log entry was generated for.", maxOccurs=-1, groupAs=@GroupAs(name="related-tasks", inJson=JsonGroupAsBehavior.LIST))
                private List<RelatedTask> _relatedTasks;
                @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
                private MarkupMultiline _remarks;

                public RelatedResponse() {
                    this(null);
                }

                public RelatedResponse(IMetaschemaData data) {
                    this.__metaschemaData = data;
                }

                public IMetaschemaData getMetaschemaData() {
                    return this.__metaschemaData;
                }

                public UUID getResponseUuid() {
                    return this._responseUuid;
                }

                public void setResponseUuid(UUID value) {
                    this._responseUuid = value;
                }

                public List<Property> getProps() {
                    return this._props;
                }

                public void setProps(List<Property> value) {
                    this._props = value;
                }

                public boolean addProp(Property item) {
                    Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    if (this._props == null) {
                        this._props = new LinkedList<Property>();
                    }
                    return this._props.add(value);
                }

                public boolean removeProp(Property item) {
                    Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    return this._props != null && this._props.remove(value);
                }

                public List<Link> getLinks() {
                    return this._links;
                }

                public void setLinks(List<Link> value) {
                    this._links = value;
                }

                public boolean addLink(Link item) {
                    Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    if (this._links == null) {
                        this._links = new LinkedList<Link>();
                    }
                    return this._links.add(value);
                }

                public boolean removeLink(Link item) {
                    Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    return this._links != null && this._links.remove(value);
                }

                public List<RelatedTask> getRelatedTasks() {
                    return this._relatedTasks;
                }

                public void setRelatedTasks(List<RelatedTask> value) {
                    this._relatedTasks = value;
                }

                public boolean addRelatedTask(RelatedTask item) {
                    RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    if (this._relatedTasks == null) {
                        this._relatedTasks = new LinkedList<RelatedTask>();
                    }
                    return this._relatedTasks.add(value);
                }

                public boolean removeRelatedTask(RelatedTask item) {
                    RelatedTask value = (RelatedTask)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                    return this._relatedTasks != null && this._relatedTasks.remove(value);
                }

                public MarkupMultiline getRemarks() {
                    return this._remarks;
                }

                public void setRemarks(MarkupMultiline value) {
                    this._remarks = value;
                }

                public String toString() {
                    return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
                }
            }
        }
    }

    @MetaschemaAssembly(formalName="Related Observation", description="Relates the finding to a set of referenced observations that were used to determine the finding.", name="related-observation", moduleClass=OscalAssessmentCommonModule.class)
    public static class RelatedObservation
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Observation Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an observation defined in the list of observations.", name="observation-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _observationUuid;

        public RelatedObservation() {
            this(null);
        }

        public RelatedObservation(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getObservationUuid() {
            return this._observationUuid;
        }

        public void setObservationUuid(UUID value) {
            this._observationUuid = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

