/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Security Impact Level", description="The overall level of expected impact resulting from unauthorized disclosure, modification, or loss of access to information.", name="security-impact-level", moduleClass=OscalSspModule.class)
public class SecurityImpactLevel
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Security Objective: Confidentiality", description="A target-level of confidentiality for the system, based on the sensitivity of information within the system.", useName="security-objective-confidentiality", minOccurs=1)
    private String _securityObjectiveConfidentiality;
    @BoundField(formalName="Security Objective: Integrity", description="A target-level of integrity for the system, based on the sensitivity of information within the system.", useName="security-objective-integrity", minOccurs=1)
    private String _securityObjectiveIntegrity;
    @BoundField(formalName="Security Objective: Availability", description="A target-level of availability for the system, based on the sensitivity of information within the system.", useName="security-objective-availability", minOccurs=1)
    private String _securityObjectiveAvailability;

    public SecurityImpactLevel() {
        this(null);
    }

    public SecurityImpactLevel(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getSecurityObjectiveConfidentiality() {
        return this._securityObjectiveConfidentiality;
    }

    public void setSecurityObjectiveConfidentiality(String value) {
        this._securityObjectiveConfidentiality = value;
    }

    public String getSecurityObjectiveIntegrity() {
        return this._securityObjectiveIntegrity;
    }

    public void setSecurityObjectiveIntegrity(String value) {
        this._securityObjectiveIntegrity = value;
    }

    public String getSecurityObjectiveAvailability() {
        return this._securityObjectiveAvailability;
    }

    public void setSecurityObjectiveAvailability(String value) {
        this._securityObjectiveAvailability = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

