/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Select Control", description="Used to select a control for inclusion/exclusion based on one or more control identifiers. A set of statement identifiers can be used to target the inclusion/exclusion to only specific control statements providing more granularity over the specific statements that are within the asessment scope.", name="select-control-by-id", moduleClass=OscalAssessmentCommonModule.class)
public class SelectControlById
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Identifier Reference", description="A reference to a control with a corresponding `id` value. When referencing an externally defined `control`, the `Control Identifier Reference` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference).", name="control-id", required=true, typeAdapter=TokenAdapter.class)
    private String _controlId;
    @BoundField(formalName="Include Specific Statements", description="Used to constrain the selection to only specificity identified statements.", useName="statement-id", maxOccurs=-1, groupAs=@GroupAs(name="statement-ids", inJson=JsonGroupAsBehavior.LIST), typeAdapter=TokenAdapter.class)
    private List<String> _statementIds;

    public SelectControlById() {
        this(null);
    }

    public SelectControlById(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getControlId() {
        return this._controlId;
    }

    public void setControlId(String value) {
        this._controlId = value;
    }

    public List<String> getStatementIds() {
        return this._statementIds;
    }

    public void setStatementIds(List<String> value) {
        this._statementIds = value;
    }

    public boolean addStatementId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._statementIds == null) {
            this._statementIds = new LinkedList<String>();
        }
        return this._statementIds.add(value);
    }

    public boolean removeStatementId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._statementIds != null && this._statementIds.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

